/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.externalge;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.PspGeList;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.Memory;
import jpcsp.State;
import jpcsp.graphics.RE.externalge.CoreThread;
import jpcsp.graphics.RE.externalge.NativeCallbacks;
import jpcsp.graphics.RE.externalge.NativeUtils;
import jpcsp.graphics.RE.externalge.RendererThread;
import jpcsp.graphics.capture.CaptureManager;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ExternalGE {
    public static final int numberRendererThread = 4;
    public static boolean activateWhenAvailable = false;
    public static final boolean useUnsafe = false;
    public static Logger log = Logger.getLogger((String)"externalge");
    private static ConcurrentLinkedQueue<PspGeList> drawListQueue;
    private static volatile PspGeList currentList;
    private static RendererThread[] rendererThreads;
    private static Semaphore rendererThreadsDone;
    private static Level logLevel;
    private static SetLogLevelThread setLogLevelThread;
    private static int screenScale;
    private static Object screenScaleLock;
    private static ExternalGESettingsListerner externalGESettingsListerner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void activate() {
        drawListQueue = new ConcurrentLinkedQueue();
        setLogLevelThread = new SetLogLevelThread();
        setLogLevelThread.setName("ExternelGE Set Log Level Thread");
        setLogLevelThread.setDaemon(true);
        setLogLevelThread.start();
        rendererThreads = new RendererThread[4];
        Object lineMasks = new int[4];
        switch (4) {
            case 1: {
                lineMasks[0] = -1;
                break;
            }
            case 2: {
                lineMasks[0] = -16711936;
                lineMasks[1] = 0xFF00FF;
                break;
            }
            case 3: {
                lineMasks[0] = -134090751;
                lineMasks[1] = 130027392;
                lineMasks[3] = 4063358;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                lineMasks[0] = -16777216;
                lineMasks[1] = 0xFF0000;
                lineMasks[2] = 65280;
                lineMasks[3] = 255;
                break;
            }
            default: {
                lineMasks[0] = -1073692672;
                lineMasks[1] = 0x30003000;
                lineMasks[2] = 0xC000C00;
                lineMasks[3] = 0x3000300;
                lineMasks[4] = 0xC000C0;
                lineMasks[5] = 0x300030;
                lineMasks[6] = 786444;
                lineMasks[7] = 196611;
            }
        }
        int allLineMasks = 0;
        for (int i = 0; i < rendererThreads.length; ++i) {
            int lineMask = lineMasks[i];
            ExternalGE.rendererThreads[i] = new RendererThread(lineMask);
            rendererThreads[i].setName(String.format("Renderer Thread #%d", i));
            rendererThreads[i].start();
            if ((allLineMasks & lineMask) != 0) {
                log.error((Object)String.format("Incorrect line masks for the renderer threads (number=%d)", 4));
            }
            allLineMasks |= lineMask;
        }
        if (allLineMasks != -1) {
            log.error((Object)String.format("Incorrect line masks for the renderer threads (number=%d)", 4));
        }
        rendererThreadsDone = new Semaphore(0);
        NativeUtils.setRendererAsyncRendering(true);
        ExternalGE.setScreenScale(sceDisplay.getResizedWidthPow2(1));
        Object object = screenScaleLock;
        lineMasks = object;
        synchronized (object) {
            NativeUtils.setScreenScale(ExternalGE.getScreenScale());
            // ** MonitorExit[lineMasks /* !! */ ] (shouldn't be in output)
            int maxTextureSize = Settings.getInstance().readInt("maxTextureSize", 512);
            int maxTextureSizeLog2 = 31 - Integer.numberOfLeadingZeros(maxTextureSize);
            NativeUtils.setMaxTextureSizeLog2(maxTextureSizeLog2);
            boolean doubleTexture2DCoords = Settings.getInstance().readBool("doubleTexture2DCoords");
            NativeUtils.setDoubleTexture2DCoords(doubleTexture2DCoords);
            return;
        }
    }

    private static void deactivate() {
        drawListQueue = null;
        if (setLogLevelThread != null) {
            setLogLevelThread.exit();
            setLogLevelThread = null;
        }
        CoreThread.exit();
        if (rendererThreads != null) {
            for (int i = 0; i < rendererThreads.length; ++i) {
                rendererThreads[i].exit();
            }
            rendererThreads = null;
        }
    }

    public static void init() {
        if (externalGESettingsListerner == null) {
            externalGESettingsListerner = new ExternalGESettingsListerner();
            Settings.getInstance().registerSettingsListener("ExternalGE", "emu.useExternalSoftwareRenderer", externalGESettingsListerner);
        }
        if (activateWhenAvailable) {
            NativeUtils.init();
            if (ExternalGE.isAvailable()) {
                ExternalGE.activate();
            }
        } else {
            ExternalGE.deactivate();
        }
    }

    public static void exit() {
        if (externalGESettingsListerner != null) {
            Settings.getInstance().removeSettingsListener("ExternalGE");
            externalGESettingsListerner = null;
        }
        if (ExternalGE.isActive()) {
            NativeUtils.exit();
            NativeCallbacks.exit();
            CoreThread.exit();
            setLogLevelThread.exit();
            for (int i = 0; i < rendererThreads.length; ++i) {
                rendererThreads[i].exit();
            }
        }
    }

    public static boolean isActive() {
        return activateWhenAvailable && ExternalGE.isAvailable();
    }

    public static boolean isAvailable() {
        return NativeUtils.isAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startList(PspGeList list) {
        if (list == null) {
            return;
        }
        ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = drawListQueue;
        synchronized (concurrentLinkedQueue) {
            if (currentList == null) {
                if (State.captureGeNextFrame) {
                    State.captureGeNextFrame = false;
                    CaptureManager.captureInProgress = true;
                    NativeUtils.setDumpFrames(true);
                    NativeUtils.setDumpTextures(true);
                    logLevel = log.getLevel();
                    log.setLevel(Level.TRACE);
                }
                if (list.hasSaveContextAddr()) {
                    ExternalGE.saveContext(list.getSaveContextAddr());
                }
                list.status = 2;
                NativeUtils.setLogLevel();
                NativeUtils.setCoreSadr(list.getStallAddr());
                NativeUtils.setCoreCtrlActive();
                Object object = screenScaleLock;
                synchronized (object) {
                    NativeUtils.setScreenScale(ExternalGE.getScreenScale());
                }
                currentList = list;
                currentList.sync();
                CoreThread.getInstance().sync();
            } else {
                drawListQueue.add(list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addListToHead(PspGeList list) {
        ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = drawListQueue;
        synchronized (concurrentLinkedQueue) {
            int arraySize = drawListQueue.size();
            if (arraySize > 0) {
                PspGeList[] array = drawListQueue.toArray(new PspGeList[arraySize]);
                ConcurrentLinkedQueue<PspGeList> newQueue = new ConcurrentLinkedQueue<PspGeList>();
                PspGeList[] newArray = new PspGeList[arraySize + 1];
                newArray[0] = list;
                for (int i = 0; i < arraySize; ++i) {
                    newArray[i + 1] = array[i];
                    newQueue.add(newArray[i]);
                }
                drawListQueue = newQueue;
            } else {
                drawListQueue.add(list);
            }
        }
    }

    public static void startListHead(PspGeList list) {
        if (list == null) {
            return;
        }
        if (currentList == null) {
            ExternalGE.startList(list);
        } else {
            ExternalGE.addListToHead(list);
        }
    }

    public static void onStallAddrUpdated(PspGeList list) {
        if (ExternalGE.isAvailable()) {
            // empty if block
        }
        if (ExternalGE.isActive()) {
            if (list == null) {
                return;
            }
            if (list == currentList) {
                NativeUtils.setCoreSadr(list.getStallAddr());
                CoreThread.getInstance().sync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRestartList(PspGeList list) {
        if (ExternalGE.isActive()) {
            if (list == null || list.isFinished()) {
                return;
            }
            ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = drawListQueue;
            synchronized (concurrentLinkedQueue) {
                if (list == currentList) {
                    list.status = 2;
                    NativeUtils.setCoreCtrlActive();
                    CoreThread.getInstance().sync();
                    list.sync();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishList(PspGeList list) {
        list.onGeListSyncDone();
        ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = drawListQueue;
        synchronized (concurrentLinkedQueue) {
            if (list == currentList) {
                if (CaptureManager.captureInProgress) {
                    log.setLevel(logLevel);
                    NativeUtils.setDumpFrames(false);
                    NativeUtils.setDumpTextures(false);
                    NativeUtils.setLogLevel();
                    CaptureManager.captureInProgress = false;
                    Emulator.PauseEmu();
                }
                if (list.hasSaveContextAddr()) {
                    ExternalGE.restoreContext(list.getSaveContextAddr());
                }
                currentList = null;
            } else {
                drawListQueue.remove(list);
            }
        }
        if (currentList == null) {
            ExternalGE.startList(drawListQueue.poll());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PspGeList getLastDrawList() {
        PspGeList lastList = null;
        ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = drawListQueue;
        synchronized (concurrentLinkedQueue) {
            for (PspGeList list : drawListQueue) {
                if (list == null) continue;
                lastList = list;
            }
            if (lastList == null) {
                lastList = currentList;
            }
        }
        return lastList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PspGeList getFirstDrawList() {
        PspGeList firstList;
        ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = drawListQueue;
        synchronized (concurrentLinkedQueue) {
            firstList = currentList;
            if (firstList == null) {
                firstList = drawListQueue.peek();
            }
        }
        return firstList;
    }

    public static PspGeList getCurrentList() {
        return currentList;
    }

    public static void onGeStartWaitList() {
        if (ExternalGE.isAvailable()) {
            // empty if block
        }
    }

    public static void onGeStopWaitList() {
        if (ExternalGE.isAvailable()) {
            // empty if block
        }
    }

    public static void onDisplayStartWaitVblank() {
        if (ExternalGE.isAvailable()) {
            // empty if block
        }
    }

    public static void onDisplayStopWaitVblank() {
        if (ExternalGE.isAvailable()) {
            // empty if block
        }
    }

    public static void onDisplayVblank() {
        if (ExternalGE.isAvailable()) {
            // empty if block
        }
    }

    public static void onGeStartList(PspGeList list) {
        if (ExternalGE.isAvailable()) {
            // empty if block
        }
    }

    public static void onGeFinishList(PspGeList list) {
        if (ExternalGE.isAvailable()) {
            // empty if block
        }
    }

    public static void render() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("ExternalGE starting rendering", new Object[0]));
        }
        for (int i = 0; i < rendererThreads.length; ++i) {
            rendererThreads[i].sync(rendererThreadsDone);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Waiting for async rendering completion", new Object[0]));
            }
            rendererThreadsDone.acquire(rendererThreads.length);
        }
        catch (InterruptedException e) {
            log.error((Object)"render", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Async rendering completion", new Object[0]));
        }
        NativeUtils.rendererTerminate();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("ExternalGE terminating rendering", new Object[0]));
        }
    }

    public static int saveContext(int addr) {
        if (NativeUtils.isCoreCtrlActive()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Saving Core context to 0x%08X - Core busy", addr));
            }
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Saving Core context to 0x%08X", addr));
        }
        NativeUtils.saveCoreContext(addr);
        return 0;
    }

    public static int restoreContext(int addr) {
        if (NativeUtils.isCoreCtrlActive()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Restoring Core context from 0x%08X - Core busy", addr));
            }
            return -2147483615;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Restoring Core context from 0x%08X", addr));
        }
        NativeUtils.restoreCoreContext(addr);
        return 0;
    }

    public static int getCmd(int cmd) {
        return NativeUtils.getCoreCmdArray(cmd);
    }

    public static void setCmd(int cmd, int value) {
        NativeUtils.setCoreCmdArray(cmd, value);
    }

    public static void interpretCmd(int cmd, int value) {
        NativeUtils.interpretCoreCmd(cmd, value, NativeUtils.getCoreMadr());
    }

    private static int getMatrixOffset(int mtxType) {
        int offset = mtxType * 12;
        if (mtxType > 10) {
            offset += 4;
        }
        return offset;
    }

    private static int getMatrixSize(int mtxType) {
        return mtxType == 10 ? 16 : 12;
    }

    public static float[] getMatrix(int mtxType) {
        int size = ExternalGE.getMatrixSize(mtxType);
        int offset = ExternalGE.getMatrixOffset(mtxType);
        float[] mtx = new float[size];
        for (int i = 0; i < size; ++i) {
            mtx[i] = NativeUtils.getCoreMtxArray(offset + i);
        }
        return mtx;
    }

    public static void setMatrix(int mtxType, int offset, float value) {
        NativeUtils.setCoreMtxArray(ExternalGE.getMatrixOffset(mtxType) + offset, value);
    }

    public static int getScreenScale() {
        return screenScale;
    }

    public static void setScreenScale(int screenScale) {
        log.info((Object)String.format("Setting screen scale to factor %d", screenScale));
        ExternalGE.screenScale = screenScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer getScaledScreen(int address, int bufferWidth, int height, int pixelFormat) {
        Object object = screenScaleLock;
        synchronized (object) {
            return NativeUtils.getScaledScreen(address, bufferWidth, height, pixelFormat);
        }
    }

    public static void addVideoTexture(int destinationAddress, int sourceAddress, int length) {
        NativeUtils.addVideoTexture(destinationAddress, sourceAddress, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onGeUserStop() {
        ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = drawListQueue;
        synchronized (concurrentLinkedQueue) {
            drawListQueue.clear();
            if (currentList != null) {
                currentList.sync();
            }
            currentList = null;
            CoreThread.getInstance().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasDrawList(int listAddr, int stackAddr) {
        boolean waitAndRetry;
        boolean result;
        block12: {
            result = false;
            waitAndRetry = false;
            ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = drawListQueue;
            synchronized (concurrentLinkedQueue) {
                block11: {
                    if (currentList == null || !currentList.isInUse(listAddr, stackAddr)) break block11;
                    result = true;
                    if (!currentList.isFinished()) break block12;
                    waitAndRetry = true;
                    break block12;
                }
                for (PspGeList list : drawListQueue) {
                    if (list == null || !list.isInUse(listAddr, stackAddr)) continue;
                    result = true;
                    break;
                }
            }
        }
        if (waitAndRetry) {
            for (int i = 0; i < 100; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hasDrawList(0x%08X) waiting on finished list %s", listAddr, currentList));
                }
                Utilities.sleep(1, 0);
                ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = drawListQueue;
                synchronized (concurrentLinkedQueue) {
                    if (currentList == null || ExternalGE.currentList.list_addr != listAddr) {
                        result = false;
                        break;
                    }
                    continue;
                }
            }
        }
        return result;
    }

    public static boolean isGeAddress(int address) {
        return Memory.isVRAM(address);
    }

    public static boolean isInsideRendering() {
        if (CoreThread.getInstance().isInsideRendering()) {
            return true;
        }
        if (currentList == null) {
            return false;
        }
        if (currentList.isStallReached()) {
            return false;
        }
        return ExternalGE.currentList.status != 4;
    }

    static {
        screenScale = 1;
        screenScaleLock = new Object();
    }

    private static class ExternalGESettingsListerner
    extends AbstractBoolSettingsListener {
        private ExternalGESettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            activateWhenAvailable = value;
            ExternalGE.init();
        }
    }

    private static class SetLogLevelThread
    extends Thread {
        private volatile boolean exit;

        private SetLogLevelThread() {
        }

        public void exit() {
            this.exit = true;
        }

        @Override
        public void run() {
            while (!this.exit) {
                NativeUtils.setLogLevel();
                Utilities.sleep(100);
            }
        }
    }
}

