/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.hardware;

import java.awt.AWTException;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.Robot;
import jpcsp.Emulator;

public class Screen {
    private static DisableScreenSaverThread disableScreenSaverThread;
    public static final int width = 480;
    public static final int height = 272;
    private static int brightnessLevel;
    private static long lastPowerTick;
    private static boolean hasScreen;

    public static void hleKernelPowerTick() {
        lastPowerTick = Screen.getClockMillis();
    }

    public static void start() {
        lastPowerTick = Screen.getClockMillis();
        if (disableScreenSaverThread == null) {
            disableScreenSaverThread = new DisableScreenSaverThread();
            disableScreenSaverThread.setName("Disable Screen Saver");
            disableScreenSaverThread.setDaemon(true);
            disableScreenSaverThread.start();
        }
    }

    private static long getClockMillis() {
        return Emulator.getClock().milliTime();
    }

    public static void exit() {
        if (disableScreenSaverThread != null) {
            disableScreenSaverThread.exit();
        }
    }

    public static boolean hasScreen() {
        return hasScreen;
    }

    public static void setHasScreen(boolean hasScreen) {
        Screen.hasScreen = hasScreen;
    }

    public static int getBrightnessLevel() {
        return brightnessLevel;
    }

    public static void setBrightnessLevel(int brightnessLevel) {
        Screen.brightnessLevel = brightnessLevel;
    }

    static {
        brightnessLevel = 100;
        hasScreen = true;
    }

    private static class DisableScreenSaverThread
    extends Thread {
        private volatile boolean exit;
        private static final int tickMillis = 60000;

        private DisableScreenSaverThread() {
        }

        public void exit() {
            this.exit = true;
        }

        @Override
        public void run() {
            try {
                Robot robot = new Robot();
                while (!this.exit) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    long now = Screen.getClockMillis();
                    if (now - lastPowerTick < 60000L) {
                        if (Emulator.log.isTraceEnabled()) {
                            Emulator.log.trace((Object)String.format("Moving the mouse to disable the screen saver (PowerTick since %d ms)", now - lastPowerTick));
                        }
                        robot.waitForIdle();
                        PointerInfo mouseInfo = MouseInfo.getPointerInfo();
                        robot.mouseMove(mouseInfo.getLocation().x, mouseInfo.getLocation().y);
                        continue;
                    }
                    if (!Emulator.log.isTraceEnabled()) continue;
                    Emulator.log.trace((Object)String.format("PowerTick not called since %d ms", now - lastPowerTick));
                }
            }
            catch (AWTException e) {
                Emulator.log.error((Object)e);
            }
        }
    }
}

