/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.hardware;

import java.io.IOException;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.sceNet;
import jpcsp.HLE.modules.sceUtility;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class Wlan {
    private static final int STATE_VERSION = 0;
    private static Logger log = Emulator.log;
    public static int PSP_WLAN_SWITCH_OFF = 0;
    public static int PSP_WLAN_SWITCH_ON;
    private static int switchState;
    public static final int MAC_ADDRESS_LENGTH = 6;
    private static byte[] macAddress;
    private static final String settingsMacAddress = "macAddress";
    public static int PSP_ADHOC_CHANNEL_AUTO;
    public static int PSP_ADHOC_CHANNEL_DEFAULT;
    private static int signalStrength;
    private static WlanSwitchSettingsListener wlanSwitchSettingsListener;

    public static void initialize() {
        String macAddressString = Settings.getInstance().readString(settingsMacAddress);
        if (macAddressString == null || macAddressString.length() <= 0) {
            macAddress = pspNetMacAddress.getRandomMacAddress();
        } else {
            macAddress = sceNet.convertStringToMacAddress(macAddressString);
            macAddress[0] = (byte)(macAddress[0] & 0xFC);
        }
        if (wlanSwitchSettingsListener == null) {
            wlanSwitchSettingsListener = new WlanSwitchSettingsListener();
            Settings.getInstance().registerSettingsListener("WlanSwitch", "network.wlanSwitchOn", wlanSwitchSettingsListener);
        }
    }

    public static int getSwitchState() {
        return switchState;
    }

    public static void setSwitchState(int switchState) {
        Wlan.switchState = switchState;
        log.info((Object)String.format("WLAN Switch %s", switchState == PSP_WLAN_SWITCH_OFF ? "off" : "on"));
    }

    public static byte[] getMacAddress() {
        return macAddress;
    }

    public static void setMacAddress(byte[] newMacAddress) {
        System.arraycopy(newMacAddress, 0, macAddress, 0, 6);
    }

    public static int getAdhocChannel() {
        int channel = sceUtility.getSystemParamAdhocChannel();
        if (channel == PSP_ADHOC_CHANNEL_AUTO) {
            channel = PSP_ADHOC_CHANNEL_DEFAULT;
        }
        return channel;
    }

    public static int getSignalStrenth() {
        return signalStrength;
    }

    public static void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        byte[] stateMacAddress = new byte[6];
        stream.read(stateMacAddress);
        Wlan.setMacAddress(stateMacAddress);
    }

    public static void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.write(Wlan.getMacAddress());
    }

    static {
        switchState = PSP_WLAN_SWITCH_ON = 1;
        macAddress = new byte[]{1, 2, 3, 4, 5, 6};
        PSP_ADHOC_CHANNEL_AUTO = 0;
        PSP_ADHOC_CHANNEL_DEFAULT = 11;
        signalStrength = 100;
    }

    private static class WlanSwitchSettingsListener
    extends AbstractBoolSettingsListener {
        private WlanSwitchSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            Wlan.setSwitchState(value ? PSP_WLAN_SWITCH_ON : PSP_WLAN_SWITCH_OFF);
        }
    }
}

