/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.aac;

import java.util.Arrays;
import jpcsp.media.codec.aac.AacDecoder;
import jpcsp.media.codec.aac.AacPsData;
import jpcsp.media.codec.aac.Context;
import jpcsp.media.codec.aac.PSContext;
import jpcsp.media.codec.aac.PSDSP;
import jpcsp.media.codec.util.BitReader;
import jpcsp.media.codec.util.CodecUtils;
import jpcsp.media.codec.util.VLC;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class AacPs {
    private static Logger log = AacDecoder.log;
    private static final int numQMFSlots = 32;
    private static final int[][] numEnv_tab = new int[][]{{0, 1, 2, 4}, {1, 2, 3, 4}};
    private static final int[] nr_iidiccPar_tab = new int[]{10, 20, 34, 10, 20, 34};
    private static final int[] nr_iidopdPar_tab = new int[]{5, 11, 17, 5, 11, 17};
    private static final int huff_iid_df1 = 0;
    private static final int huff_iid_dt1 = 1;
    private static final int huff_iid_df0 = 2;
    private static final int huff_iid_dt0 = 3;
    private static final int huff_icc_df = 4;
    private static final int huff_icc_dt = 5;
    private static final int huff_ipd_df = 6;
    private static final int huff_ipd_dt = 7;
    private static final int huff_opd_df = 8;
    private static final int huff_opd_dt = 9;
    private static final int[] huff_iid = new int[]{2, 0, 3, 1};
    private static VLC[] vlc_ps = new VLC[10];
    private static final float DECAY_SLOPE = 0.05f;
    private static final int[] NR_PAR_BANDS = new int[]{20, 34};
    private static final int[] NR_IPDOPD_BANDS = new int[]{11, 17};
    private static final int[] NR_BANDS = new int[]{71, 91};
    private static final int[] DECAY_CUTOFF = new int[]{10, 32};
    private static final int[] NR_ALLPASS_BANDS = new int[]{30, 50};
    private static final int[] SHORT_DELAY_BAND = new int[]{42, 62};

    public static void init() {
        for (int i = 0; i < vlc_ps.length; ++i) {
            AacPs.vlc_ps[i] = new VLC();
        }
        vlc_ps[0].initVLCSparse(9, AacPsData.huff_iid_df1_codes.length, AacPsData.huff_iid_df1_bits, AacPsData.huff_iid_df1_codes, null);
        vlc_ps[1].initVLCSparse(9, AacPsData.huff_iid_dt1_codes.length, AacPsData.huff_iid_dt1_bits, AacPsData.huff_iid_dt1_codes, null);
        vlc_ps[2].initVLCSparse(9, AacPsData.huff_iid_df0_codes.length, AacPsData.huff_iid_df0_bits, AacPsData.huff_iid_df0_codes, null);
        vlc_ps[3].initVLCSparse(9, AacPsData.huff_iid_dt0_codes.length, AacPsData.huff_iid_dt0_bits, AacPsData.huff_iid_dt0_codes, null);
        vlc_ps[4].initVLCSparse(9, AacPsData.huff_icc_df_codes.length, AacPsData.huff_icc_df_bits, AacPsData.huff_icc_df_codes, null);
        vlc_ps[5].initVLCSparse(9, AacPsData.huff_icc_dt_codes.length, AacPsData.huff_icc_dt_bits, AacPsData.huff_icc_dt_codes, null);
        vlc_ps[6].initVLCSparse(9, AacPsData.huff_ipd_df_codes.length, AacPsData.huff_ipd_df_bits, AacPsData.huff_ipd_df_codes, null);
        vlc_ps[7].initVLCSparse(9, AacPsData.huff_ipd_dt_codes.length, AacPsData.huff_ipd_dt_bits, AacPsData.huff_ipd_dt_codes, null);
        vlc_ps[8].initVLCSparse(9, AacPsData.huff_opd_df_codes.length, AacPsData.huff_opd_df_bits, AacPsData.huff_opd_df_codes, null);
        vlc_ps[9].initVLCSparse(9, AacPsData.huff_opd_dt_codes.length, AacPsData.huff_opd_dt_bits, AacPsData.huff_opd_dt_codes, null);
    }

    private static int readDataError(Context ac, PSContext ps, int bitCountStart, int bitsLeft) {
        ps.start = false;
        int bitsRead = ac.br.getBitsRead() - bitCountStart;
        if (bitsRead < bitsLeft) {
            ac.br.skip(bitsLeft - bitsRead);
        }
        Utilities.fill(ps.iidPar, 0);
        Utilities.fill(ps.iccPar, 0);
        Utilities.fill(ps.ipdPar, 0);
        Utilities.fill(ps.opdPar, 0);
        return bitsLeft;
    }

    private static int readParData(Context ac, PSContext ps, int[][] par, int tableIdx, int e, boolean dt, int num, int offset, int mask) {
        VLC vlc = vlc_ps[tableIdx];
        if (dt) {
            int ePrev = e != 0 ? e - 1 : ps.numEnvOld - 1;
            ePrev = Math.max(ePrev, 0);
            for (int b = 0; b < num; ++b) {
                int val = par[ePrev][b] + vlc.getVLC2(ac.br, 3) - offset;
                if (mask != 0) {
                    val &= mask;
                }
                par[e][b] = val;
            }
        } else {
            int val = 0;
            for (int b = 0; b < num; ++b) {
                val += vlc.getVLC2(ac.br, 3) - offset;
                if (mask != 0) {
                    val &= mask;
                }
                par[e][b] = val;
            }
        }
        return 0;
    }

    private static int readIidData(Context ac, PSContext ps, int[][] iid, int tableIdx, int e, boolean dt) {
        return AacPs.readParData(ac, ps, iid, tableIdx, e, dt, ps.nrIidPar, AacPsData.huff_offset[tableIdx], 0);
    }

    private static int readIccData(Context ac, PSContext ps, int[][] iid, int tableIdx, int e, boolean dt) {
        return AacPs.readParData(ac, ps, iid, tableIdx, e, dt, ps.nrIccPar, AacPsData.huff_offset[tableIdx], 0);
    }

    private static int readIpdopdData(Context ac, PSContext ps, int[][] iid, int tableIdx, int e, boolean dt) {
        return AacPs.readParData(ac, ps, iid, tableIdx, e, dt, ps.nrIpdopdPar, 0, 7);
    }

    private static int readExtensionData(Context ac, PSContext ps, int psExtensionId) {
        int count = ac.br.getBitsRead();
        if (psExtensionId != 0) {
            return 0;
        }
        ps.enableIpdopd = ac.br.readBool();
        if (ps.enableIpdopd) {
            for (int e = 0; e < ps.numEnv; ++e) {
                boolean dt = ac.br.readBool();
                AacPs.readIpdopdData(ac, ps, ps.ipdPar, dt ? 7 : 6, e, dt);
                dt = ac.br.readBool();
                AacPs.readIpdopdData(ac, ps, ps.opdPar, dt ? 9 : 8, e, dt);
            }
        }
        ac.br.skip(1);
        return ac.br.getBitsRead() - count;
    }

    public static int readData(Context ac, PSContext ps, int bitsLeft) {
        int bitsConsumed;
        boolean dt;
        int e;
        BitReader br = ac.br;
        int bitCountStart = br.getBitsRead();
        boolean header = br.readBool();
        if (header) {
            ps.enableIid = br.readBool();
            if (ps.enableIid) {
                int iidMode = br.read(3);
                if (iidMode > 5) {
                    log.error((Object)String.format("iidMode %d is reserved", iidMode));
                    return AacPs.readDataError(ac, ps, bitCountStart, bitsLeft);
                }
                ps.nrIidPar = nr_iidiccPar_tab[iidMode];
                ps.iidQuant = iidMode > 2 ? 1 : 0;
                ps.nrIpdopdPar = nr_iidopdPar_tab[iidMode];
            }
            ps.enableIcc = br.readBool();
            if (ps.enableIcc) {
                ps.iccMode = br.read(3);
                if (ps.iccMode > 5) {
                    log.error((Object)String.format("iic_mode %d is reserved", ps.iccMode));
                    return AacPs.readDataError(ac, ps, bitCountStart, bitsLeft);
                }
                ps.nrIccPar = nr_iidiccPar_tab[ps.iccMode];
            }
            ps.enableExt = br.readBool();
        }
        ps.frameClass = br.read1();
        ps.numEnvOld = ps.numEnv;
        ps.numEnv = numEnv_tab[ps.frameClass][br.read(2)];
        ps.borderPosition[0] = -1;
        if (ps.frameClass != 0) {
            for (e = 1; e <= ps.numEnv; ++e) {
                ps.borderPosition[e] = br.read(5);
            }
        } else {
            for (e = 1; e <= ps.numEnv; ++e) {
                ps.borderPosition[e] = (e * 32 >> CodecUtils.ff_log2_tab[ps.numEnv]) - 1;
            }
        }
        if (ps.enableIid) {
            for (e = 0; e < ps.numEnv; ++e) {
                dt = br.readBool();
                if (AacPs.readIidData(ac, ps, ps.iidPar, huff_iid[(dt ? 2 : 0) + ps.iidQuant], e, dt) == 0) continue;
                return AacPs.readDataError(ac, ps, bitCountStart, bitsLeft);
            }
        } else {
            Utilities.fill(ps.iidPar, 0);
        }
        if (ps.enableIcc) {
            for (e = 0; e < ps.numEnv; ++e) {
                dt = br.readBool();
                if (AacPs.readIccData(ac, ps, ps.iccPar, dt ? 5 : 4, e, dt) == 0) continue;
                return AacPs.readDataError(ac, ps, bitCountStart, bitsLeft);
            }
        } else {
            Utilities.fill(ps.iccPar, 0);
        }
        if (ps.enableExt) {
            int cnt = br.read(4);
            if (cnt == 15) {
                cnt += br.read(8);
            }
            cnt *= 8;
            while (cnt > 7) {
                int psExtensionId = br.read(2);
                cnt -= 2 + AacPs.readExtensionData(ac, ps, psExtensionId);
            }
            if (cnt < 0) {
                log.error((Object)String.format("ps extension overflow %d", cnt));
                return AacPs.readDataError(ac, ps, bitCountStart, bitsLeft);
            }
            br.skip(cnt);
        }
        if (ps.numEnv == 0 || ps.borderPosition[ps.numEnv] < 31) {
            int b;
            int source;
            int n = source = ps.numEnv != 0 ? ps.numEnv - 1 : ps.numEnvOld - 1;
            if (source >= 0 && source != ps.numEnv) {
                if (ps.enableIid) {
                    System.arraycopy(ps.iidPar[source], 0, ps.iidPar[ps.numEnv], 0, ps.iidPar[0].length);
                }
                if (ps.enableIcc) {
                    System.arraycopy(ps.iccPar[source], 0, ps.iccPar[ps.numEnv], 0, ps.iccPar[0].length);
                }
                if (ps.enableIpdopd) {
                    System.arraycopy(ps.ipdPar[source], 0, ps.ipdPar[ps.numEnv], 0, ps.ipdPar[0].length);
                    System.arraycopy(ps.opdPar[source], 0, ps.opdPar[ps.numEnv], 0, ps.opdPar[0].length);
                }
            }
            if (ps.enableIid) {
                for (b = 0; b < ps.nrIidPar; ++b) {
                    if (Math.abs(ps.iidPar[ps.numEnv][b]) <= 7 + 8 * ps.iidQuant) continue;
                    log.error((Object)String.format("iidPar invalid", new Object[0]));
                    return AacPs.readDataError(ac, ps, bitCountStart, bitsLeft);
                }
            }
            if (ps.enableIcc) {
                for (b = 0; b < ps.nrIidPar; ++b) {
                    if (Math.abs(ps.iccPar[ps.numEnv][b]) <= 7) continue;
                    log.error((Object)String.format("iccPar invalid", new Object[0]));
                    return AacPs.readDataError(ac, ps, bitCountStart, bitsLeft);
                }
            }
            ++ps.numEnv;
            ps.borderPosition[ps.numEnv] = 31;
        }
        ps.is34bandsOld = ps.is34bands;
        if (ps.enableIid || ps.enableIcc) {
            boolean bl = ps.is34bands = ps.enableIid && ps.nrIidPar == 34 || ps.enableIcc && ps.nrIccPar == 34;
        }
        if (!ps.enableIpdopd) {
            Utilities.fill(ps.ipdPar, 0);
            Utilities.fill(ps.opdPar, 0);
        }
        if (header) {
            ps.start = true;
        }
        if ((bitsConsumed = br.getBitsRead() - bitCountStart) > bitsLeft) {
            log.error((Object)String.format("Expected to read %d PS bits actually read %d", bitsLeft, bitsConsumed));
            return AacPs.readDataError(ac, ps, bitCountStart, bitsLeft);
        }
        return bitsConsumed;
    }

    private static void hybrid2_re(float[][] in, float[][][] out, int outOffset, float[] filter, int len, int reverse) {
        int inOffset = 0;
        int i = 0;
        while (i < len) {
            float re_in = filter[6] * in[inOffset + 6][0];
            float re_op = 0.0f;
            float im_in = filter[6] * in[inOffset + 6][1];
            float im_op = 0.0f;
            for (int j = 0; j < 6; j += 2) {
                re_op += filter[j + 1] * (in[j + 1][0] + in[12 - j - 1][0]);
                im_op += filter[j + 1] * (in[j + 1][1] + in[12 - j - 1][1]);
            }
            out[outOffset + reverse][i][0] = re_in + re_op;
            out[outOffset + reverse][i][1] = im_in + im_op;
            out[outOffset + 1 - reverse][i][0] = re_in - re_op;
            out[outOffset + 1 - reverse][i][1] = im_in - im_op;
            ++i;
            ++inOffset;
        }
    }

    private static void hybrid6_cx(float[][] in, float[][][] out, int outOffset, float[][][] filter, int len) {
        int N = 8;
        float[][] temp = new float[8][2];
        int inOffset = 0;
        int i = 0;
        while (i < len) {
            PSDSP.hybrid_analysis(temp, 0, in, inOffset, filter, 0, 1, 8);
            out[outOffset + 0][i][0] = temp[6][0];
            out[outOffset + 0][i][1] = temp[6][1];
            out[outOffset + 1][i][0] = temp[7][0];
            out[outOffset + 1][i][1] = temp[7][1];
            out[outOffset + 2][i][0] = temp[0][0];
            out[outOffset + 2][i][1] = temp[0][1];
            out[outOffset + 3][i][0] = temp[1][0];
            out[outOffset + 3][i][1] = temp[1][1];
            out[outOffset + 4][i][0] = temp[2][0] + temp[5][0];
            out[outOffset + 4][i][1] = temp[2][1] + temp[5][1];
            out[outOffset + 5][i][0] = temp[3][0] + temp[4][0];
            out[outOffset + 5][i][1] = temp[3][1] + temp[4][1];
            ++i;
            ++inOffset;
        }
    }

    private static void hybrid4_8_12_cx(float[][] in, float[][][] out, int outOffset, float[][][] filter, int N, int len) {
        int inOffset = 0;
        int i = 0;
        while (i < len) {
            PSDSP.hybrid_analysis(out[outOffset], i, in, inOffset, filter, 0, 32, N);
            ++i;
            ++inOffset;
        }
    }

    private static void hybrid_analysis(float[][][] out, float[][][] in, float[][][] L, boolean is34, int len) {
        int j;
        int i;
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 38; ++j) {
                in[i][j + 6][0] = L[0][j][i];
                in[i][j + 6][1] = L[1][j][i];
            }
        }
        if (is34) {
            AacPs.hybrid4_8_12_cx(in[0], out, 0, AacPsData.f34_0_12, 12, len);
            AacPs.hybrid4_8_12_cx(in[1], out, 12, AacPsData.f34_1_8, 8, len);
            AacPs.hybrid4_8_12_cx(in[2], out, 20, AacPsData.f34_2_4, 4, len);
            AacPs.hybrid4_8_12_cx(in[3], out, 24, AacPsData.f34_2_4, 4, len);
            AacPs.hybrid4_8_12_cx(in[4], out, 28, AacPsData.f34_2_4, 4, len);
            PSDSP.hybrid_analysis_ileave(out, 27, L, 0, 5, len);
        } else {
            AacPs.hybrid6_cx(in[0], out, 0, AacPsData.f20_0_8, len);
            AacPs.hybrid2_re(in[1], out, 6, AacPsData.g1_Q2, len, 1);
            AacPs.hybrid2_re(in[2], out, 8, AacPsData.g1_Q2, len, 0);
            PSDSP.hybrid_analysis_ileave(out, 7, L, 0, 3, len);
        }
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 6; ++j) {
                System.arraycopy(in[i][j + 32], 0, in[i][j], 0, in[i][0].length);
            }
        }
    }

    static void hybrid_synthesis(float[][][] out, float[][][] in, boolean is34, int len) {
        if (is34) {
            for (int n = 0; n < len; ++n) {
                int i;
                Arrays.fill(out[0][n], 0, 5, 0.0f);
                Arrays.fill(out[1][n], 0, 5, 0.0f);
                for (i = 0; i < 12; ++i) {
                    float[] fArray = out[0][n];
                    fArray[0] = fArray[0] + in[i][n][0];
                    float[] fArray2 = out[1][n];
                    fArray2[0] = fArray2[0] + in[i][n][1];
                }
                for (i = 0; i < 8; ++i) {
                    float[] fArray = out[0][n];
                    fArray[1] = fArray[1] + in[12 + i][n][0];
                    float[] fArray3 = out[1][n];
                    fArray3[1] = fArray3[1] + in[12 + i][n][1];
                }
                for (i = 0; i < 4; ++i) {
                    float[] fArray = out[0][n];
                    fArray[2] = fArray[2] + in[20 + i][n][0];
                    float[] fArray4 = out[1][n];
                    fArray4[2] = fArray4[2] + in[20 + i][n][1];
                    float[] fArray5 = out[0][n];
                    fArray5[3] = fArray5[3] + in[24 + i][n][0];
                    float[] fArray6 = out[1][n];
                    fArray6[3] = fArray6[3] + in[24 + i][n][1];
                    float[] fArray7 = out[0][n];
                    fArray7[4] = fArray7[4] + in[28 + i][n][0];
                    float[] fArray8 = out[1][n];
                    fArray8[4] = fArray8[4] + in[28 + i][n][1];
                }
            }
            PSDSP.hybrid_synthesis_deint(out, in, 27, 5, len);
        } else {
            for (int n = 0; n < len; ++n) {
                out[0][n][0] = in[0][n][0] + in[1][n][0] + in[2][n][0] + in[3][n][0] + in[4][n][0] + in[5][n][0];
                out[1][n][0] = in[0][n][1] + in[1][n][1] + in[2][n][1] + in[3][n][1] + in[4][n][1] + in[5][n][1];
                out[0][n][1] = in[6][n][0] + in[7][n][0];
                out[1][n][1] = in[6][n][1] + in[7][n][1];
                out[0][n][2] = in[8][n][0] + in[9][n][0];
                out[1][n][2] = in[8][n][1] + in[9][n][1];
            }
            PSDSP.hybrid_synthesis_deint(out, in, 7, 3, len);
        }
    }

    static void map_idx_10_to_20(int[] par_mapped, int[] par, boolean full) {
        int b;
        if (full) {
            b = 9;
        } else {
            b = 4;
            par_mapped[10] = 0;
        }
        while (b >= 0) {
            int n = par[b];
            par_mapped[2 * b] = n;
            par_mapped[2 * b + 1] = n;
            --b;
        }
    }

    static void map_idx_34_to_20(int[] par_mapped, int[] par, boolean full) {
        par_mapped[0] = (2 * par[0] + par[1]) / 3;
        par_mapped[1] = (par[1] + 2 * par[2]) / 3;
        par_mapped[2] = (2 * par[3] + par[4]) / 3;
        par_mapped[3] = (par[4] + 2 * par[5]) / 3;
        par_mapped[4] = (par[6] + par[7]) / 2;
        par_mapped[5] = (par[8] + par[9]) / 2;
        par_mapped[6] = par[10];
        par_mapped[7] = par[11];
        par_mapped[8] = (par[12] + par[13]) / 2;
        par_mapped[9] = (par[14] + par[15]) / 2;
        par_mapped[10] = par[16];
        if (full) {
            par_mapped[11] = par[17];
            par_mapped[12] = par[18];
            par_mapped[13] = par[19];
            par_mapped[14] = (par[20] + par[21]) / 2;
            par_mapped[15] = (par[22] + par[23]) / 2;
            par_mapped[16] = (par[24] + par[25]) / 2;
            par_mapped[17] = (par[26] + par[27]) / 2;
            par_mapped[18] = (par[28] + par[29] + par[30] + par[31]) / 4;
            par_mapped[19] = (par[32] + par[33]) / 2;
        }
    }

    static void map_val_34_to_20(float[] par) {
        par[0] = (2.0f * par[0] + par[1]) * 0.33333334f;
        par[1] = (par[1] + 2.0f * par[2]) * 0.33333334f;
        par[2] = (2.0f * par[3] + par[4]) * 0.33333334f;
        par[3] = (par[4] + 2.0f * par[5]) * 0.33333334f;
        par[4] = (par[6] + par[7]) * 0.5f;
        par[5] = (par[8] + par[9]) * 0.5f;
        par[6] = par[10];
        par[7] = par[11];
        par[8] = (par[12] + par[13]) * 0.5f;
        par[9] = (par[14] + par[15]) * 0.5f;
        par[10] = par[16];
        par[11] = par[17];
        par[12] = par[18];
        par[13] = par[19];
        par[14] = (par[20] + par[21]) * 0.5f;
        par[15] = (par[22] + par[23]) * 0.5f;
        par[16] = (par[24] + par[25]) * 0.5f;
        par[17] = (par[26] + par[27]) * 0.5f;
        par[18] = (par[28] + par[29] + par[30] + par[31]) * 0.25f;
        par[19] = (par[32] + par[33]) * 0.5f;
    }

    static void map_idx_10_to_34(int[] par_mapped, int[] par, boolean full) {
        if (full) {
            par_mapped[33] = par[9];
            par_mapped[32] = par[9];
            par_mapped[31] = par[9];
            par_mapped[30] = par[9];
            par_mapped[29] = par[9];
            par_mapped[28] = par[9];
            par_mapped[27] = par[8];
            par_mapped[26] = par[8];
            par_mapped[25] = par[8];
            par_mapped[24] = par[8];
            par_mapped[23] = par[7];
            par_mapped[22] = par[7];
            par_mapped[21] = par[7];
            par_mapped[20] = par[7];
            par_mapped[19] = par[6];
            par_mapped[18] = par[6];
            par_mapped[17] = par[5];
            par_mapped[16] = par[5];
        } else {
            par_mapped[16] = 0;
        }
        par_mapped[15] = par[4];
        par_mapped[14] = par[4];
        par_mapped[13] = par[4];
        par_mapped[12] = par[4];
        par_mapped[11] = par[3];
        par_mapped[10] = par[3];
        par_mapped[9] = par[2];
        par_mapped[8] = par[2];
        par_mapped[7] = par[2];
        par_mapped[6] = par[2];
        par_mapped[5] = par[1];
        par_mapped[4] = par[1];
        par_mapped[3] = par[1];
        par_mapped[2] = par[0];
        par_mapped[1] = par[0];
        par_mapped[0] = par[0];
    }

    static void map_idx_20_to_34(int[] par_mapped, int[] par, boolean full) {
        if (full) {
            par_mapped[33] = par[19];
            par_mapped[32] = par[19];
            par_mapped[31] = par[18];
            par_mapped[30] = par[18];
            par_mapped[29] = par[18];
            par_mapped[28] = par[18];
            par_mapped[27] = par[17];
            par_mapped[26] = par[17];
            par_mapped[25] = par[16];
            par_mapped[24] = par[16];
            par_mapped[23] = par[15];
            par_mapped[22] = par[15];
            par_mapped[21] = par[14];
            par_mapped[20] = par[14];
            par_mapped[19] = par[13];
            par_mapped[18] = par[12];
            par_mapped[17] = par[11];
        }
        par_mapped[16] = par[10];
        par_mapped[15] = par[9];
        par_mapped[14] = par[9];
        par_mapped[13] = par[8];
        par_mapped[12] = par[8];
        par_mapped[11] = par[7];
        par_mapped[10] = par[6];
        par_mapped[9] = par[5];
        par_mapped[8] = par[5];
        par_mapped[7] = par[4];
        par_mapped[6] = par[4];
        par_mapped[5] = par[3];
        par_mapped[4] = (par[2] + par[3]) / 2;
        par_mapped[3] = par[2];
        par_mapped[2] = par[1];
        par_mapped[1] = (par[0] + par[1]) / 2;
        par_mapped[0] = par[0];
    }

    static void map_val_20_to_34(float[] par) {
        par[33] = par[19];
        par[32] = par[19];
        par[31] = par[18];
        par[30] = par[18];
        par[29] = par[18];
        par[28] = par[18];
        par[27] = par[17];
        par[26] = par[17];
        par[25] = par[16];
        par[24] = par[16];
        par[23] = par[15];
        par[22] = par[15];
        par[21] = par[14];
        par[20] = par[14];
        par[19] = par[13];
        par[18] = par[12];
        par[17] = par[11];
        par[16] = par[10];
        par[15] = par[9];
        par[14] = par[9];
        par[13] = par[8];
        par[12] = par[8];
        par[11] = par[7];
        par[10] = par[6];
        par[9] = par[5];
        par[8] = par[5];
        par[7] = par[4];
        par[6] = par[4];
        par[5] = par[3];
        par[4] = (par[2] + par[3]) * 0.5f;
        par[3] = par[2];
        par[2] = par[1];
        par[1] = (par[0] + par[1]) * 0.5f;
    }

    static void decorrelation(PSContext ps, float[][][] out, float[][][] s, boolean is34) {
        int i;
        int k;
        int is34i = is34 ? 1 : 0;
        float[][] power = new float[34][32];
        float[][] transient_gain = new float[34][32];
        float[] peak_decay_nrg = ps.peakDecayNrg;
        float[] power_smooth = ps.powerSmooth;
        float[] peak_decay_diff_smooth = ps.peakDecayDiffSmooth;
        float[][][] delay = ps.delay;
        float[][][][] ap_delay = ps.apDelay;
        int[] k_to_i = is34 ? AacPsData.k_to_i_34 : AacPsData.k_to_i_20;
        float peak_decay_factor = 0.7659283f;
        float transient_impact = 1.5f;
        float a_smooth = 0.25f;
        int n0 = 0;
        int nL = 32;
        Utilities.fill(power, 0.0f);
        if (is34 != ps.is34bandsOld) {
            Utilities.fill(ps.peakDecayNrg, 0.0f);
            Utilities.fill(ps.powerSmooth, 0.0f);
            Utilities.fill(ps.peakDecayDiffSmooth, 0.0f);
            Utilities.fill(ps.delay, 0.0f);
            Utilities.fill(ps.apDelay, 0.0f);
        }
        for (k = 0; k < NR_BANDS[is34i]; ++k) {
            i = k_to_i[k];
            PSDSP.add_squares(power[i], 0, s[k], 0, nL - n0);
        }
        for (int i2 = 0; i2 < NR_PAR_BANDS[is34i]; ++i2) {
            for (int n = n0; n < nL; ++n) {
                float decayed_peak = 0.7659283f * peak_decay_nrg[i2];
                peak_decay_nrg[i2] = Math.max(decayed_peak, power[i2][n]);
                int n2 = i2;
                power_smooth[n2] = power_smooth[n2] + 0.25f * (power[i2][n] - power_smooth[i2]);
                int n3 = i2;
                peak_decay_diff_smooth[n3] = peak_decay_diff_smooth[n3] + 0.25f * (peak_decay_nrg[i2] - power[i2][n] - peak_decay_diff_smooth[i2]);
                float denom = 1.5f * peak_decay_diff_smooth[i2];
                transient_gain[i2][n] = denom > power_smooth[i2] ? power_smooth[i2] / denom : 1.0f;
            }
        }
        for (k = 0; k < NR_ALLPASS_BANDS[is34i]; ++k) {
            int i3;
            int b = k_to_i[k];
            float g_decay_slope = 1.0f - 0.05f * (float)(k - DECAY_CUTOFF[is34i]);
            g_decay_slope = Utilities.clipf(g_decay_slope, 0.0f, 1.0f);
            for (i3 = 0; i3 < 14; ++i3) {
                Utilities.copy(delay[k][i3], delay[k][nL + i3]);
            }
            for (i3 = 0; i3 < 32; ++i3) {
                Utilities.copy(delay[k][14 + i3], s[k][i3]);
            }
            for (int m = 0; m < 3; ++m) {
                for (int i4 = 0; i4 < 5; ++i4) {
                    Utilities.copy(ap_delay[k][m][i4], ap_delay[k][m][32 + i4]);
                }
            }
            PSDSP.decorrelate(out[k], 0, delay[k], 12, ap_delay[k], AacPsData.phi_fract[is34i][k], AacPsData.Q_fract_allpass[is34i][k], transient_gain[b], g_decay_slope, nL - n0);
        }
        while (k < SHORT_DELAY_BAND[is34i]) {
            for (i = 0; i < 14; ++i) {
                Utilities.copy(delay[k][i], delay[k][nL + i]);
            }
            for (i = 0; i < 32; ++i) {
                Utilities.copy(delay[k][14 + i], s[k][i]);
            }
            i = k_to_i[k];
            PSDSP.mul_pair_single(out[k], 0, delay[k], 0, transient_gain[i], 0, nL - n0);
            ++k;
        }
        while (k < NR_BANDS[is34i]) {
            for (i = 0; i < 14; ++i) {
                Utilities.copy(delay[k][i], delay[k][nL + i]);
            }
            for (i = 0; i < 32; ++i) {
                Utilities.copy(delay[k][14 + i], s[k][i]);
            }
            i = k_to_i[k];
            PSDSP.mul_pair_single(out[k], 0, delay[k], 13, transient_gain[i], 0, nL - n0);
            ++k;
        }
    }

    private static void remap34(int[][][] p_par_mapped, int[][] par, int num_par, int numEnv, boolean full) {
        int[][] par_mapped = p_par_mapped[0];
        if (num_par == 20 || num_par == 11) {
            for (int e = 0; e < numEnv; ++e) {
                AacPs.map_idx_20_to_34(par_mapped[e], par[e], full);
            }
        } else if (num_par == 10 || num_par == 5) {
            for (int e = 0; e < numEnv; ++e) {
                AacPs.map_idx_10_to_34(par_mapped[e], par[e], full);
            }
        } else {
            p_par_mapped[0] = par;
        }
    }

    private static void remap20(int[][][] p_par_mapped, int[][] par, int num_par, int numEnv, boolean full) {
        int[][] par_mapped = p_par_mapped[0];
        if (num_par == 34 || num_par == 17) {
            for (int e = 0; e < numEnv; ++e) {
                AacPs.map_idx_34_to_20(par_mapped[e], par[e], full);
            }
        } else if (num_par == 10 || num_par == 5) {
            for (int e = 0; e < numEnv; ++e) {
                AacPs.map_idx_10_to_20(par_mapped[e], par[e], full);
            }
        } else {
            p_par_mapped[0] = par;
        }
    }

    private static void ipdopd_reset(int[] ipd_hist, int[] opd_hist) {
        Arrays.fill(ipd_hist, 0, 17, 0);
        Arrays.fill(opd_hist, 0, 17, 0);
    }

    private static void stereo_processing(PSContext ps, float[][][] l, float[][][] r, boolean is34) {
        float[][][] H_LUT;
        int is34i = is34 ? 1 : 0;
        float[][][] H11 = ps.H11;
        float[][][] H12 = ps.H12;
        float[][][] H21 = ps.H21;
        float[][][] H22 = ps.H22;
        int[] opd_hist = ps.opdHist;
        int[] ipd_hist = ps.ipdHist;
        int[][] iid_mapped_buf = new int[5][34];
        int[][] icc_mapped_buf = new int[5][34];
        int[][] ipd_mapped_buf = new int[5][34];
        int[][] opd_mapped_buf = new int[5][34];
        int[][][] iid_mapped = new int[][][]{iid_mapped_buf};
        int[][][] icc_mapped = new int[][][]{icc_mapped_buf};
        int[][][] ipd_mapped = new int[][][]{ipd_mapped_buf};
        int[][][] opd_mapped = new int[][][]{opd_mapped_buf};
        int[] k_to_i = is34 ? AacPsData.k_to_i_34 : AacPsData.k_to_i_20;
        float[][][] fArray = H_LUT = ps.iccMode < 3 ? AacPsData.HA : AacPsData.HB;
        if (ps.numEnvOld != 0) {
            System.arraycopy(H11[0][ps.numEnvOld], 0, H11[0][0], 0, 34);
            System.arraycopy(H11[1][ps.numEnvOld], 0, H11[1][0], 0, 34);
            System.arraycopy(H12[0][ps.numEnvOld], 0, H12[0][0], 0, 34);
            System.arraycopy(H12[1][ps.numEnvOld], 0, H12[1][0], 0, 34);
            System.arraycopy(H21[0][ps.numEnvOld], 0, H21[0][0], 0, 34);
            System.arraycopy(H21[1][ps.numEnvOld], 0, H21[1][0], 0, 34);
            System.arraycopy(H22[0][ps.numEnvOld], 0, H22[0][0], 0, 34);
            System.arraycopy(H22[1][ps.numEnvOld], 0, H22[1][0], 0, 34);
        }
        if (is34) {
            AacPs.remap34(iid_mapped, ps.iidPar, ps.nrIidPar, ps.numEnv, true);
            AacPs.remap34(icc_mapped, ps.iccPar, ps.nrIccPar, ps.numEnv, true);
            if (ps.enableIpdopd) {
                AacPs.remap34(ipd_mapped, ps.ipdPar, ps.nrIpdopdPar, ps.numEnv, false);
                AacPs.remap34(opd_mapped, ps.opdPar, ps.nrIpdopdPar, ps.numEnv, false);
            }
            if (!ps.is34bandsOld) {
                AacPs.map_val_20_to_34(H11[0][0]);
                AacPs.map_val_20_to_34(H11[1][0]);
                AacPs.map_val_20_to_34(H12[0][0]);
                AacPs.map_val_20_to_34(H12[1][0]);
                AacPs.map_val_20_to_34(H21[0][0]);
                AacPs.map_val_20_to_34(H21[1][0]);
                AacPs.map_val_20_to_34(H22[0][0]);
                AacPs.map_val_20_to_34(H22[1][0]);
                AacPs.ipdopd_reset(ipd_hist, opd_hist);
            }
        } else {
            AacPs.remap20(iid_mapped, ps.iidPar, ps.nrIidPar, ps.numEnv, true);
            AacPs.remap20(icc_mapped, ps.iccPar, ps.nrIccPar, ps.numEnv, true);
            if (ps.enableIpdopd) {
                AacPs.remap20(ipd_mapped, ps.ipdPar, ps.nrIpdopdPar, ps.numEnv, false);
                AacPs.remap20(opd_mapped, ps.opdPar, ps.nrIpdopdPar, ps.numEnv, false);
            }
            if (ps.is34bandsOld) {
                AacPs.map_val_34_to_20(H11[0][0]);
                AacPs.map_val_34_to_20(H11[1][0]);
                AacPs.map_val_34_to_20(H12[0][0]);
                AacPs.map_val_34_to_20(H12[1][0]);
                AacPs.map_val_34_to_20(H21[0][0]);
                AacPs.map_val_34_to_20(H21[1][0]);
                AacPs.map_val_34_to_20(H22[0][0]);
                AacPs.map_val_34_to_20(H22[1][0]);
                AacPs.ipdopd_reset(ipd_hist, opd_hist);
            }
        }
        for (int e = 0; e < ps.numEnv; ++e) {
            for (int b = 0; b < NR_PAR_BANDS[is34i]; ++b) {
                float h11 = H_LUT[iid_mapped[0][e][b] + 7 + 23 * ps.iidQuant][icc_mapped[0][e][b]][0];
                float h12 = H_LUT[iid_mapped[0][e][b] + 7 + 23 * ps.iidQuant][icc_mapped[0][e][b]][1];
                float h21 = H_LUT[iid_mapped[0][e][b] + 7 + 23 * ps.iidQuant][icc_mapped[0][e][b]][2];
                float h22 = H_LUT[iid_mapped[0][e][b] + 7 + 23 * ps.iidQuant][icc_mapped[0][e][b]][3];
                if (ps.enableIpdopd && b < NR_IPDOPD_BANDS[is34i]) {
                    int opd_idx = opd_hist[b] * 8 + opd_mapped[0][e][b];
                    int ipd_idx = ipd_hist[b] * 8 + ipd_mapped[0][e][b];
                    float opd_re = AacPsData.pd_re_smooth[opd_idx];
                    float opd_im = AacPsData.pd_im_smooth[opd_idx];
                    float ipd_re = AacPsData.pd_re_smooth[ipd_idx];
                    float ipd_im = AacPsData.pd_im_smooth[ipd_idx];
                    opd_hist[b] = opd_idx & 0x3F;
                    ipd_hist[b] = ipd_idx & 0x3F;
                    float ipd_adj_re = opd_re * ipd_re + opd_im * ipd_im;
                    float ipd_adj_im = opd_im * ipd_re - opd_re * ipd_im;
                    float h11i = h11 * opd_im;
                    h11 *= opd_re;
                    float h12i = h12 * ipd_adj_im;
                    h12 *= ipd_adj_re;
                    float h21i = h21 * opd_im;
                    h21 *= opd_re;
                    float h22i = h22 * ipd_adj_im;
                    h22 *= ipd_adj_re;
                    H11[1][e + 1][b] = h11i;
                    H12[1][e + 1][b] = h12i;
                    H21[1][e + 1][b] = h21i;
                    H22[1][e + 1][b] = h22i;
                }
                H11[0][e + 1][b] = h11;
                H12[0][e + 1][b] = h12;
                H21[0][e + 1][b] = h21;
                H22[0][e + 1][b] = h22;
            }
            for (int k = 0; k < NR_BANDS[is34i]; ++k) {
                float[][] h = new float[2][4];
                float[][] h_step = new float[2][4];
                int start = ps.borderPosition[e];
                int stop = ps.borderPosition[e + 1];
                float width = 1.0f / (float)(stop - start);
                int b = k_to_i[k];
                h[0][0] = H11[0][e][b];
                h[0][1] = H12[0][e][b];
                h[0][2] = H21[0][e][b];
                h[0][3] = H22[0][e][b];
                if (ps.enableIpdopd) {
                    if (is34 && k <= 13 && k >= 9 || !is34 && k <= 1) {
                        h[1][0] = -H11[1][e][b];
                        h[1][1] = -H12[1][e][b];
                        h[1][2] = -H21[1][e][b];
                        h[1][3] = -H22[1][e][b];
                    } else {
                        h[1][0] = H11[1][e][b];
                        h[1][1] = H12[1][e][b];
                        h[1][2] = H21[1][e][b];
                        h[1][3] = H22[1][e][b];
                    }
                }
                h_step[0][0] = (H11[0][e + 1][b] - h[0][0]) * width;
                h_step[0][1] = (H12[0][e + 1][b] - h[0][1]) * width;
                h_step[0][2] = (H21[0][e + 1][b] - h[0][2]) * width;
                h_step[0][3] = (H22[0][e + 1][b] - h[0][3]) * width;
                if (ps.enableIpdopd) {
                    h_step[1][0] = (H11[1][e + 1][b] - h[1][0]) * width;
                    h_step[1][1] = (H12[1][e + 1][b] - h[1][1]) * width;
                    h_step[1][2] = (H21[1][e + 1][b] - h[1][2]) * width;
                    h_step[1][3] = (H22[1][e + 1][b] - h[1][3]) * width;
                }
                PSDSP.stereoInterpolate(l[k], start + 1, r[k], start + 1, h, h_step, stop - start, ps.enableIpdopd);
            }
        }
    }

    public static int psApply(PSContext ps, float[][][] L, float[][][] R, int top) {
        int i;
        float[][][] Lbuf = new float[91][32][2];
        float[][][] Rbuf = new float[91][32][2];
        int len = 32;
        boolean is34 = ps.is34bands;
        int is34i = is34 ? 1 : 0;
        for (i = top += NR_BANDS[is34i] - 64; i < NR_BANDS[is34i]; ++i) {
            Utilities.fill(ps.delay[i], 0.0f);
        }
        if (top < NR_ALLPASS_BANDS[is34i]) {
            for (i = top; i < NR_ALLPASS_BANDS[is34i]; ++i) {
                Utilities.fill(ps.apDelay[i], 0.0f);
            }
        }
        AacPs.hybrid_analysis(Lbuf, ps.inBuf, L, is34, 32);
        AacPs.decorrelation(ps, Rbuf, Lbuf, is34);
        AacPs.stereo_processing(ps, Lbuf, Rbuf, is34);
        AacPs.hybrid_synthesis(L, Lbuf, is34, 32);
        AacPs.hybrid_synthesis(R, Rbuf, is34, 32);
        return 0;
    }
}

