/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.atrac3plus;

import jpcsp.media.codec.atrac3plus.AtracGainInfo;

public class Atrac {
    public static final float[] ff_atrac_sf_table = new float[64];
    private static final float[] qmf_window = new float[48];
    private static final float[] qmf_48tap_half = new float[]{-1.461907E-5f, -9.205479E-5f, -5.615757E-5f, 3.011727E-4f, 2.422519E-4f, -8.52939E-4f, -5.205574E-4f, 0.002034017f, 7.833389E-4f, -0.004215386f, -7.561499E-4f, 0.007840294f, -6.116992E-5f, -0.01344162f, 0.002462682f, 0.02173609f, -0.007801671f, -0.03409022f, 0.01880949f, 0.05432601f, -0.04359638f, -0.09938437f, 0.1320791f, 0.4642416f};
    private float[] gainTab1 = new float[16];
    private float[] gainTab2 = new float[31];
    private int id2expOffset;
    private int locScale;
    private int locSize;

    public static void generateTables() {
        int i;
        if (ff_atrac_sf_table[63] == 0.0f) {
            for (i = 0; i < 64; ++i) {
                Atrac.ff_atrac_sf_table[i] = (float)Math.pow(2.0, (double)(i - 15) / 3.0);
            }
        }
        if (qmf_window[47] == 0.0f) {
            for (i = 0; i < 24; ++i) {
                float s;
                Atrac.qmf_window[i] = s = qmf_48tap_half[i] * 2.0f;
                Atrac.qmf_window[47 - i] = s;
            }
        }
    }

    public void initGainCompensation(int id2expOffset, int locScale) {
        int i;
        this.locScale = locScale;
        this.locSize = 1 << locScale;
        this.id2expOffset = id2expOffset;
        for (i = 0; i < 16; ++i) {
            this.gainTab1[i] = (float)Math.pow(2.0, id2expOffset - i);
        }
        for (i = -15; i < 16; ++i) {
            this.gainTab2[i + 15] = (float)Math.pow(2.0, -1.0 / (double)this.locSize * (double)i);
        }
    }

    public void gainCompensation(float[] in, int inOffset, float[] prev, int prevOffset, AtracGainInfo gcNow, AtracGainInfo gcNext, int numSamples, float[] out, int outOffset) {
        float gcScale;
        float f = gcScale = gcNext.numPoints != 0 ? this.gainTab1[gcNext.levCode[0]] : 1.0f;
        if (gcNow.numPoints == 0) {
            for (int pos = 0; pos < numSamples; ++pos) {
                out[outOffset + pos] = in[inOffset + pos] * gcScale + prev[prevOffset + pos];
            }
        } else {
            int pos = 0;
            for (int i = 0; i < gcNow.numPoints; ++i) {
                int lastpos = gcNow.locCode[i] << this.locScale;
                float lev = this.gainTab1[gcNow.levCode[i]];
                float gainInc = this.gainTab2[(i + 1 < gcNow.numPoints ? gcNow.levCode[i + 1] : this.id2expOffset) - gcNow.levCode[i] + 15];
                while (pos < lastpos) {
                    out[outOffset + pos] = (in[inOffset + pos] * gcScale + prev[prevOffset + pos]) * lev;
                    ++pos;
                }
                while (pos < lastpos + this.locSize) {
                    out[outOffset + pos] = (in[inOffset + pos] * gcScale + prev[prevOffset + pos]) * lev;
                    lev *= gainInc;
                    ++pos;
                }
            }
            while (pos < numSamples) {
                out[outOffset + pos] = in[inOffset + pos] * gcScale + prev[prevOffset + pos];
                ++pos;
            }
        }
        System.arraycopy(in, inOffset + numSamples, prev, prevOffset, numSamples);
    }

    public static void iqmf(float[] inlo, int inloOffset, float[] inhi, int inhiOffset, int nIn, float[] out, int outOffset, float[] delayBuf, float[] temp) {
        System.arraycopy(delayBuf, 0, temp, 0, 46);
        for (int i = 0; i < nIn; i += 2) {
            temp[46 + 2 * i + 0] = inlo[inloOffset + i] + inhi[inhiOffset + i];
            temp[46 + 2 * i + 1] = inlo[inloOffset + i] - inhi[inhiOffset + i];
            temp[46 + 2 * i + 2] = inlo[inloOffset + i + 1] + inhi[inhiOffset + i + 1];
            temp[46 + 2 * i + 3] = inlo[inloOffset + i + 1] - inhi[inhiOffset + i + 1];
        }
        int p1 = 0;
        for (int j = nIn; j != 0; --j) {
            float s1 = 0.0f;
            float s2 = 0.0f;
            for (int i = 0; i < 48; i += 2) {
                s1 += temp[p1 + i] * qmf_window[i];
                s2 += temp[p1 + i + 1] * qmf_window[i + 1];
            }
            out[outOffset + 0] = s2;
            out[outOffset + 1] = s1;
            p1 += 2;
            outOffset += 2;
        }
        System.arraycopy(temp, nIn * 2, delayBuf, 0, 46);
    }
}

