/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.h264;

import com.twilight.h264.decoder.AVFrame;
import com.twilight.h264.decoder.AVPacket;
import com.twilight.h264.decoder.AVRational;
import com.twilight.h264.decoder.MpegEncContext;
import jpcsp.media.codec.IVideoCodec;
import org.apache.log4j.Logger;

public class H264Decoder
implements IVideoCodec {
    private static Logger log = Logger.getLogger((String)"h264");
    private MpegEncContext context;
    private AVFrame picture;
    private AVPacket packet;
    private final int[] gotPicture = new int[1];
    private AVRational aspectRatio;

    @Override
    public int init(int[] extraData) {
        int result;
        this.context = MpegEncContext.avcodec_alloc_context();
        this.picture = AVFrame.avcodec_alloc_frame();
        this.packet = new AVPacket();
        this.packet.av_init_packet();
        if (extraData != null) {
            this.context.extradata_size = extraData.length;
            int[] extraDataPlus4 = new int[this.context.extradata_size + 4];
            System.arraycopy(extraData, 0, extraDataPlus4, 0, this.context.extradata_size);
            this.context.extradata = extraDataPlus4;
        }
        if ((result = this.context.avcodec_open(new com.twilight.h264.decoder.H264Decoder())) < 0) {
            return result;
        }
        this.gotPicture[0] = 0;
        return 0;
    }

    @Override
    public int decode(int[] input, int inputOffset, int inputLength) {
        int consumedLength;
        this.packet.data_base = input;
        this.packet.data_offset = inputOffset;
        this.packet.size = inputLength;
        try {
            consumedLength = this.context.avcodec_decode_video2(this.picture, this.gotPicture, this.packet);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.error((Object)"H264Decoder.decode", (Throwable)e);
            return -1;
        }
        if (consumedLength < 0) {
            log.error((Object)String.format("H264 decode error 0x%08X", consumedLength));
            this.gotPicture[0] = 0;
            return consumedLength;
        }
        if (this.hasImage()) {
            this.context.priv_data.displayPicture.copyTo(this.picture);
            this.aspectRatio = this.context.sample_aspect_ratio;
        }
        return consumedLength;
    }

    @Override
    public boolean hasImage() {
        return this.gotPicture[0] != 0;
    }

    @Override
    public int getImageWidth() {
        return this.context.width;
    }

    @Override
    public int getImageHeight() {
        return this.context.height;
    }

    @Override
    public boolean isKeyFrame() {
        return this.picture.key_frame != 0;
    }

    @Override
    public void getAspectRatio(int[] numDen) {
        numDen[0] = this.aspectRatio.num;
        numDen[1] = this.aspectRatio.den;
    }

    @Override
    public int getImage(int[] luma, int[] cb, int[] cr) {
        int y;
        int width = this.getImageWidth();
        int height = this.getImageHeight();
        int width2 = width >> 1;
        int height2 = height >> 1;
        for (y = 0; y < height; ++y) {
            System.arraycopy(this.picture.data_base[0], y * this.picture.linesize[0] + this.picture.data_offset[0], luma, y * width, width);
        }
        for (y = 0; y < height2; ++y) {
            System.arraycopy(this.picture.data_base[1], y * this.picture.linesize[1] + this.picture.data_offset[1], cb, y * width2, width2);
            System.arraycopy(this.picture.data_base[2], y * this.picture.linesize[2] + this.picture.data_offset[2], cr, y * width2, width2);
        }
        return 0;
    }
}

