/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.mediaengine;

import java.io.IOException;
import jpcsp.Memory;
import jpcsp.hardware.Model;
import jpcsp.mediaengine.MMIOHandlerMe0F8000;
import jpcsp.mediaengine.MMIOHandlerMe0FF000;
import jpcsp.mediaengine.MMIOHandlerMeDecoderQuSpectra;
import jpcsp.memory.mmio.IMMIOHandler;
import jpcsp.memory.mmio.MMIO;
import jpcsp.memory.mmio.MMIOHandlerReadWrite;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MEMemory
extends MMIO {
    private static final int STATE_VERSION = 0;
    public static final int START_ME_RAM = 0;
    public static int END_ME_RAM;
    public static int SIZE_ME_RAM;
    private final IMMIOHandler[] meRamHandlers = new IMMIOHandler[8];
    private final int[] meRam;

    public MEMemory(Memory mem, Logger log) {
        super(mem);
        SIZE_ME_RAM = Model.getGeneration() == 1 ? 0x200000 : 0x400000;
        END_ME_RAM = 0 + SIZE_ME_RAM - 1;
        this.meRam = new int[SIZE_ME_RAM >> 2];
        this.addMeRamHandler(0, this.meRam, log);
        this.addMeRamHandler(0x40000000, this.meRam, log);
        this.addMeRamHandler(Integer.MIN_VALUE, this.meRam, log);
        this.addMeRamHandler(-1610612736, this.meRam, log);
        this.addHandlerRW(0x44000000, 32768, log);
        this.addHandlerRW(0x44020000, 32768, log);
        this.addHandler(1141866496, 404, new MMIOHandlerMe0F8000(1141866496));
        this.addHandler(0x440FF000, 48, new MMIOHandlerMe0FF000(0x440FF000));
        this.addHandler(0x44100000, 64, new MMIOHandlerMeDecoderQuSpectra(0x44100000));
    }

    private void addMeRamHandler(int address, int[] meRam, Logger log) {
        MMIOHandlerReadWrite handler = new MMIOHandlerReadWrite(0 | address, SIZE_ME_RAM, meRam);
        handler.setLogger(log);
        this.meRamHandlers[address >>> 29] = handler;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.meRamHandlers[0].read(stream);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        this.meRamHandlers[0].write(stream);
        super.write(stream);
    }

    @Override
    protected IMMIOHandler getHandler(int address) {
        if ((address & 0x1FFFFFFF) <= END_ME_RAM) {
            return this.meRamHandlers[address >>> 29];
        }
        return super.getHandler(address);
    }

    @Override
    public boolean hasMemoryInt(int address) {
        if ((address & 0x1FFFFFFF) <= END_ME_RAM) {
            return true;
        }
        return super.hasMemoryInt(address);
    }

    @Override
    public int[] getMemoryInt(int address) {
        if ((address & 0x1FFFFFFF) <= END_ME_RAM) {
            return this.meRam;
        }
        return super.getMemoryInt(address);
    }
}

