/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.mediaengine;

import java.io.IOException;
import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.Decoder;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.Processor;
import jpcsp.mediaengine.MEMemory;
import jpcsp.mediaengine.METhread;
import jpcsp.memory.mmio.MMIOHandlerInterruptMan;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MEProcessor
extends Processor {
    public static Logger log = Logger.getLogger((String)"me");
    private static final boolean DUMP = false;
    private static final int STATE_VERSION = 0;
    public static final int CPUID_ME = 1;
    private static MEProcessor instance;
    private MEMemory meMemory;
    private final int[] vmeRegisters = new int[1424];
    private boolean halt;
    private Common.Instruction[] optimizedInstructions1;
    private Common.Instruction[] optimizedInstructions2;
    private static final int optimizedRunStart1 = 0x8300000;
    private static final int optimizedRunEnd1 = 137945492;
    private static final int optimizedRunStart2 = 0x8000000;
    private static final int optimizedRunEnd2 = 0x8003000;

    public static MEProcessor getInstance() {
        if (instance == null) {
            instance = new MEProcessor();
        }
        return instance;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        stream.readInts(this.vmeRegisters);
        this.halt = stream.readBoolean();
        super.read(stream);
        this.optimizedInstructions1 = null;
        this.optimizedInstructions2 = null;
        this.sync();
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInts(this.vmeRegisters);
        stream.writeBoolean(this.halt);
        super.write(stream);
    }

    private MEProcessor() {
        this.setLogger(log);
        this.meMemory = new MEMemory(RuntimeContextLLE.getMMIO(), log);
        this.cpu.setMemory(this.meMemory);
        this.cp0.setCpuid(1);
        this.halt = true;
        RuntimeContextLLE.registerExitAction(new ExitAction());
    }

    public MEMemory getMEMemory() {
        return this.meMemory;
    }

    public int getVmeRegister(int reg) {
        return this.vmeRegisters[reg];
    }

    public void setVmeRegister(int reg, int value) {
        this.vmeRegisters[reg] = value;
    }

    public void triggerException(int IP) {
        if ((RuntimeContextLLE.pendingInterruptIPbitsME |= IP) != 0) {
            this.halt = false;
            METhread.getInstance().sync();
        }
    }

    public void sync() {
        METhread meThread = METhread.getInstance();
        meThread.setProcessor(this);
        meThread.sync();
    }

    @Override
    public void triggerReset() {
        super.triggerReset();
        this.halt = false;
        this.optimizedInstructions1 = null;
        this.optimizedInstructions2 = null;
        if (log.isTraceEnabled()) {
            log.setLevel(Level.DEBUG);
        }
        this.sync();
    }

    public void halt() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MEProcessor.halt: pendingInterruptIPbitsME=0x%X, isInterruptExecutionAllowed=%b, doTriggerException=%b, status=0x%X, pc=0x%08X", RuntimeContextLLE.pendingInterruptIPbitsME, this.isInterruptExecutionAllowed(), MMIOHandlerInterruptMan.getInstance(this).doTriggerException(), this.cp0.getStatus(), this.cpu.pc));
        }
        if (RuntimeContextLLE.pendingInterruptIPbitsME == 0 && !MMIOHandlerInterruptMan.getInstance(this).doTriggerException()) {
            this.halt = true;
        }
    }

    public boolean isHalted() {
        return this.halt;
    }

    private boolean isInterruptExecutionAllowed() {
        if (RuntimeContextLLE.pendingInterruptIPbitsME == 0) {
            return false;
        }
        if (this.isInterruptsDisabled()) {
            return false;
        }
        int status = this.cp0.getStatus();
        if (Utilities.hasFlag(status, 2)) {
            return false;
        }
        return (RuntimeContextLLE.pendingInterruptIPbitsME << 8 & status) != 0;
    }

    private void setExceptionCause(int exceptionNumber) {
        int cause = this.cp0.getCause();
        cause = cause & 0xFFFFFF00 | exceptionNumber << 2;
        this.cp0.setCause(cause);
    }

    private int prepareExceptionHandlerCall(boolean forceNoDelaySlot) {
        int epc = this.cpu.pc;
        int cause = this.cp0.getCause();
        if (!forceNoDelaySlot && epc != 0 && MEProcessor.isInstructionInDelaySlot(this.cpu.memory, epc)) {
            cause |= Integer.MIN_VALUE;
            epc -= 4;
        } else {
            cause &= Integer.MAX_VALUE;
        }
        this.cp0.setCause(cause);
        this.cp0.setEpc(epc);
        int status = this.cp0.getStatus();
        status = Utilities.setFlag(status, 2);
        this.cp0.setStatus(status);
        int ebase = Utilities.notHasFlag(status, 0x400000) ? this.cp0.getEbase() : -1077936128;
        this.halt = false;
        return ebase;
    }

    private void checkPendingInterruptException() {
        if (this.isInterruptExecutionAllowed()) {
            int cause = this.cp0.getCause();
            cause |= RuntimeContextLLE.pendingInterruptIPbitsME << 8;
            RuntimeContextLLE.pendingInterruptIPbitsME = 0;
            this.cp0.setCause(cause);
            this.setExceptionCause(0);
            this.cpu.pc = this.prepareExceptionHandlerCall(false);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("MEProcessor calling exception handler at 0x%08X, IP bits=0x%02X", this.cpu.pc, cause >> 8 & 0xFF));
            }
        }
    }

    private void initOptimizedRun1() {
        this.optimizedInstructions1 = new Common.Instruction[145509];
        for (int pc = 0x8300000; pc < 137945492; pc += 4) {
            int opcode = memory.read32(pc);
            this.optimizedInstructions1[pc - 0x8300000 >> 2] = Decoder.instruction(opcode);
        }
    }

    private void initOptimizedRun2() {
        this.optimizedInstructions2 = new Common.Instruction[3072];
        for (int pc = 0x8000000; pc < 0x8003000; pc += 4) {
            int opcode = memory.read32(pc);
            this.optimizedInstructions2[pc - 0x8000000 >> 2] = Decoder.instruction(opcode);
        }
    }

    private void optimizedRun1() {
        int[] memoryInt = RuntimeContext.getMemoryInt();
        if (this.optimizedInstructions1 == null) {
            this.initOptimizedRun1();
        }
        boolean isTraceEnabled = log.isTraceEnabled();
        int count = 0;
        long start = Emulator.getClock().currentTimeMillis();
        int startPc = this.cpu.pc;
        while (!this.halt && !Emulator.pause) {
            int pc;
            if (RuntimeContextLLE.pendingInterruptIPbitsME != 0) {
                this.checkPendingInterruptException();
            }
            if ((pc = this.cpu.pc & 0x1FFFFFFF) >= 137945492) break;
            int insnIndex = pc - 0x8300000 >> 2;
            int opcode = memoryInt[pc >> 2];
            this.cpu.pc += 4;
            Common.Instruction insn = this.optimizedInstructions1[insnIndex];
            if (isTraceEnabled) {
                log.trace((Object)String.format("Interpreting 0x%08X: [0x%08X] - %s", this.cpu.pc - 4, opcode, insn.disasm(this.cpu.pc - 4, opcode)));
            }
            insn.interpret(this, opcode);
            ++count;
        }
        long end = Emulator.getClock().currentTimeMillis();
        if (count > 0 && log.isDebugEnabled()) {
            int duration = Math.max((int)(end - start), 1);
            log.debug((Object)String.format("MEProcessor.optimizedRun1 %d instructions executed from 0x%08X in %d ms: %d instructions per ms", count, startPc, duration, (count + duration / 2) / duration));
        }
    }

    private void optimizedRun2() {
        int[] memoryInt = RuntimeContext.getMemoryInt();
        if (this.optimizedInstructions2 == null) {
            this.initOptimizedRun2();
        }
        boolean isTraceEnabled = log.isTraceEnabled();
        int count = 0;
        long start = Emulator.getClock().currentTimeMillis();
        int startPc = this.cpu.pc;
        while (!this.halt && !Emulator.pause) {
            int pc;
            if (RuntimeContextLLE.pendingInterruptIPbitsME != 0) {
                this.checkPendingInterruptException();
            }
            if ((pc = this.cpu.pc & 0x1FFFFFFF) >= 0x8003000) break;
            int insnIndex = pc - 0x8000000 >> 2;
            int opcode = memoryInt[pc >> 2];
            this.cpu.pc += 4;
            Common.Instruction insn = this.optimizedInstructions2[insnIndex];
            if (isTraceEnabled) {
                log.trace((Object)String.format("Interpreting 0x%08X: [0x%08X] - %s", this.cpu.pc - 4, opcode, insn.disasm(this.cpu.pc - 4, opcode)));
            }
            insn.interpret(this, opcode);
            ++count;
        }
        long end = Emulator.getClock().currentTimeMillis();
        if (count > 0 && log.isDebugEnabled()) {
            int duration = Math.max((int)(end - start), 1);
            log.debug((Object)String.format("MEProcessor.optimizedRun2 %d instructions executed from 0x%08X in %d ms: %d instructions per ms", count, startPc, duration, (count + duration / 2) / duration));
        }
    }

    private void normalRun() {
        int count = 0;
        long start = Emulator.getClock().currentTimeMillis();
        boolean hasMemoryInt = RuntimeContext.hasMemoryInt();
        int startPc = this.cpu.pc;
        while (!this.halt && !Emulator.pause) {
            int pc;
            if (RuntimeContextLLE.pendingInterruptIPbitsME != 0) {
                this.checkPendingInterruptException();
            }
            this.step();
            ++count;
            if (!hasMemoryInt || ((pc = this.cpu.pc & 0x1FFFFFFF) < 0x8300000 || pc >= 137945492) && (pc < 0x8000000 || pc >= 0x8003000)) continue;
            break;
        }
        long end = Emulator.getClock().currentTimeMillis();
        if (count > 0 && log.isDebugEnabled()) {
            int duration = Math.max((int)(end - start), 1);
            log.debug((Object)String.format("MEProcessor.normalRun %d instructions executed from 0x%08X in %d ms: %d instructions per ms", count, startPc, duration, (count + duration / 2) / duration));
        }
    }

    public void run() {
        if (!Emulator.run) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MEProcessor starting run: halt=%b, pendingInterruptIPbitsME=0x%X, pc=0x%08X", this.halt, RuntimeContextLLE.pendingInterruptIPbitsME, this.cpu.pc));
        }
        boolean hasMemoryInt = RuntimeContext.hasMemoryInt();
        while (!this.halt && !Emulator.pause) {
            int pc = this.cpu.pc & 0x1FFFFFFF;
            if (hasMemoryInt && pc >= 0x8300000 && pc < 137945492) {
                this.optimizedRun1();
                continue;
            }
            if (hasMemoryInt && pc >= 0x8000000 && pc < 0x8003000) {
                this.optimizedRun2();
                continue;
            }
            this.normalRun();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MEProcessor exiting run: halt=%b, pendingInterruptIPbitsME=0x%X, isInterruptExecutionAllowed=%b, status=0x%X, pc=0x%08X", this.halt, RuntimeContextLLE.pendingInterruptIPbitsME, this.isInterruptExecutionAllowed(), this.cp0.getStatus(), this.cpu.pc));
        }
    }

    private class ExitAction
    implements IAction {
        private ExitAction() {
        }

        @Override
        public void execute() {
            METhread.exit();
            MEProcessor.this.halt = true;
        }
    }
}

