/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;

public class StandardMemory
extends Memory {
    private static final int PAGE_COUNT = 0x100000;
    private static final int PAGE_MASK = 4095;
    private static final int PAGE_SHIFT = 12;
    private static final int INDEX_SCRATCHPAD = 0;
    private static final int INDEX_VRAM = 4;
    private static final int INDEX_RAM = 516;
    private static int SIZE_ALLMEM;
    private byte[] all;
    private static int[] map;
    private ByteBuffer buf;
    private ByteBuffer scratchpad;
    private ByteBuffer videoram;
    private ByteBuffer mainmemory;

    @Override
    public boolean allocate() {
        SIZE_ALLMEM = 0x204000 + MemoryMap.SIZE_RAM;
        this.all = null;
        map = null;
        try {
            this.all = new byte[SIZE_ALLMEM];
            map = new int[0x100000];
            this.buf = ByteBuffer.wrap(this.all);
            this.buf.order(ByteOrder.LITTLE_ENDIAN);
            this.scratchpad = ByteBuffer.wrap(this.all, 0, 16384).slice();
            this.scratchpad.order(ByteOrder.LITTLE_ENDIAN);
            this.videoram = ByteBuffer.wrap(this.all, 16384, 0x200000).slice();
            this.videoram.order(ByteOrder.LITTLE_ENDIAN);
            this.mainmemory = ByteBuffer.wrap(this.all, 0x204000, MemoryMap.SIZE_RAM).slice();
            this.mainmemory.order(ByteOrder.LITTLE_ENDIAN);
            this.buildMap();
        }
        catch (OutOfMemoryError e) {
            Memory.log.error((Object)"Cannot allocate StandardMemory: add the option '-Xmx64m' to the Java Virtual Machine startup command to improve Performance");
            return false;
        }
        return super.allocate();
    }

    @Override
    public void Initialise() {
        Arrays.fill(this.all, (byte)0);
    }

    private void buildMap() {
        int i;
        Arrays.fill(map, -1);
        int page = 16;
        for (i = 0; i < 4; ++i) {
            StandardMemory.map[0 + page + i] = 0 + i << 12;
            StandardMemory.map[262144 + page + i] = 0 + i << 12;
            StandardMemory.map[524288 + page + i] = 0 + i << 12;
        }
        page = 16384;
        for (i = 0; i < 512; ++i) {
            StandardMemory.map[0 + page + i] = 4 + i << 12;
            StandardMemory.map[262144 + page + i] = 4 + i << 12;
            StandardMemory.map[524288 + page + i] = 4 + i << 12;
            StandardMemory.map[512 + page + i] = 4 + i << 12;
            StandardMemory.map[262656 + page + i] = 4 + i << 12;
            StandardMemory.map[524800 + page + i] = 4 + i << 12;
        }
        page = 32768;
        for (i = 0; i < MemoryMap.SIZE_RAM >>> 12; ++i) {
            StandardMemory.map[0 + page + i] = 516 + i << 12;
            StandardMemory.map[262144 + page + i] = 516 + i << 12;
            StandardMemory.map[524288 + page + i] = 516 + i << 12;
        }
    }

    private static int indexFromAddr(int address) throws Exception {
        int index = map[address >>> 12];
        if (index == -1) {
            throw new Exception("Invalid memory address : " + Integer.toHexString(address) + " PC=" + Integer.toHexString(Emulator.getProcessor().cpu.pc));
        }
        return index;
    }

    @Override
    public int read8(int address) {
        try {
            int page = StandardMemory.indexFromAddr(address);
            return this.buf.get(page + (address & 0xFFF)) & 0xFF;
        }
        catch (Exception e) {
            Memory.log.error((Object)("read8 - " + e.getMessage()));
            Emulator.PauseEmuWithStatus(4);
            return 0;
        }
    }

    @Override
    public int read16(int address) {
        try {
            int page = StandardMemory.indexFromAddr(address);
            return this.buf.getShort(page + (address & 0xFFF)) & 0xFFFF;
        }
        catch (Exception e) {
            Memory.log.error((Object)("read16 - " + e.getMessage()));
            Emulator.PauseEmuWithStatus(4);
            return 0;
        }
    }

    @Override
    public int read32(int address) {
        try {
            int page = StandardMemory.indexFromAddr(address);
            return this.buf.getInt(page + (address & 0xFFF));
        }
        catch (Exception e) {
            if (this.read32AllowedInvalidAddress(address)) {
                return 0;
            }
            Memory.log.error((Object)("read32 - " + e.getMessage()));
            Emulator.PauseEmuWithStatus(4);
            return 0;
        }
    }

    @Override
    public long read64(int address) {
        try {
            int page = StandardMemory.indexFromAddr(address);
            return this.buf.getLong(page + (address & 0xFFF));
        }
        catch (Exception e) {
            Memory.log.error((Object)("read64 - " + e.getMessage()));
            Emulator.PauseEmuWithStatus(4);
            return 0L;
        }
    }

    @Override
    public void write8(int address, byte data) {
        try {
            int page = StandardMemory.indexFromAddr(address);
            this.buf.put(page + (address & 0xFFF), data);
            Modules.sceDisplayModule.write8(address & 0x1FFFFFFF);
        }
        catch (Exception e) {
            Memory.log.error((Object)("write8 - " + e.getMessage()));
            Emulator.PauseEmuWithStatus(8);
        }
    }

    @Override
    public void write16(int address, short data) {
        try {
            int page = StandardMemory.indexFromAddr(address);
            this.buf.putShort(page + (address & 0xFFF), data);
            Modules.sceDisplayModule.write16(address & 0x1FFFFFFF);
        }
        catch (Exception e) {
            Memory.log.error((Object)("write16 - " + e.getMessage()));
            Emulator.PauseEmuWithStatus(8);
        }
    }

    @Override
    public void write32(int address, int data) {
        try {
            int page = StandardMemory.indexFromAddr(address);
            this.buf.putInt(page + (address & 0xFFF), data);
            Modules.sceDisplayModule.write32(address & 0x1FFFFFFF);
        }
        catch (Exception e) {
            Memory.log.error((Object)("write32 - " + e.getMessage()));
            Emulator.PauseEmuWithStatus(8);
        }
    }

    @Override
    public void write64(int address, long data) {
        try {
            int page = StandardMemory.indexFromAddr(address);
            this.buf.putLong(page + (address & 0xFFF), data);
        }
        catch (Exception e) {
            Memory.log.error((Object)("write64 - " + e.getMessage()));
            Emulator.PauseEmuWithStatus(8);
        }
    }

    @Override
    public ByteBuffer getMainMemoryByteBuffer() {
        return this.mainmemory;
    }

    @Override
    public ByteBuffer getBuffer(int address, int length) {
        address = StandardMemory.normalizeAddress(address);
        int endAddress = address + length - 1;
        if (address >= 0x8000000 && endAddress <= MemoryMap.END_RAM) {
            return ByteBuffer.wrap(this.mainmemory.array(), this.mainmemory.arrayOffset() + address - 0x8000000, length).slice().order(ByteOrder.LITTLE_ENDIAN);
        }
        if (address >= 0x4000000 && endAddress <= 0x41FFFFF) {
            return ByteBuffer.wrap(this.videoram.array(), this.videoram.arrayOffset() + address - 0x4000000, length).slice().order(ByteOrder.LITTLE_ENDIAN);
        }
        if (address >= 65536 && endAddress <= 81919) {
            return ByteBuffer.wrap(this.scratchpad.array(), this.scratchpad.arrayOffset() + address - 65536, length).slice().order(ByteOrder.LITTLE_ENDIAN);
        }
        return null;
    }

    @Override
    public void memset(int address, byte data, int length) {
        ByteBuffer buffer = this.getBuffer(address, length);
        Arrays.fill(buffer.array(), buffer.arrayOffset(), buffer.arrayOffset() + length, data);
    }

    @Override
    public void copyToMemory(int address, ByteBuffer source, int length) {
        byte[] data = new byte[length];
        source.get(data);
        ByteBuffer destination = this.getBuffer(address, length);
        destination.put(data);
    }

    @Override
    protected void memcpy(int destination, int source, int length, boolean checkOverlap) {
        destination = StandardMemory.normalizeAddress(destination);
        source = StandardMemory.normalizeAddress(source);
        if (checkOverlap || !this.areOverlapping(destination, source, length)) {
            ByteBuffer destinationBuffer = this.getBuffer(destination, length);
            ByteBuffer sourceBuffer = this.getBuffer(source, length);
            destinationBuffer.put(sourceBuffer);
        } else {
            IMemoryReader sourceReader = MemoryReader.getMemoryReader(source, length, 1);
            for (int i = 0; i < length; ++i) {
                this.write8(destination + i, (byte)sourceReader.readNext());
            }
        }
    }
}

