/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.TPointer;
import jpcsp.memory.IntArrayMemory;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public abstract class MMIOHandlerBaseMemoryStick
extends MMIOHandlerBase {
    private static final int STATE_VERSION = 0;
    public static final int MS_REG_OVR_BKST = 128;
    public static final int MS_REG_OVR_BKST_OK = 128;
    public static final int MS_REG_OVR_BKST_NG = 0;
    public static final int MS_REG_OVR_PGST0 = 64;
    public static final int MS_REG_OVR_PGST1 = 32;
    public static final int MS_REG_OVR_PGST_MASK = 96;
    public static final int MS_REG_OVR_PGST_OK = 96;
    public static final int MS_REG_OVR_PGST_NG = 32;
    public static final int MS_REG_OVR_PGST_DATA_ERROR = 0;
    public static final int MS_REG_OVR_UDST = 16;
    public static final int MS_REG_OVR_UDST_UPDATING = 0;
    public static final int MS_REG_OVR_UDST_NO_UPDATE = 16;
    public static final int MS_REG_OVR_RESERVED = 8;
    public static final int MS_REG_OVR_DEFAULT = 248;
    public static final int MS_REG_MNG_SCMS0 = 32;
    public static final int MS_REG_MNG_SCMS1 = 16;
    public static final int MS_REG_MNG_SCMS_MASK = 48;
    public static final int MS_REG_MNG_SCMS_COPY_OK = 48;
    public static final int MS_REG_MNG_SCMS_ONE_COPY = 16;
    public static final int MS_REG_MNG_SCMS_NO_COPY = 0;
    public static final int MS_REG_MNG_ATFLG = 8;
    public static final int MS_REG_MNG_ATFLG_OTHER = 8;
    public static final int MS_REG_MNG_ATFLG_ATTBL = 0;
    public static final int MS_REG_MNG_SYSFLG = 4;
    public static final int MS_REG_MNG_SYSFLG_USER = 4;
    public static final int MS_REG_MNG_SYSFLG_BOOT = 0;
    public static final int MS_REG_MNG_RESERVED = 195;
    public static final int MS_REG_MNG_DEFAULT = 255;
    public static final int MS_COMMANDSTATE_BUSY = 1;
    public static final int MS_SYS_COMMAND = 512;
    public static final int MS_SYS_INTERRUPT = 2048;
    public static final int MS_SYS_RESET = 32768;
    public static final int MS_STATUS_TIMEOUT = 256;
    public static final int MS_STATUS_CRC_ERROR = 512;
    public static final int MS_STATUS_READY = 4096;
    public static final int MS_STATUS_UNKNOWN = 8192;
    public static final int MS_STATUS_FIFO_RW = 16384;
    public static final int MS_TPC_READ_MG_STATUS = 1;
    public static final int MS_TPC_READ_PAGE_DATA = 2;
    public static final int MS_TPC_READ_SHORT_DATA = 3;
    public static final int MS_TPC_READ_REG = 4;
    public static final int MS_TPC_READ_IO_DATA = 5;
    public static final int MS_TPC_GET_INT = 7;
    public static final int MS_TPC_SET_RW_REG_ADDRESS = 8;
    public static final int MS_TPC_EX_SET_CMD = 9;
    public static final int MS_TPC_WRITE_IO_DATA = 10;
    public static final int MS_TPC_WRITE_REG = 11;
    public static final int MS_TPC_WRITE_SHORT_DATA = 12;
    public static final int MS_TPC_WRITE_PAGE_DATA = 13;
    public static final int MS_TPC_SET_CMD = 14;
    public static final int MS_INT_REG_ADDRESS = 1;
    public static final int MS_INT_REG_CMDNK = 16;
    public static final int MS_INT_REG_BREQ = 32;
    public static final int MS_INT_REG_ERR = 64;
    public static final int MS_INT_REG_CED = 128;
    public static final int MS_STATUS_REG_ADDRESS = 2;
    public static final int MS_STATUS_REG_READONLY = 1;
    public static final int MS_TYPE_ADDRESS = 4;
    public static final int MS_TYPE_MEMORY_STICK_PRO = 1;
    public static final int MS_SYSTEM_ADDRESS = 16;
    public static final int MS_SYSTEM_SERIAL_MODE = 128;
    public static final int MS_CMD_BLOCK_END = 51;
    public static final int MS_CMD_RESET = 60;
    public static final int MS_CMD_BLOCK_WRITE = 85;
    public static final int MS_CMD_SLEEP = 90;
    public static final int MS_CMD_LOAD_ID = 96;
    public static final int MS_CMD_CMP_ICV = 127;
    public static final int MS_CMD_BLOCK_ERASE = 153;
    public static final int MS_CMD_BLOCK_READ = 170;
    public static final int MS_CMD_CLEAR_BUF = 195;
    public static final int MS_CMD_FLASH_STOP = 204;
    public static final int MSPRO_CMD_FORMAT = 16;
    public static final int MSPRO_CMD_SLEEP = 17;
    public static final int MSPRO_CMD_WAKEUP = 18;
    public static final int MSPRO_CMD_READ_DATA = 32;
    public static final int MSPRO_CMD_WRITE_DATA = 33;
    public static final int MSPRO_CMD_READ_ATRB = 36;
    public static final int MSPRO_CMD_STOP = 37;
    public static final int MSPRO_CMD_ERASE = 38;
    public static final int MSPRO_CMD_READ_QUAD = 39;
    public static final int MSPRO_CMD_WRITE_QUAD = 40;
    public static final int MSPRO_CMD_SET_IBD = 70;
    public static final int MSPRO_CMD_GET_IBD = 71;
    public static final int MSPRO_CMD_IN_IO_DATA = 176;
    public static final int MSPRO_CMD_OUT_IO_DATA = 177;
    public static final int MSPRO_CMD_READ_IO_ATRB = 178;
    public static final int MSPRO_CMD_IN_IO_FIFO = 179;
    public static final int MSPRO_CMD_OUT_IO_FIFO = 180;
    public static final int MSPRO_CMD_IN_IOM = 181;
    public static final int MSPRO_CMD_OUT_IOM = 182;
    protected int interrupt;
    protected int commandState;
    protected int unk08;
    protected int tpc;
    protected int status;
    protected int sys;
    protected int unk40;
    protected final int[] registers = new int[256];
    protected int readAddress;
    protected int readSize;
    protected int writeAddress;
    protected int writeSize;
    protected int tpcExSetCmdIndex;
    protected int cmd;
    protected int oobLength;
    protected int startBlock;
    protected int oobIndex;
    protected final int[] pageBuffer = new int[128];
    protected final IntArrayMemory pageBufferMemory = new IntArrayMemory(this.pageBuffer);
    protected final TPointer pageBufferPointer = this.pageBufferMemory.getPointer();
    protected final IntArrayMemory msproAttributeMemory = new IntArrayMemory(new int[256]);
    protected int pageLba;
    protected int numberOfPages;
    protected int pageDataIndex;
    protected int pageIndex;
    protected int dataIndex;
    protected int commandDataIndex;
    public static final int PAGE_SIZE = 512;
    protected int PAGES_PER_BLOCK = 16;
    private final Object dmaLock = new Object();
    private int dmaTpcCode;

    public MMIOHandlerBaseMemoryStick(int baseAddress) {
        super(baseAddress);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.interrupt = stream.readInt();
        this.commandState = stream.readInt();
        this.unk08 = stream.readInt();
        this.tpc = stream.readInt();
        this.status = stream.readInt();
        this.sys = stream.readInt();
        this.unk40 = stream.readInt();
        stream.readInts(this.registers);
        this.readAddress = stream.readInt();
        this.readSize = stream.readInt();
        this.writeAddress = stream.readInt();
        this.writeSize = stream.readInt();
        this.tpcExSetCmdIndex = stream.readInt();
        this.cmd = stream.readInt();
        this.oobLength = stream.readInt();
        this.startBlock = stream.readInt();
        this.oobIndex = stream.readInt();
        this.pageBufferMemory.read(stream);
        this.msproAttributeMemory.read(stream);
        this.pageLba = stream.readInt();
        this.numberOfPages = stream.readInt();
        this.pageDataIndex = stream.readInt();
        this.pageIndex = stream.readInt();
        this.dataIndex = stream.readInt();
        this.commandDataIndex = stream.readInt();
        this.PAGES_PER_BLOCK = stream.readInt();
        this.dmaTpcCode = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.interrupt);
        stream.writeInt(this.commandState);
        stream.writeInt(this.unk08);
        stream.writeInt(this.tpc);
        stream.writeInt(this.status);
        stream.writeInt(this.sys);
        stream.writeInt(this.unk40);
        stream.writeInts(this.registers);
        stream.writeInt(this.readAddress);
        stream.writeInt(this.readSize);
        stream.writeInt(this.writeAddress);
        stream.writeInt(this.writeSize);
        stream.writeInt(this.tpcExSetCmdIndex);
        stream.writeInt(this.cmd);
        stream.writeInt(this.oobLength);
        stream.writeInt(this.startBlock);
        stream.writeInt(this.oobIndex);
        this.pageBufferMemory.write(stream);
        this.msproAttributeMemory.write(stream);
        stream.writeInt(this.pageLba);
        stream.writeInt(this.numberOfPages);
        stream.writeInt(this.pageDataIndex);
        stream.writeInt(this.pageIndex);
        stream.writeInt(this.dataIndex);
        stream.writeInt(this.commandDataIndex);
        stream.writeInt(this.PAGES_PER_BLOCK);
        stream.writeInt(this.dmaTpcCode);
        super.write(stream);
    }

    private static String getTPCName(int tpc) {
        switch (tpc) {
            case 1: {
                return "MS_TPC_READ_MG_STATUS";
            }
            case 2: {
                return "MS_TPC_READ_PAGE_DATA";
            }
            case 3: {
                return "MS_TPC_READ_SHORT_DATA";
            }
            case 4: {
                return "MS_TPC_READ_REG";
            }
            case 5: {
                return "MS_TPC_READ_IO_DATA";
            }
            case 7: {
                return "MS_TPC_GET_INT";
            }
            case 8: {
                return "MS_TPC_SET_RW_REG_ADDRESS";
            }
            case 9: {
                return "MS_TPC_EX_SET_CMD";
            }
            case 10: {
                return "MS_TPC_WRITE_IO_DATA";
            }
            case 11: {
                return "MS_TPC_WRITE_REG";
            }
            case 12: {
                return "MS_TPC_WRITE_SHORT_DATA";
            }
            case 13: {
                return "MS_TPC_WRITE_PAGE_DATA";
            }
            case 14: {
                return "MS_TPC_SET_CMD";
            }
        }
        return String.format("UNKNOWN_TPC_%X", tpc);
    }

    public static String getCommandName(int cmd) {
        switch (cmd) {
            case 51: {
                return "BLOCK_END";
            }
            case 60: {
                return "RESET";
            }
            case 85: {
                return "BLOCK_WRITE";
            }
            case 90: {
                return "SLEEP";
            }
            case 96: {
                return "LOAD_ID";
            }
            case 127: {
                return "CMP_ICV";
            }
            case 153: {
                return "BLOCK_ERASE";
            }
            case 170: {
                return "BLOCK_READ";
            }
            case 195: {
                return "CLEAR_BUF";
            }
            case 204: {
                return "FLASH_STOP";
            }
            case 16: {
                return "FORMAT";
            }
            case 17: {
                return "MSPRO_SLEEP";
            }
            case 18: {
                return "WAKEUP";
            }
            case 32: {
                return "READ_DATA";
            }
            case 33: {
                return "WRITE_DATA";
            }
            case 36: {
                return "READ_ATRB";
            }
            case 37: {
                return "STOP";
            }
            case 38: {
                return "ERASE";
            }
            case 39: {
                return "READ_QUAD";
            }
            case 40: {
                return "WRITE_QUAD";
            }
            case 70: {
                return "SET_IBD";
            }
            case 71: {
                return "GET_IBD";
            }
            case 176: {
                return "IN_IO_DATA";
            }
            case 177: {
                return "OUT_IO_DATA";
            }
            case 178: {
                return "READ_IO_ATRB";
            }
            case 179: {
                return "IN_IO_FIFO";
            }
            case 180: {
                return "OUT_IO_FIFO";
            }
            case 181: {
                return "IN_IOM";
            }
            case 182: {
                return "OUT_IOM";
            }
        }
        return String.format("UNKNOWN_CMD_%X", cmd);
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.registers, 0);
        this.interrupt = 0;
        this.commandState = 0;
        this.unk08 = 0;
        this.tpc = 0;
        this.status = 4096;
        this.sys = 0;
        this.readAddress = 0;
        this.readSize = 0;
        this.writeAddress = 0;
        this.writeSize = 0;
        this.cmd = 0;
        this.numberOfPages = 0;
        this.pageLba = 0;
        this.pageIndex = 0;
        this.pageDataIndex = 0;
        this.dataIndex = 0;
        this.startBlock = 0;
        this.oobLength = 0;
        this.oobIndex = 0;
        this.commandDataIndex = 0;
        this.dmaTpcCode = -1;
        this.setRegisterValue(1, 128);
    }

    private void writeSys(int sys) {
        this.sys = sys &= 0xFFFFF5FF;
        if ((sys & 0x8000) != 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.writeSys reset triggered", new Object[0]));
            }
            this.reset();
        }
    }

    private void writeCommandState(int commandState) {
        this.commandState = commandState;
        if (this.isBusy()) {
            this.clearBusy();
        }
    }

    private int getStatus() {
        return this.status & 0xFFFFFFF0 | this.getRegisterValue(1) >> 4 & 0xF;
    }

    private void setBusy() {
        this.commandState |= 1;
    }

    public void clearBusy() {
        this.commandState &= 0xFFFFFFFE;
    }

    private boolean isBusy() {
        return (this.commandState & 1) != 0;
    }

    private void setInterrupt(int interrupt) {
        this.interrupt |= interrupt;
        this.checkInterrupt();
    }

    private void setInterrupt() {
        this.setInterrupt(this.getInterruptBit());
    }

    private void clearInterrupt(int interrupt) {
        if ((interrupt & 1) != 0) {
            interrupt &= 0xFFFFFFFB;
        }
        this.interrupt &= ~interrupt;
        this.checkInterrupt();
    }

    protected abstract int getInterruptNumber();

    protected abstract int getInterruptBit();

    private void checkInterrupt() {
        if (this.interrupt != 0) {
            RuntimeContextLLE.triggerInterrupt(this.getProcessor(), this.getInterruptNumber());
        } else {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), this.getInterruptNumber());
        }
    }

    protected boolean isMemoryStickPro() {
        return (this.getRegisterValue(4) & 1) != 0;
    }

    protected boolean isSerialMode() {
        if (!this.isMemoryStickPro()) {
            return true;
        }
        return (this.getRegisterValue(16) & 0x80) != 0;
    }

    protected int getTPCCode() {
        return this.tpc >> 12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTPC(int tpc) {
        Object object = this.dmaLock;
        synchronized (object) {
            this.tpc = tpc;
            int tpcCode = this.getTPCCode();
            int size = tpc & 0x3FF;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("startTPC tpcCode=0x%01X(%s), size=0x%03X", tpcCode, MMIOHandlerBaseMemoryStick.getTPCName(tpcCode), size));
            }
            switch (tpcCode) {
                case 8: {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startTPC MS_TPC_SET_RW_REG_ADDRESS", new Object[0]));
                    break;
                }
                case 4: {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startTPC MS_TPC_READ_REG readAddress=0x%02X, readSize=0x%X", this.readAddress, this.readSize));
                    break;
                }
                case 11: {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startTPC MS_TPC_WRITE_REG writeAddress=0x%02X, writeSize=0x%X", this.writeAddress, this.writeSize));
                    break;
                }
                case 14: {
                    this.setRegisterValue(1, this.getRegisterValue(1) & 0xFFFFFF7F);
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startTPC MS_TPC_SET_CMD", new Object[0]));
                    break;
                }
                case 9: {
                    this.setRegisterValue(1, this.getRegisterValue(1) & 0xFFFFFF7F);
                    this.tpcExSetCmdIndex = 0;
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startTPC MS_TPC_EX_SET_CMD", new Object[0]));
                    break;
                }
                case 7: {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startTPC MS_TPC_GET_INT", new Object[0]));
                    break;
                }
                case 2: {
                    this.readSize = 512;
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startTPC MS_TPC_READ_PAGE_DATA readSize=0x%X", this.readSize));
                    break;
                }
                case 5: {
                    this.readSize = size;
                    this.pageDataIndex = 0;
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startTPC MS_TPC_READ_IO_DATA readSize=0x%X", this.readSize));
                    break;
                }
                case 10: {
                    this.writeSize = size;
                    this.pageDataIndex = 0;
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startTPC MS_TPC_WRITE_IO_DATA writeSize=0x%X", this.writeSize));
                    break;
                }
                case 13: {
                    this.writeSize = size;
                    this.pageDataIndex = 0;
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startTPC MS_TPC_WRITE_PAGE_DATA writeSize=0x%X", this.writeSize));
                    break;
                }
                default: {
                    this.log.error((Object)String.format("MMIOHandlerBaseMemoryStick.startTPC unknown TPC 0x%01X", tpcCode));
                }
            }
            this.status |= 0x4000;
            this.dmaTpcCode = tpcCode;
        }
    }

    private int getDataCount() {
        if (this.isMemoryStickPro()) {
            return this.getRegisterValue(17, 2);
        }
        return 512;
    }

    private int getDataAddress() {
        if (this.isMemoryStickPro()) {
            return this.getRegisterValue(19, 4);
        }
        int blockAddress = this.getRegisterValue(17, 3);
        int pageAddress = this.getRegisterValue(21, 1);
        return blockAddress * this.PAGES_PER_BLOCK + pageAddress;
    }

    private void startCmd(int cmd) {
        this.setCmd(cmd);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startCmd cmd=0x%02X(%s)", cmd, MMIOHandlerBaseMemoryStick.getCommandName(cmd)));
        }
        boolean commandCompleted = true;
        switch (cmd) {
            case 170: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startCmd MS_CMD_BLOCK_READ dataCount=0x%04X, dataAddress=0x%08X, cp=0x%02X", this.getDataCount(), this.getDataAddress(), this.getRegisterValue(20, 1)));
                }
                this.setBusy();
                if (this.isMemoryStickPro()) break;
                this.setRegisterValue(22, 128);
                this.setRegisterValue(23, 0);
                break;
            }
            case 153: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startCmd MS_CMD_BLOCK_ERASE dataCount=0x%04X, dataAddress=0x%08X, cp=0x%02X", this.getDataCount(), this.getDataAddress(), this.getRegisterValue(20, 1)));
                }
                this.clearBusy();
                break;
            }
            case 85: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startCmd MS_CMD_BLOCK_WRITE dataCount=0x%04X, dataAddress=0x%08X, cp=0x%02X", this.getDataCount(), this.getDataAddress(), this.getRegisterValue(20, 1)));
                break;
            }
            case 17: 
            case 18: 
            case 90: {
                break;
            }
            case 32: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startCmd MSPRO_CMD_READ_DATA dataCount=0x%04X, dataAddress=0x%08X", this.getDataCount(), this.getDataAddress()));
                }
                this.setNumberOfPages(this.getDataCount());
                this.setStartBlock(0);
                this.setPageLba(this.getDataAddress());
                commandCompleted = false;
                break;
            }
            case 33: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startCmd MSPRO_CMD_WRITE_DATA dataCount=0x%04X, dataAddress=0x%08X", this.getDataCount(), this.getDataAddress()));
                }
                this.setNumberOfPages(this.getDataCount());
                this.setStartBlock(0);
                this.setPageLba(this.getDataAddress());
                commandCompleted = false;
                this.setInterrupt();
                break;
            }
            case 178: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startCmd MSPRO_CMD_READ_IO_ATRB dataCount=0x%04X, dataAddress=0x%08X", this.getDataCount(), this.getDataAddress()));
                }
                commandCompleted = false;
                break;
            }
            case 179: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startCmd MSPRO_CMD_IN_IO_FIFO dataCount=0x%04X, dataAddress=0x%08X", this.getDataCount(), this.getDataAddress()));
                }
                commandCompleted = false;
                break;
            }
            case 180: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.startCmd MSPRO_CMD_OUT_IO_FIFO dataCount=0x%04X, dataAddress=0x%08X", this.getDataCount(), this.getDataAddress()));
                }
                commandCompleted = false;
                break;
            }
            default: {
                this.log.error((Object)String.format("MMIOHandlerBaseMemoryStick.startCmd unknown cmd=0x%02X", cmd));
            }
        }
        this.pageIndex = 0;
        this.pageDataIndex = 0;
        this.dataIndex = 0;
        this.status |= 0x2000;
        if (commandCompleted) {
            this.setRegisterValue(1, 128);
            this.sys |= 0x4000;
            this.setInterrupt();
        } else {
            this.setRegisterValue(1, 32);
        }
    }

    protected abstract int readData16(int var1, int var2, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readData16() {
        while (true) {
            Object object = this.dmaLock;
            synchronized (object) {
                if (this.dmaTpcCode == 5 || this.dmaTpcCode == 4 || this.dmaTpcCode == 7) {
                    break;
                }
            }
            Utilities.sleep(10);
        }
        int dataAddress = this.getDataAddress();
        int value = 0;
        Object object = this.dmaLock;
        synchronized (object) {
            if (this.pageDataIndex < this.readSize) {
                boolean endOfCommand = this.dataIndex + 2 >= this.getDataCount();
                value = this.readData16(dataAddress, this.dataIndex, endOfCommand);
                this.pageDataIndex += 2;
                this.dataIndex += 2;
                if (endOfCommand) {
                    this.setRegisterValue(1, 128);
                    this.clearBusy();
                    this.status |= 0x2000;
                    this.sys |= 0x4000;
                    this.setInterrupt();
                    this.dmaTpcCode = -1;
                }
            }
            if (this.pageDataIndex >= this.readSize) {
                this.dmaTpcCode = -1;
            }
        }
        return value;
    }

    private int readOOBData16() {
        int value = (this.oobIndex & 3) == 0 ? 65528 : Utilities.endianSwap16(this.startBlock + (this.oobIndex >> 2));
        this.oobIndex += 2;
        if (this.oobIndex >= this.oobLength << 2) {
            this.oobIndex = 0;
            this.clearBusy();
            this.status |= 0x2000;
            this.sys |= 0x4000;
            this.unk08 |= 0x40;
            this.unk08 &= 0xFFFFFFF0;
            this.setInterrupt();
        }
        return value;
    }

    private int readPageData16() {
        int value;
        switch (this.cmd) {
            case 170: {
                if (this.pageDataIndex == 0) {
                    this.readPageBuffer();
                }
                value = this.pageBufferMemory.read16(this.pageDataIndex);
                break;
            }
            default: {
                this.log.error((Object)String.format("MMIOHandlerBaseMemoryStick.readPageData16 unimplemented cmd=0x%02X(%s)", this.cmd, MMIOHandlerBaseMemoryStick.getCommandName(this.cmd)));
                value = 0;
            }
        }
        this.pageDataIndex += 2;
        if (this.pageDataIndex >= 512) {
            this.pageDataIndex = 0;
            ++this.pageIndex;
            if (this.pageIndex >= this.numberOfPages) {
                this.pageIndex = 0;
                this.clearBusy();
                this.status |= 0x2000;
                this.sys |= 0x4000;
                this.unk08 |= 0x40;
                this.unk08 &= 0xFFFFFFF0;
                this.setInterrupt();
            }
        }
        return value;
    }

    private void setNumberOfPages(int numberOfPages) {
        this.numberOfPages = numberOfPages;
        this.pageIndex = 0;
        this.pageDataIndex = 0;
    }

    private void setPageLba(int pageLba) {
        this.pageLba = pageLba;
        this.pageIndex = 0;
        this.pageDataIndex = 0;
    }

    private void setStartBlock(int startBlock) {
        this.startBlock = startBlock;
        this.pageIndex = 0;
        this.pageDataIndex = 0;
        this.oobIndex = 0;
    }

    private void setCmd(int cmd) {
        this.cmd = cmd;
    }

    protected abstract void readPageBuffer();

    private int readTPCData32() {
        int data = 0;
        switch (this.getTPCCode()) {
            case 7: {
                data = this.getRegisterValue(1);
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.readTPCData32 MS_TPC_GET_INT registers[0x%02X]=0x%02X", 1, data));
                break;
            }
            case 4: {
                for (int i = 0; i < 32 && this.readSize > 0 && this.readAddress < this.registers.length; i += 8) {
                    data |= this.getRegisterValue(this.readAddress) << i;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.readTPCData32 MS_TPC_READ_REG registers[0x%02X]=0x%02X", this.readAddress, this.getRegisterValue(this.readAddress)));
                    }
                    --this.readSize;
                    ++this.readAddress;
                }
                break;
            }
            case 5: {
                data = this.readData16() | this.readData16() << 16;
                break;
            }
            case 2: {
                if (this.pageDataIndex == 0) {
                    this.readPageBuffer();
                }
                data = this.pageBufferMemory.read32(this.pageDataIndex);
                this.increaseReadPageDataIndex(4);
                break;
            }
            default: {
                this.log.error((Object)String.format("MMIOHandlerBaseMemoryStick.readTPCData32 unimplemented tpcCode=0x%01X(%s)", this.getTPCCode(), MMIOHandlerBaseMemoryStick.getTPCName(this.getTPCCode())));
                data = 0;
            }
        }
        return data;
    }

    protected abstract void initMsproAttributeMemory();

    private void increaseReadPageDataIndex(int length) {
        this.pageDataIndex += length;
        if (this.pageDataIndex >= 512) {
            this.pageDataIndex = 0;
            ++this.pageIndex;
            if (this.pageIndex >= this.numberOfPages) {
                this.setRegisterValue(1, 128);
                this.pageIndex = 0;
                this.commandDataIndex = 0;
                this.clearBusy();
                this.status |= 0x2000;
                this.sys |= 0x4000;
                this.unk08 |= 0x40;
                this.unk08 &= 0xFFFFFFF0;
                this.setInterrupt();
            }
        }
    }

    private int readPageData32() {
        int value;
        switch (this.cmd) {
            case 36: {
                this.initMsproAttributeMemory();
                value = this.msproAttributeMemory.read32(this.pageLba * 512 + this.pageDataIndex);
                break;
            }
            case 32: {
                if (this.pageDataIndex == 0) {
                    this.readPageBuffer();
                }
                value = this.pageBufferMemory.read32(this.pageDataIndex);
                break;
            }
            default: {
                this.log.error((Object)String.format("MMIOHandlerBaseMemoryStick.readPageData32 unimplemented cmd=0x%02X(%s)", this.cmd, MMIOHandlerBaseMemoryStick.getCommandName(this.cmd)));
                value = 0;
            }
        }
        this.increaseReadPageDataIndex(4);
        return value;
    }

    protected int getRegisterValue(int register) {
        return this.registers[register] & 0xFF;
    }

    protected int getRegisterValue(int reg, int length) {
        int value = 0;
        for (int i = 0; i < length; ++i) {
            value = value << 8 | this.getRegisterValue(reg + i);
        }
        return value;
    }

    protected void setRegisterValue(int register, int value) {
        this.registers[register] = value;
    }

    protected void setRegisterValue(int register, int length, int value) {
        for (int i = length - 1; i >= 0; --i) {
            this.registers[register + i] = value & 0xFF;
            value >>>= 8;
        }
    }

    private void writeTPCData16(int value) {
        if (this.tpc < 0) {
            return;
        }
        switch (this.getTPCCode()) {
            case 10: {
                int dataAddress = this.getDataAddress();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.writeTPCData16 MS_TPC_WRITE_IO_DATA dataAddress=0x%X, pageDataIndex=0x%X, writeSize=0x%X, dataIndex=0x%X, value=0x%04X", dataAddress, this.pageDataIndex, this.writeSize, this.dataIndex, value));
                }
                if (this.pageDataIndex >= this.writeSize) break;
                boolean endOfCommand = this.dataIndex + 2 >= this.getDataCount();
                this.writeData16(dataAddress, this.dataIndex, value, endOfCommand);
                this.pageDataIndex += 2;
                this.dataIndex += 2;
                if (!endOfCommand) break;
                this.setRegisterValue(1, 128);
                this.clearBusy();
                this.status |= 0x2000;
                this.sys |= 0x4000;
                this.setInterrupt();
                break;
            }
            default: {
                this.log.error((Object)String.format("MMIOHandlerBaseMemoryStick.writeTPCData16 unimplemented TPCCode=0x%X", this.getTPCCode()));
            }
        }
    }

    private void writeTPCData(int value) {
        if (this.tpc < 0) {
            return;
        }
        switch (this.getTPCCode()) {
            case 8: {
                this.readAddress = value & 0xFF;
                this.readSize = value >> 8 & 0xFF;
                this.writeAddress = value >> 16 & 0xFF;
                this.writeSize = value >> 24 & 0xFF;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.writeTPCData MS_TPC_SET_RW_REG_ADDRESS readAddress=0x%02X, readSize=0x%X, writeAddress=0x%02X, writeSize=0x%X", this.readAddress, this.readSize, this.writeAddress, this.writeSize));
                }
                this.tpc = -1;
                break;
            }
            case 11: {
                for (int i = 0; i < 4 && this.writeSize > 0 && this.writeAddress < this.registers.length; ++i) {
                    this.setRegisterValue(this.writeAddress, value & 0xFF);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.writeTPCData MS_TPC_WRITE_REG registers[0x%02X]=0x%02X", this.writeAddress, this.getRegisterValue(this.writeAddress)));
                    }
                    ++this.writeAddress;
                    --this.writeSize;
                    value >>>= 8;
                }
                break;
            }
            case 14: {
                this.startCmd(value & 0xFF);
                this.tpc = -1;
                break;
            }
            case 9: {
                switch (this.tpcExSetCmdIndex) {
                    case 0: {
                        this.setCmd(value & 0xFF);
                        this.setRegisterValue(17, value >> 8 & 0xFF);
                        this.setRegisterValue(18, value >> 16 & 0xFF);
                        this.setRegisterValue(19, value >> 24 & 0xFF);
                        break;
                    }
                    case 1: {
                        this.setRegisterValue(20, value >> 0 & 0xFF);
                        this.setRegisterValue(21, value >> 8 & 0xFF);
                        this.setRegisterValue(22, value >> 16 & 0xFF);
                        this.startCmd(this.cmd);
                        break;
                    }
                    default: {
                        this.log.error((Object)String.format("Too many parameters to MS_TPC_EX_SET_CMD: 0x%X", value));
                    }
                }
                ++this.tpcExSetCmdIndex;
                break;
            }
            case 10: {
                int dataAddress = this.getDataAddress();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.writeTPCData MS_TPC_WRITE_IO_DATA dataAddress=0x%X, pageDataIndex=0x%X, writeSize=0x%X, dataIndex=0x%X, value=0x%08X", dataAddress, this.pageDataIndex, this.writeSize, this.dataIndex, value));
                }
                if (this.pageDataIndex >= this.writeSize) break;
                boolean endOfCommand = this.dataIndex + 4 >= this.getDataCount();
                this.writeData32(dataAddress, this.dataIndex, value, endOfCommand);
                this.pageDataIndex += 4;
                this.dataIndex += 4;
                if (!endOfCommand) break;
                this.setRegisterValue(1, 128);
                this.clearBusy();
                this.status |= 0x2000;
                this.sys |= 0x4000;
                this.setInterrupt();
                break;
            }
            case 13: {
                this.pageBufferMemory.write32(this.pageDataIndex, value);
                this.increaseWritePageDataIndex(4);
                break;
            }
            default: {
                this.log.error((Object)String.format("MMIOHandlerBaseMemoryStick.writeTPCData unimplemented tpcCode=0x%01X(%s)", this.getTPCCode(), MMIOHandlerBaseMemoryStick.getTPCName(this.getTPCCode())));
            }
        }
    }

    protected abstract void writeData16(int var1, int var2, int var3, boolean var4);

    protected abstract void writeData32(int var1, int var2, int var3, boolean var4);

    private void writeCommandData8(int value) {
        block0 : switch (this.commandDataIndex) {
            case 0: {
                this.setCmd(value);
                this.tpc = 14;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.writeCommandData8 cmd=0x%02X(%s)", this.cmd, MMIOHandlerBaseMemoryStick.getCommandName(this.cmd)));
                }
                switch (this.cmd) {
                    case 36: {
                        break block0;
                    }
                    case 32: {
                        break block0;
                    }
                    case 33: {
                        break block0;
                    }
                }
                this.log.error((Object)String.format("MMIOHandlerBaseMemoryStick.writeCommandData8 unimplemented cmd=0x%02X(%s)", this.cmd, MMIOHandlerBaseMemoryStick.getCommandName(this.cmd)));
                break;
            }
            case 1: {
                this.numberOfPages = this.numberOfPages & 0xFF | value << 8;
                break;
            }
            case 2: {
                this.setNumberOfPages(this.numberOfPages & 0xFF00 | value);
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)String.format("numberOfPages=0x%X", this.numberOfPages));
                break;
            }
            case 3: {
                this.pageLba = this.pageLba & 0xFFFFFF | value << 24;
                break;
            }
            case 4: {
                this.pageLba = this.pageLba & 0xFF00FFFF | value << 16;
                break;
            }
            case 5: {
                this.pageLba = this.pageLba & 0xFFFF00FF | value << 8;
                break;
            }
            case 6: {
                this.setStartBlock(0);
                this.setPageLba(this.pageLba & 0xFFFFFF00 | value);
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)String.format("pageLba=0x%X", this.pageLba));
                break;
            }
            default: {
                this.log.error((Object)String.format("MMIOHandlerBaseMemoryStick.writeCommandData8 unknown data 0x%02X written at index 0x%X", value, this.commandDataIndex));
            }
        }
        ++this.commandDataIndex;
    }

    protected abstract void writePageBuffer();

    private void increaseWritePageDataIndex(int length) {
        this.pageDataIndex += 4;
        if (this.pageDataIndex >= 512) {
            this.pageDataIndex = 0;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("MMIOHandlerBaseMemoryStick.increaseWritePageDataIndex writing page 0x%X/0x%X", this.pageIndex, this.numberOfPages));
            }
            this.writePageBuffer();
            ++this.pageIndex;
            if (this.pageIndex >= this.numberOfPages) {
                this.setRegisterValue(1, 128);
                this.pageIndex = 0;
                this.commandDataIndex = 0;
                this.clearBusy();
                this.status |= 0x2000;
                this.sys |= 0x4000;
                this.unk08 |= 0x40;
                this.unk08 &= 0xFFFFFFF0;
                this.setInterrupt();
            }
        }
    }

    private void writePageData32(int value) {
        switch (this.cmd) {
            case 33: {
                this.pageBufferMemory.write32(this.pageDataIndex, value);
                break;
            }
            default: {
                this.log.error((Object)String.format("MMIOHandlerBaseMemoryStick.writePageData32 unimplemented cmd=0x%02X(%s)", this.cmd, MMIOHandlerBaseMemoryStick.getCommandName(this.cmd)));
            }
        }
        this.increaseWritePageDataIndex(4);
    }

    @Override
    public int read16(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = this.interrupt;
                break;
            }
            case 4: {
                value = this.commandState;
                break;
            }
            case 8: {
                value = this.unk08;
                break;
            }
            case 36: {
                value = this.readOOBData16();
                break;
            }
            case 40: {
                value = this.readPageData16();
                break;
            }
            case 48: {
                value = this.tpc;
                break;
            }
            case 52: {
                value = this.readData16();
                break;
            }
            case 56: {
                value = this.getStatus();
                break;
            }
            case 60: {
                value = this.sys;
                break;
            }
            default: {
                value = super.read16(address);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - read16(0x%08X) returning 0x%04X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 40: {
                value = this.readPageData32();
                break;
            }
            case 48: {
                value = this.tpc;
                break;
            }
            case 52: {
                value = this.readTPCData32();
                break;
            }
            case 56: {
                value = this.getStatus();
                break;
            }
            case 60: {
                value = this.sys;
                break;
            }
            case 64: {
                value = this.unk40;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write16(int address, short value) {
        switch (address - this.baseAddress) {
            case 0: {
                this.clearInterrupt(value & 0xFFFF);
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.writeCommandState(value & 0xFFFF);
                break;
            }
            case 16: {
                this.setNumberOfPages(value);
                break;
            }
            case 18: {
                this.oobLength = value;
                break;
            }
            case 20: {
                this.setStartBlock(value);
                break;
            }
            case 22: {
                this.setCmd(170);
                this.setPageLba(value);
                break;
            }
            case 32: {
                break;
            }
            case 48: {
                this.startTPC(value & 0xFFFF);
                break;
            }
            case 52: {
                this.writeTPCData16(value & 0xFFFF);
                break;
            }
            case 56: {
                this.status = value & 0xFFFF;
                break;
            }
            case 60: {
                this.writeSys(value & 0xFFFF);
                break;
            }
            default: {
                super.write16(address, value);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - write16(0x%08X, 0x%04X) on %s", this.getPc(), address, value & 0xFFFF, this));
        }
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 40: {
                this.writePageData32(value);
                break;
            }
            case 48: {
                this.startTPC(value);
                break;
            }
            case 52: {
                this.writeTPCData(value);
                break;
            }
            case 60: {
                this.writeSys(value);
                break;
            }
            case 64: {
                this.unk40 = value;
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    @Override
    public void write8(int address, byte value) {
        switch (address - this.baseAddress) {
            case 36: {
                this.writeCommandData8(value & 0xFF);
                break;
            }
            default: {
                super.write8(address, value);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - write8(0x%08X, 0x%02X) on %s", this.getPc(), address, value & 0xFF, this));
        }
    }
}

