/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.sceGe_user;
import jpcsp.graphics.GeCommands;
import jpcsp.graphics.RE.externalge.CoreThreadMMIO;
import jpcsp.graphics.RE.externalge.ExternalGE;
import jpcsp.graphics.RE.externalge.NativeUtils;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MMIOHandlerGe
extends MMIOHandlerBase {
    public static Logger log = sceGe_user.log;
    private static final int STATE_VERSION = 0;
    public static final int BASE_ADDRESS = -1119879168;
    private static MMIOHandlerGe instance;
    private int ctrl;
    private int status;
    private int list;
    private int stall;
    private int raddr1;
    private int raddr2;
    private int vaddr;
    private int iaddr;
    private int oaddr;
    private int oaddr1;
    private int oaddr2;
    private int cmdStatus;
    private int interrupt;
    private int unknown200;
    private int unknown400;

    public static MMIOHandlerGe getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerGe(-1119879168);
        }
        return instance;
    }

    private MMIOHandlerGe(int baseAddress) {
        super(baseAddress);
        ExternalGE.init();
        if (!ExternalGE.isActive()) {
            log.error((Object)String.format("MMIOHandlerGe is only working with the External Software Renderer", new Object[0]));
        }
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        int i;
        stream.readVersion(0);
        this.setStatus(stream.readInt());
        this.setList(stream.readInt());
        this.setStall(stream.readInt());
        this.setRaddr1(stream.readInt());
        this.setRaddr2(stream.readInt());
        this.setVaddr(stream.readInt());
        this.setIaddr(stream.readInt());
        this.setOaddr(stream.readInt());
        this.setOaddr1(stream.readInt());
        this.setOaddr2(stream.readInt());
        this.setCmdStatus(stream.readInt());
        this.setInterrupt(stream.readInt());
        this.unknown200 = stream.readInt();
        this.unknown400 = stream.readInt();
        for (int cmd = 0; cmd <= 255; ++cmd) {
            int value = stream.readInt();
            this.writeGeCmd(cmd, value);
        }
        for (i = 0; i < 96; ++i) {
            this.writeGeBone(i, stream.readInt());
        }
        for (i = 0; i < 12; ++i) {
            this.writeGeWorld(i, stream.readInt());
        }
        for (i = 0; i < 12; ++i) {
            this.writeGeView(i, stream.readInt());
        }
        for (i = 0; i < 16; ++i) {
            this.writeGeProjection(i, stream.readInt());
        }
        for (i = 0; i < 12; ++i) {
            this.writeGeTexture(i, stream.readInt());
        }
        this.setCtrl(stream.readInt());
        super.read(stream);
        Modules.sceDisplayModule.setGeDirty(true);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        int i;
        stream.writeVersion(0);
        stream.writeInt(this.getStatus());
        stream.writeInt(this.getList());
        stream.writeInt(this.getStall());
        stream.writeInt(this.getRaddr1());
        stream.writeInt(this.getRaddr2());
        stream.writeInt(this.getVaddr());
        stream.writeInt(this.getIaddr());
        stream.writeInt(this.getOaddr());
        stream.writeInt(this.getOaddr1());
        stream.writeInt(this.getOaddr2());
        stream.writeInt(this.getCmdStatus());
        stream.writeInt(this.getInterrupt());
        stream.writeInt(this.unknown200);
        stream.writeInt(this.unknown400);
        for (int cmd = 0; cmd <= 255; ++cmd) {
            stream.writeInt(this.readGeCmd(cmd));
        }
        for (i = 0; i < 96; ++i) {
            stream.writeInt(this.readGeBone(i));
        }
        for (i = 0; i < 12; ++i) {
            stream.writeInt(this.readGeWorld(i));
        }
        for (i = 0; i < 12; ++i) {
            stream.writeInt(this.readGeView(i));
        }
        for (i = 0; i < 16; ++i) {
            stream.writeInt(this.readGeProjection(i));
        }
        for (i = 0; i < 12; ++i) {
            stream.writeInt(this.readGeTexture(i));
        }
        stream.writeInt(this.getCtrl());
        super.write(stream);
    }

    @Override
    public void reset() {
        int i;
        super.reset();
        this.setStatus(0);
        this.setList(0);
        this.setStall(0);
        this.setRaddr1(0);
        this.setRaddr2(0);
        this.setVaddr(0);
        this.setIaddr(0);
        this.setOaddr(0);
        this.setOaddr1(0);
        this.setOaddr2(0);
        this.setCmdStatus(0);
        this.setInterrupt(0);
        this.unknown200 = 0;
        this.unknown400 = 0;
        for (int cmd = 0; cmd <= 255; ++cmd) {
            int value = 0;
            this.writeGeCmd(cmd, value);
        }
        for (i = 0; i < 96; ++i) {
            this.writeGeBone(i, 0);
        }
        for (i = 0; i < 12; ++i) {
            this.writeGeWorld(i, 0);
        }
        for (i = 0; i < 12; ++i) {
            this.writeGeView(i, 0);
        }
        for (i = 0; i < 16; ++i) {
            this.writeGeProjection(i, 0);
        }
        for (i = 0; i < 12; ++i) {
            this.writeGeTexture(i, 0);
        }
        this.setCtrl(0);
    }

    public void onGeInterrupt() {
        this.checkInterrupt();
        Modules.sceDisplayModule.setGeDirty(true);
    }

    private int getStatus() {
        if (ExternalGE.isActive()) {
            this.status = NativeUtils.getCoreStat();
        }
        return this.status;
    }

    private void setStatus(int status) {
        this.status = status;
        if (ExternalGE.isActive()) {
            NativeUtils.setCoreStat(status);
        }
    }

    private int getList() {
        if (ExternalGE.isActive()) {
            this.list = NativeUtils.getCoreMadr();
        }
        return this.list;
    }

    private void setList(int list) {
        this.list = list;
        if (ExternalGE.isActive()) {
            NativeUtils.setCoreMadr(list);
        }
    }

    private int getStall() {
        if (ExternalGE.isActive()) {
            this.stall = NativeUtils.getCoreSadr();
        }
        return this.stall;
    }

    private void setStall(int stall) {
        this.stall = stall;
        if (ExternalGE.isActive()) {
            NativeUtils.setCoreSadr(stall);
            CoreThreadMMIO.getInstance().sync();
        }
    }

    private int getRaddr1() {
        if (ExternalGE.isActive()) {
            this.raddr1 = NativeUtils.getCoreRadr1();
        }
        return this.raddr1;
    }

    private void setRaddr1(int raddr1) {
        this.raddr1 = raddr1;
        if (ExternalGE.isActive()) {
            NativeUtils.setCoreRadr1(raddr1);
        }
    }

    private int getRaddr2() {
        if (ExternalGE.isActive()) {
            this.raddr2 = NativeUtils.getCoreRadr2();
        }
        return this.raddr2;
    }

    private void setRaddr2(int raddr2) {
        this.raddr2 = raddr2;
        if (ExternalGE.isActive()) {
            NativeUtils.setCoreRadr2(raddr2);
        }
    }

    private int getVaddr() {
        if (ExternalGE.isActive()) {
            this.vaddr = NativeUtils.getCoreVadr();
        }
        return this.vaddr;
    }

    private void setVaddr(int vaddr) {
        this.vaddr = vaddr;
        if (ExternalGE.isActive()) {
            NativeUtils.setCoreVadr(vaddr);
        }
    }

    private int getIaddr() {
        if (ExternalGE.isActive()) {
            this.iaddr = NativeUtils.getCoreIadr();
        }
        return this.iaddr;
    }

    private void setIaddr(int iaddr) {
        this.iaddr = iaddr;
        if (ExternalGE.isActive()) {
            NativeUtils.setCoreIadr(iaddr);
        }
    }

    private int getOaddr() {
        if (ExternalGE.isActive()) {
            this.oaddr = NativeUtils.getCoreOadr();
        }
        return this.oaddr;
    }

    private void setOaddr(int oaddr) {
        this.oaddr = oaddr;
        if (ExternalGE.isActive()) {
            NativeUtils.setCoreOadr(oaddr);
        }
    }

    private int getOaddr1() {
        if (ExternalGE.isActive()) {
            this.oaddr1 = NativeUtils.getCoreOadr1();
        }
        return this.oaddr1;
    }

    private void setOaddr1(int oaddr1) {
        this.oaddr1 = oaddr1;
        if (ExternalGE.isActive()) {
            NativeUtils.setCoreOadr1(oaddr1);
        }
    }

    private int getOaddr2() {
        if (ExternalGE.isActive()) {
            this.oaddr2 = NativeUtils.getCoreOadr2();
        }
        return this.oaddr2;
    }

    private void setOaddr2(int oaddr2) {
        this.oaddr2 = oaddr2;
        if (ExternalGE.isActive()) {
            NativeUtils.setCoreOadr2(oaddr2);
        }
    }

    private int getCmdStatus() {
        if (ExternalGE.isActive()) {
            this.cmdStatus = NativeUtils.getCoreIntrStat();
        }
        return this.cmdStatus;
    }

    private void setCmdStatus(int cmdStatus) {
        this.cmdStatus = cmdStatus;
        if (ExternalGE.isActive()) {
            NativeUtils.setCoreIntrStat(cmdStatus);
        }
        this.setInterrupt(this.getInterrupt() & cmdStatus);
    }

    private void changeCmdStatus(int mask) {
        this.setCmdStatus(this.cmdStatus ^ mask);
    }

    private synchronized int getInterrupt() {
        if (ExternalGE.isActive()) {
            this.interrupt = NativeUtils.getCoreInterrupt();
        }
        return this.interrupt;
    }

    private synchronized void checkInterrupt() {
        if ((this.getInterrupt() & 2) == 0) {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), 25);
        } else {
            RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 25);
        }
    }

    private synchronized void setInterrupt(int interrupt) {
        this.interrupt = interrupt;
        if (ExternalGE.isActive()) {
            NativeUtils.setCoreInterrupt(interrupt);
        }
        this.checkInterrupt();
    }

    private synchronized void changeInterrupt(int mask) {
        this.setInterrupt(this.getInterrupt() ^ mask);
    }

    private synchronized void clearInterrupt(int mask) {
        this.setInterrupt(this.getInterrupt() & ~mask);
    }

    private void startGeList() {
        if (ExternalGE.isActive()) {
            NativeUtils.setLogLevel();
            NativeUtils.setScreenScale(ExternalGE.getScreenScale());
            CoreThreadMMIO.getInstance().sync();
        }
    }

    private void stopGeList() {
    }

    private int getCtrl() {
        if (ExternalGE.isActive()) {
            this.ctrl = NativeUtils.getCoreCtrl();
        }
        return this.ctrl;
    }

    private void setCtrl(int ctrl) {
        int oldCtrl = this.ctrl;
        this.ctrl = ctrl;
        if (ExternalGE.isActive()) {
            NativeUtils.setCoreCtrl(ctrl);
        }
        if ((oldCtrl & 1) != (ctrl & 1)) {
            if ((ctrl & 1) != 0) {
                this.startGeList();
            } else {
                this.stopGeList();
            }
        }
    }

    private int readGeCmd(int cmd) {
        int value = 0;
        if (ExternalGE.isActive()) {
            value = ExternalGE.getCmd(cmd);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("readGeCmd(%s)=0x%08X", GeCommands.getInstance().getCommandString(cmd), value));
        }
        return value;
    }

    private void writeGeCmd(int cmd, int value) {
        if (ExternalGE.isActive()) {
            ExternalGE.setCmd(cmd, value);
            if (GeCommands.pureStateCommands[cmd]) {
                ExternalGE.interpretCmd(cmd, value);
            }
        }
    }

    private int readMatrix(int matrixType, int matrixIndex) {
        float[] matrix = null;
        if (ExternalGE.isActive()) {
            matrix = ExternalGE.getMatrix(matrixType);
        }
        if (matrix == null || matrixIndex < 0 || matrixIndex >= matrix.length) {
            return 0;
        }
        int value = Float.floatToRawIntBits(matrix[matrixIndex]) >>> 8;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("readMatrix(matrixType=%d, matrixIndex=%d)=0x%X(%f)", matrixType, matrixIndex, value, Float.valueOf(matrix[matrixIndex])));
        }
        return value;
    }

    private int readGeBone(int bone) {
        return this.readMatrix(0 + bone / 12, bone % 12);
    }

    private void writeGeBone(int bone, int value) {
        if (ExternalGE.isActive()) {
            ExternalGE.setMatrix(0 + bone / 12, bone % 12, Float.intBitsToFloat(value << 8));
        }
    }

    private int readGeWorld(int world) {
        return this.readMatrix(8, world);
    }

    private void writeGeWorld(int world, int value) {
        if (ExternalGE.isActive()) {
            ExternalGE.setMatrix(8, world, Float.intBitsToFloat(value << 8));
        }
    }

    private int readGeView(int view) {
        return this.readMatrix(9, view);
    }

    private void writeGeView(int view, int value) {
        if (ExternalGE.isActive()) {
            ExternalGE.setMatrix(9, view, Float.intBitsToFloat(value << 8));
        }
    }

    private int readGeProjection(int projection) {
        return this.readMatrix(10, projection);
    }

    private void writeGeProjection(int projection, int value) {
        if (ExternalGE.isActive()) {
            ExternalGE.setMatrix(10, projection, Float.intBitsToFloat(value << 8));
        }
    }

    private int readGeTexture(int texture) {
        return this.readMatrix(11, texture);
    }

    private void writeGeTexture(int texture, int value) {
        if (ExternalGE.isActive()) {
            ExternalGE.setMatrix(11, texture, Float.intBitsToFloat(value << 8));
        }
    }

    @Override
    public int read32(int address) {
        int value;
        int localAddress = address - this.baseAddress;
        switch (localAddress) {
            case 4: {
                value = 0;
                break;
            }
            case 8: {
                value = 2048;
                break;
            }
            case 256: {
                value = this.getCtrl();
                break;
            }
            case 260: {
                value = this.getStatus();
                break;
            }
            case 264: {
                value = this.getList();
                break;
            }
            case 268: {
                value = this.getStall();
                break;
            }
            case 272: {
                value = this.getRaddr1();
                break;
            }
            case 276: {
                value = this.getRaddr2();
                break;
            }
            case 280: {
                value = this.getVaddr();
                break;
            }
            case 284: {
                value = this.getIaddr();
                break;
            }
            case 288: {
                value = this.getOaddr();
                break;
            }
            case 292: {
                value = this.getOaddr1();
                break;
            }
            case 296: {
                value = this.getOaddr2();
                break;
            }
            case 512: {
                value = this.unknown200;
                break;
            }
            case 772: {
                value = this.getCmdStatus();
                break;
            }
            case 776: {
                value = this.getInterrupt();
                break;
            }
            case 1024: {
                value = this.unknown400;
                break;
            }
            default: {
                value = localAddress >= 2048 && localAddress < 3072 ? this.readGeCmd(localAddress - 2048 >> 2) : (localAddress >= 3072 && localAddress < 3456 ? this.readGeBone(localAddress - 3072 >> 2) : (localAddress >= 3456 && localAddress < 3504 ? this.readGeWorld(localAddress - 3456 >> 2) : (localAddress >= 3504 && localAddress < 3552 ? this.readGeView(localAddress - 3504 >> 2) : (localAddress >= 3552 && localAddress < 3616 ? this.readGeProjection(localAddress - 3552 >> 2) : (localAddress >= 3616 && localAddress < 3664 ? this.readGeTexture(localAddress - 3616 >> 2) : super.read32(address))))));
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 256: {
                this.setCtrl(value);
                break;
            }
            case 260: {
                this.setStatus(value);
                break;
            }
            case 264: {
                this.setList(value);
                break;
            }
            case 268: {
                this.setStall(value);
                break;
            }
            case 272: {
                this.setRaddr1(value);
                break;
            }
            case 276: {
                this.setRaddr2(value);
                break;
            }
            case 280: {
                this.setVaddr(value);
                break;
            }
            case 284: {
                this.setIaddr(value);
                break;
            }
            case 288: {
                this.setOaddr(value);
                break;
            }
            case 292: {
                this.setOaddr1(value);
                break;
            }
            case 296: {
                this.setOaddr2(value);
                break;
            }
            case 512: {
                this.unknown200 = value;
                break;
            }
            case 772: {
                this.setCmdStatus(value);
                break;
            }
            case 776: {
                this.clearInterrupt(value);
                break;
            }
            case 780: {
                this.changeInterrupt(value);
                break;
            }
            case 784: {
                this.changeCmdStatus(value);
                break;
            }
            case 1024: {
                this.unknown400 = value;
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    @Override
    public String toString() {
        return String.format("MMIOHandlerGe ctrl=0x%X, status=0x%X, list=0x%08X, interrupt=0x%X, cmdStatus=0x%X", this.ctrl, this.status, this.list, this.interrupt, this.cmdStatus);
    }
}

