/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.modules.InterruptManager;
import jpcsp.Processor;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.memory.mmio.MMIOHandlerProxyOnCpu;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MMIOHandlerInterruptMan
extends MMIOHandlerBase {
    public static Logger log = InterruptManager.log;
    private static final int STATE_VERSION = 0;
    private static MMIOHandlerProxyOnCpu instance;
    public static final int BASE_ADDRESS = -1137704960;
    private static final int NUMBER_INTERRUPTS = 64;
    private final boolean[] interruptTriggered = new boolean[64];
    private final boolean[] interruptEnabled = new boolean[64];
    private final boolean[] interruptOccurred = new boolean[64];
    private final Processor processor;

    public static MMIOHandlerInterruptMan getInstance(Processor processor) {
        return (MMIOHandlerInterruptMan)MMIOHandlerInterruptMan.getProxyInstance().getInstance(processor);
    }

    public static MMIOHandlerProxyOnCpu getProxyInstance() {
        if (instance == null) {
            MMIOHandlerInterruptMan mainInstance = new MMIOHandlerInterruptMan(-1137704960, RuntimeContextLLE.getMainProcessor());
            MMIOHandlerInterruptMan meInstance = new MMIOHandlerInterruptMan(-1137704960, RuntimeContextLLE.getMediaEngineProcessor());
            instance = new MMIOHandlerProxyOnCpu(mainInstance, meInstance);
        }
        return instance;
    }

    private MMIOHandlerInterruptMan(int baseAddress, Processor processor) {
        super(baseAddress);
        this.processor = processor;
    }

    @Override
    protected Processor getProcessor() {
        return this.processor;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        stream.readBooleans(this.interruptTriggered);
        stream.readBooleans(this.interruptEnabled);
        stream.readBooleans(this.interruptOccurred);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeBooleans(this.interruptTriggered);
        stream.writeBooleans(this.interruptEnabled);
        stream.writeBooleans(this.interruptOccurred);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.interruptTriggered, false);
        Arrays.fill(this.interruptEnabled, false);
        Arrays.fill(this.interruptOccurred, false);
    }

    public void triggerInterrupt(int interruptNumber) {
        if (!this.hasInterruptTriggered(interruptNumber)) {
            this.interruptTriggered[interruptNumber] = true;
            this.checkException();
        }
    }

    public void clearInterrupt(int interruptNumber) {
        if (this.hasInterruptTriggered(interruptNumber)) {
            this.interruptTriggered[interruptNumber] = false;
            this.checkException();
        }
    }

    public boolean hasInterruptTriggered(int interruptNumber) {
        return this.interruptTriggered[interruptNumber];
    }

    private void checkException() {
        if (this.doTriggerException()) {
            RuntimeContextLLE.triggerInterruptException(this.getProcessor(), 4);
        } else {
            RuntimeContextLLE.clearInterruptException(this.getProcessor(), 4);
        }
    }

    public boolean doTriggerException() {
        for (int i = 0; i < 64; ++i) {
            if (!this.interruptTriggered[i] || !this.interruptEnabled[i]) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("doTriggerException on %s", this));
            }
            return true;
        }
        return false;
    }

    private void setBits(boolean[] values, int value, int offset, int mask) {
        int i = 0;
        while (mask != 0) {
            if ((mask & 1) != 0) {
                values[offset + i] = (value & 1) != 0;
            }
            ++i;
            value >>>= 1;
            mask >>>= 1;
        }
        this.checkException();
    }

    private void setBits1(boolean[] values, int value) {
        this.setBits(values, value, 0, -536870928);
    }

    private void setBits2(boolean[] values, int value) {
        this.setBits(values, value, 32, -49345);
    }

    private void setBits3(boolean[] values, int value) {
        int value3 = value & 0xC0 | value >> 2 & 0xC000;
        this.setBits(values, value3, 32, 49344);
    }

    private int getBits(boolean[] values, int offset) {
        int value = 0;
        for (int i = 31; i >= 0; --i) {
            value <<= 1;
            if (!values[offset + i]) continue;
            value |= 1;
        }
        return value;
    }

    private int getBits1(boolean[] values) {
        return this.getBits(values, 0);
    }

    private int getBits2(boolean[] values) {
        return this.getBits(values, 32) & 0xFFFF3F3F;
    }

    private int getBits3(boolean[] values) {
        int value3 = this.getBits(values, 32);
        value3 = value3 & 0xC0 | (value3 & 0xC000) << 2;
        return value3;
    }

    @Override
    public int read32(int address) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) on %s", this.getPc(), address, this));
        }
        switch (address - this.baseAddress) {
            case 0: {
                return this.getBits1(this.interruptTriggered);
            }
            case 16: {
                return this.getBits2(this.interruptTriggered);
            }
            case 32: {
                return this.getBits3(this.interruptTriggered);
            }
            case 4: {
                return this.getBits1(this.interruptOccurred);
            }
            case 20: {
                return this.getBits2(this.interruptOccurred);
            }
            case 36: {
                return this.getBits3(this.interruptOccurred);
            }
            case 8: {
                return this.getBits1(this.interruptEnabled);
            }
            case 24: {
                return this.getBits2(this.interruptEnabled);
            }
            case 40: {
                return this.getBits3(this.interruptEnabled);
            }
        }
        return super.read32(address);
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                if (Utilities.hasBit(value, 30)) {
                    this.clearInterrupt(30);
                    value = Utilities.clearBit(value, 30);
                }
                if (Utilities.hasBit(value, 31)) {
                    this.clearInterrupt(31);
                    value = Utilities.clearBit(value, 31);
                }
                if (Utilities.hasBit(value, 5)) {
                    this.clearInterrupt(5);
                    value = Utilities.clearBit(value, 5);
                }
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 8: {
                this.setBits1(this.interruptEnabled, value);
                break;
            }
            case 24: {
                this.setBits2(this.interruptEnabled, value);
                break;
            }
            case 40: {
                this.setBits3(this.interruptEnabled, value);
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    private void toString(StringBuilder sb, String name, boolean[] values) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(name);
        sb.append("[");
        boolean first = true;
        for (int i = 0; i < values.length; ++i) {
            if (!values[i]) continue;
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            sb.append(IntrManager.getInterruptName(i));
        }
        sb.append("]");
    }

    public String toStringInterruptTriggered() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, "", this.interruptTriggered);
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, "interruptTriggered", this.interruptTriggered);
        this.toString(sb, "interruptOccurred", this.interruptOccurred);
        this.toString(sb, "interruptEnabled", this.interruptEnabled);
        return sb.toString();
    }
}

