/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.memory.mmio.MMIOHandlerMeCore;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MMIOHandlerMeController
extends MMIOHandlerBase {
    public static Logger log = MMIOHandlerMeCore.log;
    private static final int STATE_VERSION = 0;

    public MMIOHandlerMeController(int baseAddress) {
        super(baseAddress);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        super.write(stream);
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 16: {
                value = 0;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 16: {
                if (value == 1) break;
                super.write32(address, value);
                break;
            }
            case 48: {
                if (value == 8) break;
                super.write32(address, value);
                break;
            }
            case 64: {
                if (value == 2) break;
                super.write32(address, value);
                break;
            }
            case 112: {
                if (value == 1) break;
                super.write32(address, value);
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }
}

