/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Processor;
import jpcsp.memory.mmio.IMMIOHandler;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public class MMIOHandlerProxyOnCpu
implements IMMIOHandler {
    private IMMIOHandler proxyOnMain;
    private IMMIOHandler proxyOnMe;

    public MMIOHandlerProxyOnCpu(IMMIOHandler proxyOnMain, IMMIOHandler proxyOnMe) {
        this.proxyOnMain = proxyOnMain;
        this.proxyOnMe = proxyOnMe;
    }

    public IMMIOHandler getInstance() {
        if (RuntimeContextLLE.isMediaEngineCpu()) {
            return this.proxyOnMe;
        }
        return this.proxyOnMain;
    }

    public IMMIOHandler getInstance(Processor processor) {
        if (processor.cp0.isMediaEngineCpu()) {
            return this.proxyOnMe;
        }
        return this.proxyOnMain;
    }

    @Override
    public int read8(int address) {
        return this.getInstance().read8(address);
    }

    @Override
    public int read16(int address) {
        return this.getInstance().read16(address);
    }

    @Override
    public int read32(int address) {
        return this.getInstance().read32(address);
    }

    @Override
    public void write8(int address, byte value) {
        this.getInstance().write8(address, value);
    }

    @Override
    public void write16(int address, short value) {
        this.getInstance().write16(address, value);
    }

    @Override
    public void write32(int address, int value) {
        this.getInstance().write32(address, value);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        this.proxyOnMain.read(stream);
        this.proxyOnMe.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        this.proxyOnMain.write(stream);
        this.proxyOnMe.write(stream);
    }

    @Override
    public void reset() {
        this.proxyOnMain.reset();
        this.proxyOnMe.reset();
    }
}

