/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.Allegrex.compiler.ResetException;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.hardware.MemoryStick;
import jpcsp.hardware.Usb;
import jpcsp.mediaengine.MEProcessor;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.memory.mmio.MMIOHandlerMeCore;
import jpcsp.memory.mmio.MMIOHandlerUsb;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MMIOHandlerSystemControl
extends MMIOHandlerBase {
    public static Logger log = Logger.getLogger((String)"systemcontrol");
    private static final int STATE_VERSION = 0;
    public static final int BASE_ADDRESS = -1139802112;
    public static final int SYSREG_RESET_TOP = 0;
    public static final int SYSREG_RESET_SC = 1;
    public static final int SYSREG_RESET_ME = 2;
    public static final int SYSREG_RESET_AW = 3;
    public static final int SYSREG_RESET_VME = 4;
    public static final int SYSREG_RESET_AVC = 5;
    public static final int SYSREG_RESET_USB = 6;
    public static final int SYSREG_RESET_ATA = 7;
    public static final int SYSREG_RESET_MSIF0 = 8;
    public static final int SYSREG_RESET_MSIF1 = 9;
    public static final int SYSREG_RESET_KIRK = 10;
    public static final int SYSREG_RESET_ATA_HDD = 12;
    public static final int SYSREG_RESET_USB_HOST = 13;
    public static final int SYSREG_RESET_UNKNOWN0 = 14;
    public static final int SYSREG_RESET_UNKNOWN1 = 15;
    public static final int SYSREG_BUSCLK_ME = 0;
    public static final int SYSREG_BUSCLK_AWA = 1;
    public static final int SYSREG_BUSCLK_AWB = 2;
    public static final int SYSREG_BUSCLK_EDRAM = 3;
    public static final int SYSREG_BUSCLK_DMACPLUS = 4;
    public static final int SYSREG_BUSCLK_DMAC0 = 5;
    public static final int SYSREG_BUSCLK_DMAC1 = 6;
    public static final int SYSREG_BUSCLK_KIRK = 7;
    public static final int SYSREG_BUSCLK_ATA = 8;
    public static final int SYSREG_BUSCLK_USB = 9;
    public static final int SYSREG_BUSCLK_MSIF0 = 10;
    public static final int SYSREG_BUSCLK_MSIF1 = 11;
    public static final int SYSREG_BUSCLK_EMCDDR = 12;
    public static final int SYSREG_BUSCLK_EMCSM = 13;
    public static final int SYSREG_BUSCLK_APB = 14;
    public static final int SYSREG_BUSCLK_AUDIO0 = 15;
    public static final int SYSREG_BUSCLK_AUDIO1 = 16;
    public static final int SYSREG_CLK1_ATA = 0;
    public static final int SYSREG_CLK1_USB = 4;
    public static final int SYSREG_CLK1_MSIF0 = 8;
    public static final int SYSREG_CLK1_MSIF1 = 9;
    public static final int SYSREG_CLK_SPI0 = 0;
    public static final int SYSREG_CLK_SPI1 = 1;
    public static final int SYSREG_CLK_SPI2 = 2;
    public static final int SYSREG_CLK_SPI3 = 3;
    public static final int SYSREG_CLK_SPI4 = 4;
    public static final int SYSREG_CLK_SPI5 = 5;
    public static final int SYSREG_CLK_UART0 = 6;
    public static final int SYSREG_CLK_UART1 = 7;
    public static final int SYSREG_CLK_UART2 = 8;
    public static final int SYSREG_CLK_UART3 = 9;
    public static final int SYSREG_CLK_UART4 = 10;
    public static final int SYSREG_CLK_UART5 = 11;
    public static final int SYSREG_CLK_APB_TIMER0 = 12;
    public static final int SYSREG_CLK_APB_TIMER1 = 13;
    public static final int SYSREG_CLK_APB_TIMER2 = 14;
    public static final int SYSREG_CLK_APB_TIMER3 = 15;
    public static final int SYSREG_CLK_AUDIO0 = 16;
    public static final int SYSREG_CLK_AUDIO1 = 17;
    public static final int SYSREG_CLK_UNKNOWN0 = 18;
    public static final int SYSREG_CLK_UNKNOWN1 = 19;
    public static final int SYSREG_CLK_UNKNOWN2 = 20;
    public static final int SYSREG_CLK_UNKNOWN3 = 21;
    public static final int SYSREG_CLK_SIRCS = 22;
    public static final int SYSREG_CLK_GPIO = 23;
    public static final int SYSREG_CLK_AUDIO_CLKOUT = 24;
    public static final int SYSREG_CLK_UNKNOWN4 = 25;
    public static final int SYSREG_IO_EMCSM = 1;
    public static final int SYSREG_IO_USB = 2;
    public static final int SYSREG_IO_ATA = 3;
    public static final int SYSREG_IO_MSIF0 = 4;
    public static final int SYSREG_IO_MSIF1 = 5;
    public static final int SYSREG_IO_LCDC = 6;
    public static final int SYSREG_IO_AUDIO0 = 7;
    public static final int SYSREG_IO_AUDIO1 = 8;
    public static final int SYSREG_IO_IIC = 9;
    public static final int SYSREG_IO_SIRCS = 10;
    public static final int SYSREG_IO_UNK = 11;
    public static final int SYSREG_IO_KEY = 12;
    public static final int SYSREG_IO_PWM = 13;
    public static final int SYSREG_IO_UART0 = 16;
    public static final int SYSREG_IO_UART1 = 17;
    public static final int SYSREG_IO_UART2 = 18;
    public static final int SYSREG_IO_UART3 = 19;
    public static final int SYSREG_IO_UART4 = 20;
    public static final int SYSREG_IO_UART5 = 21;
    public static final int SYSREG_IO_SPI0 = 24;
    public static final int SYSREG_IO_SPI1 = 25;
    public static final int SYSREG_IO_SPI2 = 26;
    public static final int SYSREG_IO_SPI3 = 27;
    public static final int SYSREG_IO_SPI4 = 28;
    public static final int SYSREG_IO_SPI5 = 29;
    public static final int SYSREG_AVC_POWER = 2;
    public static final int SYSREG_SELECTED_APB_TIMER0 = 7;
    public static final int SYSREG_SELECTED_APB_TIMER1 = 112;
    public static final int SYSREG_SELECTED_APB_TIMER2 = 1792;
    public static final int SYSREG_SELECTED_APB_TIMER3 = 28672;
    public static final int SYSREG_SELECTED_AUDIO_CLOCK0 = 65536;
    public static final int SYSREG_SELECTED_AUDIO_CLOCK1 = 131072;
    public static final int SYSREG_USBMS_USB_CONNECTED = 1;
    public static final int SYSREG_USBMS_USB_INTERRUPT_CABLE_CONNECTED = 1;
    public static final int SYSREG_USBMS_USB_INTERRUPT_CABLE_DISCONNECTED = 2;
    public static final int SYSREG_USBMS_USB_INTERRUPT3 = 3;
    public static final int SYSREG_USBMS_USB_INTERRUPT4 = 4;
    public static final int SYSREG_USBMS_USB_INTERRUPT_MASK = 30;
    public static final int SYSREG_USBMS_MS0_CONNECTED = 256;
    public static final int SYSREG_USBMS_MS0_INTERRUPT_MASK = 7680;
    public static final int SYSREG_USBMS_MS1_CONNECTED = 65536;
    public static final int SYSREG_USBMS_MS1_INTERRUPT_MASK = 0x1E0000;
    public static final int RAM_SIZE_16MB = 0;
    public static final int RAM_SIZE_32MB = 1;
    public static final int RAM_SIZE_64MB = 2;
    public static final int RAM_SIZE_128MB = 3;
    private static MMIOHandlerSystemControl instance;
    private int resetDevices;
    private int busClockDevices;
    private int clock1Devices;
    private int clockDevices;
    private int ioDevices;
    private int ramSize;
    private int tachyonVersion;
    private int usbAndMemoryStick;
    private int avcPower;
    private int interrupts;
    private int pllFrequency;
    private int spiClkSelect;
    private int gpioEnable;
    private int ataClkSelect;
    private int unknown00;
    private int unknown3C;
    private int selectedClkTimer;
    private int unknown6C;
    private int unknown74;
    private int unknownB8;
    private int unknownC4;
    private int unknownE8;
    private int unknownF0;
    private int unknown100;

    public static MMIOHandlerSystemControl getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerSystemControl(-1139802112);
        }
        return instance;
    }

    private MMIOHandlerSystemControl(int baseAddress) {
        super(baseAddress);
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.resetDevices = stream.readInt();
        this.busClockDevices = stream.readInt();
        this.clock1Devices = stream.readInt();
        this.clockDevices = stream.readInt();
        this.ioDevices = stream.readInt();
        this.ramSize = stream.readInt();
        this.tachyonVersion = stream.readInt();
        this.usbAndMemoryStick = stream.readInt();
        this.avcPower = stream.readInt();
        this.interrupts = stream.readInt();
        this.pllFrequency = stream.readInt();
        this.spiClkSelect = stream.readInt();
        this.gpioEnable = stream.readInt();
        this.ataClkSelect = stream.readInt();
        this.unknown00 = stream.readInt();
        this.unknown3C = stream.readInt();
        this.selectedClkTimer = stream.readInt();
        this.unknown6C = stream.readInt();
        this.unknown74 = stream.readInt();
        this.unknownB8 = stream.readInt();
        this.unknownC4 = stream.readInt();
        this.unknownE8 = stream.readInt();
        this.unknownF0 = stream.readInt();
        this.unknown100 = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.resetDevices);
        stream.writeInt(this.busClockDevices);
        stream.writeInt(this.clock1Devices);
        stream.writeInt(this.clockDevices);
        stream.writeInt(this.ioDevices);
        stream.writeInt(this.ramSize);
        stream.writeInt(this.tachyonVersion);
        stream.writeInt(this.usbAndMemoryStick);
        stream.writeInt(this.avcPower);
        stream.writeInt(this.interrupts);
        stream.writeInt(this.pllFrequency);
        stream.writeInt(this.spiClkSelect);
        stream.writeInt(this.gpioEnable);
        stream.writeInt(this.ataClkSelect);
        stream.writeInt(this.unknown00);
        stream.writeInt(this.unknown3C);
        stream.writeInt(this.selectedClkTimer);
        stream.writeInt(this.unknown6C);
        stream.writeInt(this.unknown74);
        stream.writeInt(this.unknownB8);
        stream.writeInt(this.unknownC4);
        stream.writeInt(this.unknownE8);
        stream.writeInt(this.unknownF0);
        stream.writeInt(this.unknown100);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.resetDevices = 0;
        this.busClockDevices = 0;
        this.clock1Devices = 0;
        this.clockDevices = 0;
        this.ioDevices = 0;
        this.usbAndMemoryStick = 0;
        this.avcPower = 0;
        this.interrupts = 0;
        this.pllFrequency = 0;
        this.spiClkSelect = 0;
        this.gpioEnable = 0;
        this.ataClkSelect = 0;
        this.unknown00 = 0;
        this.unknown3C = 0;
        this.selectedClkTimer = 0;
        this.unknown6C = 0;
        this.unknown74 = 0;
        this.unknownB8 = 0;
        this.unknownC4 = 0;
        this.unknownE8 = 0;
        this.unknownF0 = 0;
        this.unknown100 = 0;
        this.ramSize = 0;
        this.tachyonVersion = Modules.sceSysregModule.sceSysregGetTachyonVersion();
        if (MemoryStick.isInserted()) {
            this.usbAndMemoryStick = Utilities.setFlag(this.usbAndMemoryStick, 256);
        }
        if (Usb.isCableConnected()) {
            this.usbAndMemoryStick = Utilities.setFlag(this.usbAndMemoryStick, 1);
            this.resetDevices = Utilities.setBit(this.resetDevices, 6);
            this.triggerUsbMemoryStickInterrupt(1);
        }
    }

    private static String getResetDeviceName(int bit) {
        switch (bit) {
            case 0: {
                return "TOP";
            }
            case 1: {
                return "SC";
            }
            case 2: {
                return "ME";
            }
            case 3: {
                return "AW";
            }
            case 4: {
                return "VME";
            }
            case 5: {
                return "AVC";
            }
            case 6: {
                return "USB";
            }
            case 7: {
                return "ATA";
            }
            case 8: {
                return "MSIF0";
            }
            case 9: {
                return "MSIF1";
            }
            case 10: {
                return "KIRK";
            }
            case 12: {
                return "ATA_HDD";
            }
            case 13: {
                return "USB_HOST";
            }
            case 14: {
                return "UNKNOWN0";
            }
            case 15: {
                return "UNKNOWN1";
            }
        }
        return String.format("SYSREG_RESET_%02X", bit);
    }

    private static String getBusClockDeviceName(int bit) {
        switch (bit) {
            case 0: {
                return "ME";
            }
            case 1: {
                return "AWA";
            }
            case 2: {
                return "AWB";
            }
            case 3: {
                return "EDRAM";
            }
            case 4: {
                return "DMACPLUS";
            }
            case 5: {
                return "DMAC0";
            }
            case 6: {
                return "DMAC1";
            }
            case 7: {
                return "KIRK";
            }
            case 8: {
                return "ATA";
            }
            case 9: {
                return "USB";
            }
            case 10: {
                return "MSIF0";
            }
            case 11: {
                return "MSIF1";
            }
            case 12: {
                return "EMCDDR";
            }
            case 13: {
                return "EMCSM";
            }
            case 14: {
                return "APB";
            }
            case 15: {
                return "AUDIO0";
            }
            case 16: {
                return "AUDIO1";
            }
        }
        return String.format("SYSREG_BUSCLK_%02X", bit);
    }

    private static String getClock1DeviceName(int bit) {
        switch (bit) {
            case 0: {
                return "ATA";
            }
            case 4: {
                return "USB";
            }
            case 8: {
                return "MSIF0";
            }
            case 9: {
                return "MSIF1";
            }
        }
        return String.format("SYSREG_CLK1_%02X", bit);
    }

    private static String getClockDeviceName(int bit) {
        switch (bit) {
            case 0: {
                return "SPI0";
            }
            case 1: {
                return "SPI1";
            }
            case 2: {
                return "SPI2";
            }
            case 3: {
                return "SPI3";
            }
            case 4: {
                return "SPI4";
            }
            case 5: {
                return "SPI5";
            }
            case 6: {
                return "UART0";
            }
            case 7: {
                return "UART1";
            }
            case 8: {
                return "UART2";
            }
            case 9: {
                return "UART3";
            }
            case 10: {
                return "UART4";
            }
            case 11: {
                return "UART5";
            }
            case 12: {
                return "APB_TIMIER0";
            }
            case 13: {
                return "APB_TIMIER1";
            }
            case 14: {
                return "APB_TIMIER2";
            }
            case 15: {
                return "APB_TIMIER2";
            }
            case 16: {
                return "AUDIO0";
            }
            case 17: {
                return "AUDIO1";
            }
            case 18: {
                return "UNKNOWN0";
            }
            case 19: {
                return "UNKNOWN1";
            }
            case 20: {
                return "UNKNOWN2";
            }
            case 21: {
                return "UNKNOWN3";
            }
            case 22: {
                return "SIRCS";
            }
            case 23: {
                return "GPIO";
            }
            case 24: {
                return "AUDIO_CLKOUT";
            }
            case 25: {
                return "UNKNOWN4";
            }
        }
        return String.format("SYSREG_CLK_%02X", bit);
    }

    private static String getIoDeviceName(int bit) {
        switch (bit) {
            case 1: {
                return "EMCSM";
            }
            case 2: {
                return "USB";
            }
            case 3: {
                return "ATA";
            }
            case 4: {
                return "MSIF0";
            }
            case 5: {
                return "MSIF1";
            }
            case 6: {
                return "LCDC";
            }
            case 7: {
                return "AUDIO0";
            }
            case 8: {
                return "AUDIO1";
            }
            case 9: {
                return "IIC";
            }
            case 10: {
                return "SIRCS";
            }
            case 11: {
                return "UNK";
            }
            case 12: {
                return "KEY";
            }
            case 13: {
                return "PWM";
            }
            case 16: {
                return "UART0";
            }
            case 17: {
                return "UART1";
            }
            case 18: {
                return "UART2";
            }
            case 19: {
                return "UART3";
            }
            case 20: {
                return "UART4";
            }
            case 21: {
                return "UART5";
            }
            case 24: {
                return "SPI0";
            }
            case 25: {
                return "SPI1";
            }
            case 26: {
                return "SPI2";
            }
            case 27: {
                return "SPI3";
            }
            case 28: {
                return "SPI4";
            }
            case 29: {
                return "SPI5";
            }
        }
        return String.format("SYSREG_IO_%02X", bit);
    }

    private void sysregInterruptToOther(int value) {
        if (value != 0) {
            if (RuntimeContextLLE.isMainCpu()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sysregInterruptToOther to ME on %s", MMIOHandlerMeCore.getInstance().toString()));
                }
                MMIOHandlerMeCore.getInstance().hleStartMeCommand();
                RuntimeContextLLE.triggerInterrupt(RuntimeContextLLE.getMediaEngineProcessor(), 31);
                RuntimeContextLLE.getMediaEngineProcessor().triggerException(4);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sysregInterruptToOther from ME on %s", MMIOHandlerMeCore.getInstance().toString()));
                }
                MMIOHandlerMeCore.getInstance().hleCompleteMeCommand();
                RuntimeContextLLE.triggerInterrupt(RuntimeContextLLE.getMainProcessor(), 31);
            }
        }
    }

    private void setResetDevices(int value) {
        int oldResetDevices = this.resetDevices;
        this.resetDevices = value;
        if (Utilities.isRaisingBit(oldResetDevices, this.resetDevices, 1)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Reset main processor (SYSREG_RESET_SC)", new Object[0]));
            }
            RuntimeContextLLE.getMMIO().remapMemoryAtProcessorReset();
            Emulator.getProcessor().triggerReset();
            throw new ResetException();
        }
        if (Utilities.isFallingBit(oldResetDevices, this.resetDevices, 2)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Reset ME processor (SYSREG_RESET_ME)", new Object[0]));
            }
            MEProcessor.getInstance().triggerReset();
        }
        if (Utilities.isFallingBit(oldResetDevices, this.resetDevices, 6)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Reset USB (SYSREG_RESET_USB)", new Object[0]));
            }
            MMIOHandlerUsb.getInstance().triggerReset();
        }
    }

    private void setBusClockDevices(int value) {
        this.busClockDevices = value;
    }

    private void setClock1Devices(int value) {
        this.clock1Devices = value;
    }

    private void setClockDevices(int value) {
        this.clockDevices = value;
    }

    private void setIoDevices(int value) {
        this.ioDevices = value;
    }

    private void setRamSize(int value) {
        this.ramSize = value & 3;
    }

    public void triggerUsbMemoryStickInterrupt(int bit) {
        if (!Utilities.hasBit(this.usbAndMemoryStick, bit)) {
            this.usbAndMemoryStick = Utilities.setBit(this.usbAndMemoryStick, bit);
            switch (bit) {
                case 1: {
                    RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 58);
                    break;
                }
                case 2: {
                    RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 59);
                    break;
                }
                case 3: {
                    RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 57);
                    break;
                }
                case 4: {
                    RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 56);
                }
            }
        }
    }

    private void clearUsbMemoryStick(int mask) {
        int oldUsbAndMemoryStick = this.usbAndMemoryStick;
        this.usbAndMemoryStick &= ~(mask &= 0x1E1E1E);
        if (Utilities.isFallingBit(oldUsbAndMemoryStick, this.usbAndMemoryStick, 1)) {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), 58);
        }
        if (Utilities.isFallingBit(oldUsbAndMemoryStick, this.usbAndMemoryStick, 2)) {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), 59);
        }
        if (Utilities.isFallingBit(oldUsbAndMemoryStick, this.usbAndMemoryStick, 3)) {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), 57);
        }
        if (Utilities.isFallingBit(oldUsbAndMemoryStick, this.usbAndMemoryStick, 4)) {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), 56);
        }
    }

    private void setAvcPower(int value) {
        this.avcPower = value;
        if (Utilities.hasBit(this.avcPower, 2)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("MMIOHandlerSystemControl.setAvcPower enabling Avc power", new Object[0]));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MMIOHandlerSystemControl.setAvcPower disabling Avc power", new Object[0]));
        }
        if ((value & 0xFFFFFFFB) != 0) {
            log.error((Object)String.format("MMIOHandlerSystemControl.setAvcPower unknown value 0x%X", value));
        }
    }

    private void clearInterrupts(int mask) {
        this.interrupts &= ~mask;
    }

    private void setPllFrequency(int value) {
        if ((value & 0x80) != 0) {
            this.pllFrequency = value & 0xF;
        }
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = this.unknown00;
                break;
            }
            case 60: {
                value = this.unknown3C;
                break;
            }
            case 64: {
                value = this.tachyonVersion << 8 | this.ramSize;
                break;
            }
            case 76: {
                value = this.resetDevices;
                break;
            }
            case 80: {
                value = this.busClockDevices;
                break;
            }
            case 84: {
                value = this.clock1Devices;
                break;
            }
            case 88: {
                value = this.clockDevices;
                break;
            }
            case 92: {
                value = this.ataClkSelect;
                break;
            }
            case 96: {
                value = this.selectedClkTimer;
                break;
            }
            case 100: {
                value = this.spiClkSelect;
                break;
            }
            case 104: {
                value = this.pllFrequency;
                break;
            }
            case 108: {
                value = this.unknown6C;
                break;
            }
            case 112: {
                value = this.avcPower;
                break;
            }
            case 116: {
                value = this.unknown74;
                break;
            }
            case 120: {
                value = this.ioDevices;
                break;
            }
            case 124: {
                value = this.gpioEnable;
                break;
            }
            case 128: {
                value = this.usbAndMemoryStick;
                break;
            }
            case 144: {
                value = (int)Modules.sceSysregModule.sceSysregGetFuseId();
                break;
            }
            case 148: {
                value = (int)(Modules.sceSysregModule.sceSysregGetFuseId() >> 32);
                break;
            }
            case 152: {
                value = Modules.sceSysregModule.sceSysregGetFuseConfig();
                break;
            }
            case 184: {
                value = this.unknownB8;
                break;
            }
            case 196: {
                value = this.unknownC4;
                break;
            }
            case 232: {
                value = this.unknownE8;
                break;
            }
            case 240: {
                value = this.unknownF0;
                break;
            }
            case 256: {
                value = this.unknown100;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                this.unknown00 = value;
                break;
            }
            case 4: {
                this.clearInterrupts(value);
                break;
            }
            case 60: {
                this.unknown3C = value;
                break;
            }
            case 64: {
                this.setRamSize(value);
                break;
            }
            case 68: {
                this.sysregInterruptToOther(value);
                break;
            }
            case 76: {
                this.setResetDevices(value);
                break;
            }
            case 80: {
                this.setBusClockDevices(value);
                break;
            }
            case 92: {
                this.ataClkSelect = value;
                break;
            }
            case 84: {
                this.setClock1Devices(value);
                break;
            }
            case 88: {
                this.setClockDevices(value);
                break;
            }
            case 96: {
                this.selectedClkTimer = value;
                break;
            }
            case 100: {
                this.spiClkSelect = value;
                break;
            }
            case 104: {
                this.setPllFrequency(value);
                break;
            }
            case 108: {
                this.unknown6C = value;
                break;
            }
            case 112: {
                this.setAvcPower(value);
                break;
            }
            case 116: {
                this.unknown74 = value;
                break;
            }
            case 120: {
                this.setIoDevices(value);
                break;
            }
            case 124: {
                this.gpioEnable = value;
                break;
            }
            case 128: {
                this.clearUsbMemoryStick(value);
                break;
            }
            case 184: {
                this.unknownB8 = value;
                break;
            }
            case 196: {
                this.unknownC4 = value;
                break;
            }
            case 232: {
                this.unknownE8 = value;
                break;
            }
            case 240: {
                this.unknownF0 = value;
                break;
            }
            case 256: {
                this.unknown100 = value;
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    private void toString(StringBuilder sb, int bits, int type, String prefix) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(prefix);
        sb.append("[");
        boolean first = true;
        block7: for (int bit = 0; bit < 32; ++bit) {
            if (!Utilities.hasBit(bits, bit)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            switch (type) {
                case 0: {
                    sb.append(MMIOHandlerSystemControl.getResetDeviceName(bit));
                    continue block7;
                }
                case 1: {
                    sb.append(MMIOHandlerSystemControl.getBusClockDeviceName(bit));
                    continue block7;
                }
                case 2: {
                    sb.append(MMIOHandlerSystemControl.getClock1DeviceName(bit));
                    continue block7;
                }
                case 3: {
                    sb.append(MMIOHandlerSystemControl.getClockDeviceName(bit));
                    continue block7;
                }
                case 4: {
                    sb.append(MMIOHandlerSystemControl.getIoDeviceName(bit));
                }
            }
        }
        sb.append("]");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, this.resetDevices, 0, "resetDevices");
        this.toString(sb, this.busClockDevices, 1, "busClockDevices");
        this.toString(sb, this.clock1Devices, 2, "clock1Devices");
        this.toString(sb, this.clockDevices, 3, "clockDevices");
        this.toString(sb, this.ioDevices, 4, "ioDevices");
        sb.append(String.format(", USB[connected=%b, interrupt=0x%01X]", (this.usbAndMemoryStick & 1) != 0, (this.usbAndMemoryStick & 0x1E) >> 1));
        sb.append(String.format(", MemoryStick0[connected=%b, interrupt=0x%01X]", (this.usbAndMemoryStick & 0x100) != 0, (this.usbAndMemoryStick & 0x1E) >> 9));
        sb.append(String.format(", MemoryStick1[connected=%b, interrupt=0x%01X]", (this.usbAndMemoryStick & 0x10000) != 0, (this.usbAndMemoryStick & 0x1E) >> 17));
        sb.append(String.format(", interrupts=0x%X", this.interrupts));
        sb.append(String.format(", pllFrequency=0x%X", this.pllFrequency));
        return sb.toString();
    }
}

