/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.modules.sceSystimer;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.scheduler.Scheduler;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MMIOHandlerTimer
extends MMIOHandlerBase {
    private static Logger log = sceSystimer.log;
    private static final int STATE_VERSION = 0;
    private static final int TIMER_FREQUENCY_NUMERATOR = 48;
    private static final int TIMER_FREQUENCY_DENOMINATOR = 1;
    private static final int STATUS_COUNTER_VALUE = 0x3FFFFF;
    private static final int STATUS_TRIGGER_INTERRUPT = 0x400000;
    private static final int STATUS_COUNTER_ACTIVE = 0x800000;
    private static final int STATUS_VALUE_MASK = 0xFFFFFF;
    private static final int STATUS_RESET_OVERFLOW = Integer.MIN_VALUE;
    private static final int STATUS_COUNTER_OVERFLOW = -16777216;
    private static final int COUNTER_VALUE_MASK = 0xFFFFFF;
    private final TriggerTimerInterruptAction triggerTimerInterruptAction = new TriggerTimerInterruptAction();
    private final int interruptNumber;
    private int status;
    private int counter;
    private int prsclNumerator;
    private int prsclDenominator;
    private long schedule;
    private long start;
    private int overflowRead;

    public MMIOHandlerTimer(int baseAddress, int interruptNumber) {
        super(baseAddress);
        this.interruptNumber = interruptNumber;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.status = stream.readInt();
        this.counter = stream.readInt();
        this.prsclNumerator = stream.readInt();
        this.prsclDenominator = stream.readInt();
        this.schedule = stream.readLong();
        this.start = stream.readLong();
        this.overflowRead = stream.readInt();
        if (this.schedule != 0L) {
            this.updateInterruptSchedule();
        }
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.status);
        stream.writeInt(this.counter);
        stream.writeInt(this.prsclNumerator);
        stream.writeInt(this.prsclDenominator);
        stream.writeLong(this.schedule);
        stream.writeLong(this.start);
        stream.writeInt(this.overflowRead);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.status = 0;
        this.counter = 0;
        this.prsclNumerator = 0;
        this.prsclDenominator = 0;
        this.schedule = 0L;
        this.start = 0L;
        this.overflowRead = 0;
    }

    private void triggerTimerInterrupt() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Triggering %s interrupt for %s", IntrManager.getInterruptName(this.interruptNumber), this));
        }
        RuntimeContextLLE.triggerInterrupt(this.getProcessor(), this.interruptNumber);
    }

    private int getStatus() {
        int currentOverflow;
        this.overflowRead = currentOverflow = this.updateCounter();
        if (Utilities.hasFlag(this.status, 0x800000) && Utilities.hasFlag(this.status, 0x400000)) {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), this.interruptNumber);
            this.updateInterruptSchedule();
        }
        this.status = this.status & 0xFFFFFF | this.counter & 0xFF000000;
        return this.status;
    }

    private int getStatusReadOnly() {
        this.updateCounter();
        return this.status & 0xFFFFFF | this.counter & 0xFF000000;
    }

    private void updateInterruptSchedule() {
        this.updateInterruptSchedule(this.status);
    }

    private void updateInterruptSchedule(int value) {
        Scheduler scheduler = Emulator.getScheduler();
        long scheduleFromNow = (long)(value & 0x3FFFFF) * (long)(1 * this.prsclDenominator) / (long)(48 * this.prsclNumerator);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("setTimerData will trigger interrupt in %d microseconds", scheduleFromNow));
        }
        this.schedule = Scheduler.getNow() + scheduleFromNow;
        scheduler.addAction(this.schedule, this.triggerTimerInterruptAction);
    }

    private void setStatus(int value) {
        Scheduler scheduler = Emulator.getScheduler();
        if (Utilities.isRaisingFlag(this.status, value, 0x800000)) {
            this.start = Scheduler.getNow();
            if (Utilities.hasFlag(value, Integer.MIN_VALUE)) {
                this.overflowRead = this.updateCounter();
            }
        } else if (Utilities.isFallingFlag(this.status, value, 0x800000) && this.schedule != 0L) {
            scheduler.removeAction(this.schedule, this.triggerTimerInterruptAction);
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), this.interruptNumber);
        }
        if (Utilities.hasFlag(value, 0x400000) && Utilities.hasFlag(value, 0x800000) && this.schedule == 0L) {
            this.updateInterruptSchedule(value);
        } else if (Utilities.notHasFlag(value, 0x400000) && this.schedule != 0L) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("setTimerData removing the scheduled action for the interrupt", new Object[0]));
            }
            scheduler.removeAction(this.schedule, this.triggerTimerInterruptAction);
            this.schedule = 0L;
        }
        this.status = value & 0xFFFFFF;
    }

    private int updateCounter() {
        int overflow = 0;
        this.counter = 0;
        if ((this.status & 0x800000) != 0) {
            long duration = Scheduler.getNow() - this.start;
            long steps = duration * (long)(48 * this.prsclNumerator) / (long)(1 * this.prsclDenominator);
            int maxCounter = this.status & 0x3FFFFF;
            if (maxCounter != 0) {
                overflow = (int)(steps / (long)maxCounter);
                int currentOverflow = overflow - this.overflowRead;
                this.counter = maxCounter - (int)(steps % (long)maxCounter);
                this.counter &= 0xFFFFFF;
                this.counter |= Math.min(currentOverflow, 255) << 24;
            }
        }
        return overflow;
    }

    private int getCounter() {
        this.updateCounter();
        return this.counter;
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = this.getStatus();
                break;
            }
            case 4: {
                value = this.getCounter();
                break;
            }
            case 8: {
                value = this.prsclNumerator;
                break;
            }
            case 12: {
                value = this.prsclDenominator;
                break;
            }
            case 256: {
                value = this.getStatusReadOnly();
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                this.setStatus(value);
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                this.prsclNumerator = value;
                break;
            }
            case 12: {
                this.prsclDenominator = value;
                break;
            }
            case 256: {
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    @Override
    public String toString() {
        return String.format("Timer 0x%08X(%s): status=0x%08X, counter=0x%08X, prsclNumerator=0x%X, prsckDenominator=0x%X", this.baseAddress, IntrManager.getInterruptName(this.interruptNumber), this.getStatusReadOnly(), this.counter, this.prsclNumerator, this.prsclDenominator);
    }

    private class TriggerTimerInterruptAction
    implements IAction {
        private TriggerTimerInterruptAction() {
        }

        @Override
        public void execute() {
            MMIOHandlerTimer.this.triggerTimerInterrupt();
        }
    }
}

