/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.modules.sceUsb;
import jpcsp.Memory;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.memory.mmio.MMIOHandlerSystemControl;
import jpcsp.scheduler.Scheduler;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MMIOHandlerUsb
extends MMIOHandlerBase {
    public static Logger log = sceUsb.log;
    private static final int STATE_VERSION = 0;
    public static final int BASE_ADDRESS = -1115684864;
    private static MMIOHandlerUsb instance;
    private final Endpoint[] sendingEndpoints = new Endpoint[5];
    private final Endpoint[] receivingEndpoints;
    private int unknown400;
    private int unknown404;
    private int unknown408;
    private int connectionInterrupt;
    private int connectionInterruptEnabled;
    private int unknown414;
    private int endpointsInterfacesDisabled;
    private int unknown41C;
    private int unknown504;
    private int unknown508;
    private int unknown50C;
    private int unknown510;
    private int unknown514;

    public static MMIOHandlerUsb getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerUsb(-1115684864);
        }
        return instance;
    }

    private MMIOHandlerUsb(int baseAddress) {
        super(baseAddress);
        int i;
        for (i = 0; i < this.sendingEndpoints.length; ++i) {
            this.sendingEndpoints[i] = new Endpoint(this.getMemory());
        }
        this.receivingEndpoints = new Endpoint[4];
        for (i = 0; i < this.receivingEndpoints.length; ++i) {
            this.receivingEndpoints[i] = new Endpoint(this.getMemory());
        }
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        int i;
        stream.readVersion(0);
        for (i = 0; i < this.sendingEndpoints.length; ++i) {
            this.sendingEndpoints[i].read(stream);
        }
        for (i = 0; i < this.receivingEndpoints.length; ++i) {
            this.receivingEndpoints[i].read(stream);
        }
        this.unknown400 = stream.readInt();
        this.unknown404 = stream.readInt();
        this.unknown408 = stream.readInt();
        this.connectionInterrupt = stream.readInt();
        this.connectionInterruptEnabled = stream.readInt();
        this.unknown414 = stream.readInt();
        this.endpointsInterfacesDisabled = stream.readInt();
        this.unknown41C = stream.readInt();
        this.unknown504 = stream.readInt();
        this.unknown508 = stream.readInt();
        this.unknown50C = stream.readInt();
        this.unknown510 = stream.readInt();
        this.unknown514 = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        int i;
        stream.writeVersion(0);
        for (i = 0; i < this.sendingEndpoints.length; ++i) {
            this.sendingEndpoints[i].write(stream);
        }
        for (i = 0; i < this.receivingEndpoints.length; ++i) {
            this.receivingEndpoints[i].write(stream);
        }
        stream.writeInt(this.unknown400);
        stream.writeInt(this.unknown404);
        stream.writeInt(this.unknown408);
        stream.writeInt(this.connectionInterrupt);
        stream.writeInt(this.connectionInterruptEnabled);
        stream.writeInt(this.unknown414);
        stream.writeInt(this.endpointsInterfacesDisabled);
        stream.writeInt(this.unknown41C);
        stream.writeInt(this.unknown504);
        stream.writeInt(this.unknown508);
        stream.writeInt(this.unknown50C);
        stream.writeInt(this.unknown510);
        stream.writeInt(this.unknown514);
        super.write(stream);
    }

    @Override
    public void reset() {
        int i;
        super.reset();
        for (i = 0; i < this.sendingEndpoints.length; ++i) {
            this.sendingEndpoints[i].reset();
        }
        for (i = 0; i < this.receivingEndpoints.length; ++i) {
            this.receivingEndpoints[i].reset();
        }
        this.unknown400 = 0;
        this.unknown404 = 0;
        this.unknown408 = 0;
        this.connectionInterrupt = 0;
        this.connectionInterruptEnabled = 0;
        this.unknown414 = 0;
        this.endpointsInterfacesDisabled = 0;
        this.unknown41C = 0;
        this.unknown504 = 0;
        this.unknown508 = 0;
        this.unknown50C = 0;
        this.unknown510 = 0;
        this.unknown514 = 0;
    }

    public void triggerReset() {
        Emulator.getScheduler().addAction(Scheduler.getNow() + 1000L, new UsbReset());
    }

    private void checkConnectionInterrupt() {
        if ((this.connectionInterrupt & this.connectionInterruptEnabled) != 0) {
            RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 26);
        } else {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), 26);
        }
    }

    private void triggerConnectionInterrupt(int bit) {
        this.connectionInterrupt = Utilities.setBit(this.connectionInterrupt, bit);
        this.checkConnectionInterrupt();
    }

    private void clearConnectionInterrupt(int mask) {
        this.connectionInterrupt &= ~mask;
        this.checkConnectionInterrupt();
    }

    private void clearUnknown414(int mask) {
        this.unknown414 &= ~mask;
    }

    private void setConnectionInterruptEnabled(int value) {
        this.connectionInterruptEnabled = value;
        this.checkConnectionInterrupt();
    }

    private void setUnknown404(int value) {
        this.unknown404 = value;
        if (value == 528) {
            this.unknown408 = 15;
            this.triggerConnectionInterrupt(0);
        } else if (value == 540) {
            this.unknown408 = 15;
            this.triggerConnectionInterrupt(2);
        }
    }

    protected boolean isEndpointEnabled(int endpointNumber) {
        return Utilities.notHasBit(this.endpointsInterfacesDisabled, endpointNumber);
    }

    protected boolean isInterfaceEnabled(int interfaceNumber) {
        return Utilities.notHasBit(this.endpointsInterfacesDisabled, interfaceNumber + 16);
    }

    private void setEndpointsInterfacesDisabled(int value) {
        this.endpointsInterfacesDisabled = value;
        if (this.isEndpointEnabled(1)) {
            this.unknown414 = Utilities.setBit(this.unknown414, 1);
            Endpoint endpoint = this.sendingEndpoints[1];
            endpoint.unknown04 = endpoint.unknown04 | 0x40;
            this.triggerConnectionInterrupt(5);
        }
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: 
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 20: 
            case 24: 
            case 28: {
                value = this.sendingEndpoints[0].read32(address - this.baseAddress - 0);
                break;
            }
            case 32: 
            case 36: 
            case 40: 
            case 44: 
            case 48: 
            case 52: 
            case 56: 
            case 60: {
                value = this.sendingEndpoints[1].read32(address - this.baseAddress - 32);
                break;
            }
            case 64: 
            case 68: 
            case 72: 
            case 76: 
            case 80: 
            case 84: 
            case 88: 
            case 92: {
                value = this.sendingEndpoints[2].read32(address - this.baseAddress - 64);
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 116: 
            case 120: 
            case 124: {
                value = this.sendingEndpoints[3].read32(address - this.baseAddress - 96);
                break;
            }
            case 128: 
            case 132: 
            case 136: 
            case 140: 
            case 144: 
            case 148: 
            case 152: 
            case 156: {
                value = this.sendingEndpoints[4].read32(address - this.baseAddress - 128);
                break;
            }
            case 512: 
            case 516: 
            case 520: 
            case 524: 
            case 528: 
            case 532: 
            case 536: 
            case 540: {
                value = this.receivingEndpoints[0].read32(address - this.baseAddress - 512);
                break;
            }
            case 544: 
            case 548: 
            case 552: 
            case 556: 
            case 560: 
            case 564: 
            case 568: 
            case 572: {
                value = this.receivingEndpoints[1].read32(address - this.baseAddress - 544);
                break;
            }
            case 576: 
            case 580: 
            case 584: 
            case 588: 
            case 592: 
            case 596: 
            case 600: 
            case 604: {
                value = this.receivingEndpoints[2].read32(address - this.baseAddress - 576);
                break;
            }
            case 608: 
            case 612: 
            case 616: 
            case 620: 
            case 624: 
            case 628: 
            case 632: 
            case 636: {
                value = this.receivingEndpoints[3].read32(address - this.baseAddress - 608);
                break;
            }
            case 1024: {
                value = this.unknown400;
                break;
            }
            case 1028: {
                value = this.unknown404;
                break;
            }
            case 1032: {
                value = this.unknown408;
                break;
            }
            case 1036: {
                value = this.connectionInterrupt;
                break;
            }
            case 1040: {
                value = this.connectionInterruptEnabled;
                break;
            }
            case 1044: {
                value = this.unknown414;
                break;
            }
            case 1048: {
                value = this.endpointsInterfacesDisabled;
                break;
            }
            case 1052: {
                value = this.unknown41C;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: 
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 20: 
            case 24: 
            case 28: {
                this.sendingEndpoints[0].write32(address - this.baseAddress - 0, value);
                break;
            }
            case 32: 
            case 36: 
            case 40: 
            case 44: 
            case 48: 
            case 52: 
            case 56: 
            case 60: {
                this.sendingEndpoints[1].write32(address - this.baseAddress - 32, value);
                break;
            }
            case 64: 
            case 68: 
            case 72: 
            case 76: 
            case 80: 
            case 84: 
            case 88: 
            case 92: {
                this.sendingEndpoints[2].write32(address - this.baseAddress - 64, value);
                break;
            }
            case 512: 
            case 516: 
            case 520: 
            case 524: 
            case 528: 
            case 532: 
            case 536: 
            case 540: {
                this.receivingEndpoints[0].write32(address - this.baseAddress - 512, value);
                break;
            }
            case 544: 
            case 548: 
            case 552: 
            case 556: 
            case 560: 
            case 564: 
            case 568: 
            case 572: {
                this.receivingEndpoints[1].write32(address - this.baseAddress - 544, value);
                break;
            }
            case 576: 
            case 580: 
            case 584: 
            case 588: 
            case 592: 
            case 596: 
            case 600: 
            case 604: {
                this.receivingEndpoints[2].write32(address - this.baseAddress - 576, value);
                break;
            }
            case 608: 
            case 612: 
            case 616: 
            case 620: 
            case 624: 
            case 628: 
            case 632: 
            case 636: {
                this.receivingEndpoints[3].write32(address - this.baseAddress - 608, value);
                break;
            }
            case 1024: {
                this.unknown400 = value;
                break;
            }
            case 1028: {
                this.setUnknown404(value);
                break;
            }
            case 1036: {
                this.clearConnectionInterrupt(value);
                break;
            }
            case 1040: {
                this.setConnectionInterruptEnabled(value);
                break;
            }
            case 1044: {
                this.clearUnknown414(value);
                break;
            }
            case 1048: {
                this.setEndpointsInterfacesDisabled(value);
                break;
            }
            case 1052: {
                this.unknown41C = value;
                break;
            }
            case 1284: {
                this.unknown504 = value;
                break;
            }
            case 1288: {
                this.unknown508 = value;
                break;
            }
            case 1292: {
                this.unknown50C = value;
                break;
            }
            case 1296: {
                this.unknown510 = value;
                break;
            }
            case 1300: {
                this.unknown514 = value;
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    protected static class Endpoint
    implements IState {
        private static final int STATE_VERSION = 0;
        protected static final int CONTROL_UNKNOWN_008 = 8;
        protected static final int CONTROL_UNKNOWN_040 = 64;
        protected static final int CONTROL_UNKNOWN_100 = 256;
        protected static final int CONTROL_UNKNOWN04_UNKNOWN_040 = 64;
        protected static final int CONTROL_UNKNOWN04_UNKNOWN_080 = 128;
        protected static final int CONTROL_UNKNOWN04_UNKNOWN_200 = 512;
        protected static final int CONTROL_UNKNOWN04_UNKNOWN_400 = 1024;
        private final Memory mem;
        private int control;
        private int unknown04;
        private int unknown08;
        private int unknown0C;
        private int address10;
        private int address14;
        private int unknown18;
        private int unknown1C;

        public Endpoint(Memory mem) {
            this.mem = mem;
        }

        private void clearUnknown04(int mask) {
            this.unknown04 = Utilities.clearFlag(this.unknown04, mask);
        }

        public int read32(int offset) {
            int value = 0;
            switch (offset) {
                case 0: {
                    value = this.control;
                    break;
                }
                case 4: {
                    value = this.unknown04;
                    break;
                }
                case 8: {
                    value = this.unknown08;
                    break;
                }
                case 12: {
                    value = this.unknown0C;
                    break;
                }
                case 16: {
                    value = this.address10;
                    break;
                }
                case 20: {
                    value = this.address14;
                    break;
                }
                case 24: {
                    value = this.unknown18;
                    break;
                }
                case 28: {
                    value = this.unknown1C;
                    break;
                }
                default: {
                    log.error((Object)String.format("Endpoint.read32 invalid offset 0x%X", offset));
                }
            }
            return value;
        }

        private void setAddress14(int value) {
            this.address14 = value;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("setAddress14: %s", Utilities.getMemoryDump(this.address14, 32)));
            }
        }

        private void setControl(int value) {
            this.control = value;
            if (Utilities.hasFlag(this.control, 8)) {
                int length = this.mem.read16(this.address14 + 0);
                int flags = this.mem.read16(this.address14 + 2);
                int address = this.mem.read32(this.address14 + 8);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("setControl sending length=0x%X, flags=0x%X, %s", length, flags, Utilities.getMemoryDump(address, length)));
                }
            }
        }

        public void write32(int offset, int value) {
            switch (offset) {
                case 0: {
                    this.setControl(value);
                    break;
                }
                case 4: {
                    this.clearUnknown04(value);
                    break;
                }
                case 8: {
                    this.unknown08 = value;
                    break;
                }
                case 12: {
                    this.unknown0C = value;
                    break;
                }
                case 16: {
                    this.address10 = value;
                    break;
                }
                case 20: {
                    this.setAddress14(value);
                    break;
                }
                case 24: {
                    this.unknown18 = value;
                    break;
                }
                case 28: {
                    this.unknown1C = value;
                    break;
                }
                default: {
                    log.error((Object)String.format("Endpoint.write32 invalid offset 0x%X", offset));
                }
            }
        }

        @Override
        public void read(StateInputStream stream) throws IOException {
            stream.readVersion(0);
            this.control = stream.readInt();
            this.unknown04 = stream.readInt();
            this.unknown08 = stream.readInt();
            this.unknown0C = stream.readInt();
            this.address10 = stream.readInt();
            this.address14 = stream.readInt();
            this.unknown18 = stream.readInt();
            this.unknown1C = stream.readInt();
        }

        @Override
        public void write(StateOutputStream stream) throws IOException {
            stream.writeVersion(0);
            stream.writeInt(this.control);
            stream.writeInt(this.unknown04);
            stream.writeInt(this.unknown08);
            stream.writeInt(this.unknown0C);
            stream.writeInt(this.address10);
            stream.writeInt(this.address14);
            stream.writeInt(this.unknown18);
            stream.writeInt(this.unknown1C);
        }

        public void reset() {
            this.control = 0;
            this.unknown04 = 0;
            this.unknown08 = 0;
            this.unknown0C = 0;
            this.address10 = 0;
            this.address14 = 0;
            this.unknown18 = 0;
            this.unknown1C = 0;
        }
    }

    private class UsbReset
    implements IAction {
        private UsbReset() {
        }

        @Override
        public void execute() {
            MMIOHandlerSystemControl.getInstance().triggerUsbMemoryStickInterrupt(3);
        }
    }
}

