/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.dmac;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.Memory;
import jpcsp.memory.mmio.dmac.DmacThread;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class DmacProcessor
implements IState {
    private static final int STATE_VERSION = 0;
    public static final int DMAC_STATUS_IN_PROGRESS = 1;
    public static final int DMAC_STATUS_DDR_VALUE = 240;
    public static final int DMAC_STATUS_DDR_VALUE_SHIFT = 4;
    public static final int DMAC_STATUS_REQUIRES_DDR = 256;
    public static final int DMAC_STATUS_UNKNOWN = -498;
    public static final int DMAC_ATTRIBUTES_LENGTH = 4095;
    public static final int DMAC_ATTRIBUTES_SRC_STEP_SHIFT = 12;
    public static final int DMAC_ATTRIBUTES_DST_STEP_SHIFT = 15;
    public static final int DMAC_ATTRIBUTES_SRC_LENGTH_SHIFT_SHIFT = 18;
    public static final int DMAC_ATTRIBUTES_DST_LENGTH_SHIFT_SHIFT = 21;
    public static final int DMAC_ATTRIBUTES_UNKNOWN1 = 0x1000000;
    public static final int DMAC_ATTRIBUTES_UNKNOWN2 = 0x2000000;
    public static final int DMAC_ATTRIBUTES_SRC_INCREMENT = 0x4000000;
    public static final int DMAC_ATTRIBUTES_DST_INCREMENT = 0x8000000;
    public static final int DMAC_ATTRIBUTES_TRIGGER_INTERRUPT = Integer.MIN_VALUE;
    private final Memory memSrc;
    private final Memory memDst;
    private final IAction interruptAction;
    private final IAction completedAction;
    private final DmacThread dmacThread;
    private int dst;
    private int src;
    private int next;
    private int attributes;
    private int status;

    public DmacProcessor(Memory memSrc, Memory memDst, int baseAddress, IAction interruptAction) {
        this.memSrc = memSrc;
        this.memDst = memDst;
        this.interruptAction = interruptAction;
        this.completedAction = new CompletedAction();
        this.dmacThread = new DmacThread(this);
        this.dmacThread.setName(String.format("Dmac Thread for 0x%08X", baseAddress));
        this.dmacThread.setDaemon(true);
        this.dmacThread.start();
        RuntimeContextLLE.registerExitAction(new ExitAction());
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.dst = stream.readInt();
        this.src = stream.readInt();
        this.next = stream.readInt();
        this.attributes = stream.readInt();
        this.status = stream.readInt();
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.dst);
        stream.writeInt(this.src);
        stream.writeInt(this.next);
        stream.writeInt(this.attributes);
        stream.writeInt(this.status);
    }

    public void reset() {
        this.dst = 0;
        this.src = 0;
        this.next = 0;
        this.attributes = 0;
        this.status = 0;
    }

    public int getDst() {
        return this.dst;
    }

    public void setDst(int dst) {
        this.dst = dst;
    }

    public int getSrc() {
        return this.src;
    }

    public void setSrc(int src) {
        this.src = src;
    }

    public int getNext() {
        return this.next;
    }

    public void setNext(int next) {
        this.next = next;
    }

    public int getAttributes() {
        return this.attributes;
    }

    public void setAttributes(int attributes) {
        this.attributes = attributes;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        int previousStatus = this.status;
        this.status = status;
        if (Utilities.isFallingFlag(previousStatus, status, 1)) {
            this.dmacThread.abortJob();
        } else if (Utilities.isRaisingFlag(previousStatus, status, 1)) {
            this.dmacThread.execute(this.memDst, this.memSrc, this.dst, this.src, this.next, this.attributes, status, this.interruptAction, this.completedAction);
        }
    }

    public void write32(int offset, int value) {
        switch (offset) {
            case 0: {
                this.setSrc(value);
                break;
            }
            case 4: {
                this.setDst(value);
                break;
            }
            case 8: {
                this.setNext(value);
                break;
            }
            case 12: {
                this.setAttributes(value);
                break;
            }
            case 16: {
                this.setStatus(value);
            }
        }
    }

    public int read32(int offset) {
        switch (offset) {
            case 0: {
                return this.getSrc();
            }
            case 4: {
                return this.getDst();
            }
            case 8: {
                return this.getNext();
            }
            case 12: {
                return this.getAttributes();
            }
            case 16: {
                return this.getStatus();
            }
        }
        return 0;
    }

    private class ExitAction
    implements IAction {
        private ExitAction() {
        }

        @Override
        public void execute() {
            DmacProcessor.this.dmacThread.exit();
        }
    }

    private class CompletedAction
    implements IAction {
        @Override
        public void execute() {
            DmacProcessor.this.status = Utilities.clearFlag(DmacProcessor.this.status, 1);
        }
    }
}

