/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.wm1801;

import java.io.IOException;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class WM1801
implements IState {
    public static Logger log = Logger.getLogger((String)"WM1801");
    private static final int STATE_VERSION = 0;
    private static WM1801 instance;
    private static final int NUMBER_REGISTERS = 128;
    private final int[] registers = new int[128];
    private static final int[] defaultRegisterValues;
    public static final int REGISTER_RESET = 15;

    public static WM1801 getInstance() {
        if (instance == null) {
            instance = new WM1801();
        }
        return instance;
    }

    private WM1801() {
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        stream.readInts(this.registers);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInts(this.registers);
    }

    public void reset() {
        System.arraycopy(defaultRegisterValues, 0, this.registers, 0, 128);
    }

    public void executeTransmitReceiveCommand(int[] transmitData, int[] receiveData) {
        log.error((Object)String.format("Unimplemented executeTransmitReceiveCommand transmitData: 0x%02X 0x%02X", transmitData[0], transmitData[1]));
    }

    public void executeTransmitCommand(int[] transmitData) {
        int register = transmitData[0];
        int value = transmitData[2] | transmitData[1] << 8;
        if (register >= 0 && register < 128) {
            this.setRegisterValue(register, value);
        } else {
            log.error((Object)String.format("executeTransmitCommand unknown register number: register=%d, value=0x%04X on %s", register, value, this));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("executeTransmitCommand register=%d, value=0x%04X on %s", register, value, this));
        }
    }

    private void setRegisterValue(int register, int value) {
        if (register == 15) {
            this.reset();
        } else {
            this.registers[register] = value;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WM8750[");
        boolean first = true;
        for (int i = 0; i < 128; ++i) {
            if (this.registers[i] == defaultRegisterValues[i]) continue;
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(String.format("R%d=0x%03X", i, this.registers[i]));
        }
        sb.append("]");
        return sb.toString();
    }

    static {
        defaultRegisterValues = new int[128];
    }
}

