/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.accesspoint;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.sceNetAdhoc;
import jpcsp.HLE.modules.sceNetApctl;
import jpcsp.HLE.modules.sceNetInet;
import jpcsp.network.accesspoint.IAccessPointCallback;
import jpcsp.network.protocols.ARP;
import jpcsp.network.protocols.DHCP;
import jpcsp.network.protocols.DNS;
import jpcsp.network.protocols.EtherFrame;
import jpcsp.network.protocols.ICMP;
import jpcsp.network.protocols.IPv4;
import jpcsp.network.protocols.NetPacket;
import jpcsp.network.protocols.SSDP;
import jpcsp.network.protocols.TCP;
import jpcsp.network.protocols.UDP;
import jpcsp.network.upnp.UPnP;
import jpcsp.remote.HTTPServer;
import jpcsp.remote.IProcessHTTPRequest;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class AccessPoint
implements IProcessHTTPRequest {
    public static Logger log = Logger.getLogger((String)"accesspoint");
    public static final int HARDWARE_TYPE_ETHERNET = 1;
    public static final int IP_ADDRESS_LENGTH = 4;
    private static final int BUFFER_SIZE = 2000;
    private IAccessPointCallback callback;
    private int apSocketPort = 30020;
    private pspNetMacAddress apMacAddress;
    private byte[] apIpAddress;
    private byte[] localIpAddress;
    private DatagramSocket apSocket;
    private AccessPointThread apThread;
    private String apSsid;
    private List<TcpConnection> tcpConnections;
    private List<UdpConnection> udpConnections;
    private Random random;
    private String baseUri;
    private UPnP upnp;

    public AccessPoint(IAccessPointCallback callback) {
        this.callback = callback;
        this.apMacAddress = new pspNetMacAddress(pspNetMacAddress.getRandomMacAddress());
        this.apIpAddress = AccessPoint.getIpAddress(sceNetApctl.getGateway());
        this.localIpAddress = AccessPoint.getIpAddress(sceNetApctl.getLocalHostIP());
        this.tcpConnections = new LinkedList<TcpConnection>();
        this.udpConnections = new LinkedList<UdpConnection>();
        this.random = new Random();
        if (!this.createAccessPointSocket()) {
            log.error((Object)String.format("Cannot create access point socket", new Object[0]));
        }
        this.baseUri = String.format("/AccessPoint/%d/", this.getPort());
        HTTPServer.getInstance().register(this.baseUri, this);
        this.apThread = new AccessPointThread();
        this.apThread.setDaemon(true);
        this.apThread.setName("Access Point Thread");
        this.apThread.start();
        this.upnp = new UPnP();
        this.upnp.discoverInBackground();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("AccessPoint using MAC=%s, IP=%s", this.apMacAddress, NetPacket.getIpAddressString(this.apIpAddress)));
        }
    }

    public void exit() {
        if (this.apThread != null) {
            this.apThread.exit();
            this.apThread = null;
        }
        if (this.upnp != null) {
            this.upnp.stop();
            this.upnp = null;
        }
    }

    public int getPort() {
        return this.apSocketPort;
    }

    public pspNetMacAddress getMacAddress() {
        return this.apMacAddress;
    }

    public byte[] getIpAddress() {
        return this.apIpAddress;
    }

    private boolean isMyIpAddress(byte[] ipAddress) {
        if (ipAddress.length != this.apIpAddress.length) {
            return false;
        }
        for (int i = 0; i < this.apIpAddress.length; ++i) {
            if (this.apIpAddress[i] == ipAddress[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] getLocalIpAddress() {
        return this.localIpAddress;
    }

    private static byte[] getIpAddress(String hostName) {
        try {
            InetAddress inetAddress = InetAddress.getByName(hostName);
            return inetAddress.getAddress();
        }
        catch (UnknownHostException e) {
            log.error((Object)"getIpAddress", (Throwable)e);
            return null;
        }
    }

    private static byte[] getIpAddress(int ipAddressInt) {
        byte[] ipAddress = new byte[]{(byte)(ipAddressInt >> 24), (byte)(ipAddressInt >> 16), (byte)(ipAddressInt >> 8), (byte)ipAddressInt};
        return ipAddress;
    }

    private boolean createAccessPointSocket() {
        if (this.apSocket == null) {
            boolean retry;
            do {
                retry = false;
                try {
                    this.apSocket = new DatagramSocket(this.apSocketPort);
                    this.apSocket.setBroadcast(true);
                    this.apSocket.setSoTimeout(1);
                }
                catch (BindException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("createAccessPointSocket port %d already in use (%s) - retrying with port %d", this.apSocketPort, e, this.apSocketPort + 1));
                    }
                    ++this.apSocketPort;
                    retry = true;
                }
                catch (SocketException e) {
                    log.error((Object)"createWlanSocket", (Throwable)e);
                }
            } while (retry);
        }
        return this.apSocket != null;
    }

    private boolean receiveAccessPointMessage() {
        boolean packetReceived = false;
        if (!this.createAccessPointSocket()) {
            return packetReceived;
        }
        byte[] bytes = new byte[10000];
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
        try {
            this.apSocket.receive(packet);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("receiveMessage message: %s", Utilities.getMemoryDump(packet.getData(), packet.getOffset(), packet.getLength())));
            }
            packetReceived = true;
            byte[] dataBytes = packet.getData();
            int dataOffset = packet.getOffset();
            int dataLength = packet.getLength();
            NetPacket netPacket = new NetPacket(dataBytes, dataOffset, dataLength);
            this.processMessage(netPacket);
        }
        catch (SocketTimeoutException dataBytes) {
        }
        catch (IOException e) {
            log.error((Object)"receiveMessage", (Throwable)e);
        }
        return packetReceived;
    }

    private void sendPacket(NetPacket packet, EtherFrame etherFrame) {
        int packetLength = packet.getOffset();
        byte[] buffer = new byte[33 + packetLength];
        int offset = 0;
        buffer[offset++] = 0;
        Utilities.writeStringNZ(buffer, offset, 32, this.apSsid);
        System.arraycopy(packet.getBuffer(), 0, buffer, offset += 32, packetLength);
        this.callback.sendPacketFromAccessPoint(buffer, offset += packetLength, etherFrame);
    }

    private void processMessage(NetPacket packet) throws EOFException {
        byte cmd = packet.readByte();
        if (cmd != 0) {
            log.error((Object)String.format("processMessage unknown command 0x%X", cmd));
            return;
        }
        String ssid = packet.readStringNZ(32);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("processMessage ssid='%s'", ssid));
        }
        if (this.apSsid == null) {
            this.apSsid = ssid;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Using ssid='%s' for the Access Point", this.apSsid));
            }
        }
        EtherFrame frame = new EtherFrame();
        frame.read(packet);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("processMessage %s", frame));
        }
        switch (frame.type) {
            case 2054: {
                this.processMessageARP(packet);
                break;
            }
            case 2048: {
                this.processMessageDatagram(packet, frame);
                break;
            }
            default: {
                log.error((Object)String.format("Unknow message of type 0x%04X", frame.type));
            }
        }
    }

    private void processMessageARP(NetPacket packet) throws EOFException {
        ARP arp = new ARP();
        arp.read(packet);
        if (arp.hardwareType != 1) {
            log.error((Object)String.format("processMessageARP unknown hardwareType=0x%X", arp.hardwareType));
            return;
        }
        if (arp.protocolType != 2048) {
            log.error((Object)String.format("processMessageARP unknown protocolType=0x%X", arp.protocolType));
            return;
        }
        if (arp.hardwareAddressLength != 6) {
            log.error((Object)String.format("processMessageARP unknown hardwareAddressLength=0x%X", arp.protocolType));
            return;
        }
        if (arp.protocolAddressLength != 4) {
            log.error((Object)String.format("processMessageARP unknown protocolAddressLength=0x%X", arp.protocolType));
            return;
        }
        if (arp.operation != 1 && arp.operation != 2) {
            log.error((Object)String.format("processMessageARP unknown operation=0x%X", arp.operation));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("processMessageARP %s", arp));
        }
        if (arp.targetHardwareAddress.isEmptyMacAddress()) {
            this.sendGratuitousARP();
        }
    }

    private void sendGratuitousARP() throws EOFException {
        EtherFrame frame = new EtherFrame();
        frame.dstMac = new pspNetMacAddress(sceNetAdhoc.ANY_MAC_ADDRESS);
        frame.srcMac = this.getMacAddress();
        frame.type = 2054;
        ARP arp = new ARP();
        arp.hardwareType = 1;
        arp.protocolType = 2048;
        arp.hardwareAddressLength = 6;
        arp.protocolAddressLength = 4;
        arp.operation = 1;
        arp.senderHardwareAddress = this.getMacAddress();
        arp.senderProtocolAddress = this.getIpAddress();
        arp.targetHardwareAddress = new pspNetMacAddress();
        arp.targetProtocolAddress = this.getIpAddress();
        NetPacket packet = new NetPacket(EtherFrame.sizeOf() + arp.sizeOf());
        frame.write(packet);
        arp.write(packet);
        this.sendPacket(packet, frame);
    }

    private void processMessageDatagram(NetPacket packet, EtherFrame frame) throws EOFException {
        IPv4 ipv4 = new IPv4();
        ipv4.read(packet);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("processMessageDatagram IPv4 %s", ipv4));
        }
        switch (ipv4.protocol) {
            case 1: {
                this.processMessageDatagramICMP(packet, frame, ipv4);
                break;
            }
            case 6: {
                this.processMessageTCP(packet, frame, ipv4);
                break;
            }
            case 17: {
                this.processMessageUDP(packet, frame, ipv4);
                break;
            }
            default: {
                log.error((Object)String.format("processMessageDatagram unknown protocol %d", ipv4.protocol));
            }
        }
    }

    private void processMessageUDP(NetPacket packet, EtherFrame frame, IPv4 ipv4) throws EOFException {
        UDP udp = new UDP();
        udp.read(packet);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("processMessageUDP %s", udp));
        }
        switch (udp.destinationPort) {
            case 53: {
                this.processMessageDNS(packet, frame, ipv4, udp);
                break;
            }
            case 67: {
                this.processMessageDHCP(packet, frame, ipv4, udp);
                break;
            }
            case 1900: {
                this.processMessageSSDP(packet, frame, ipv4, udp);
                break;
            }
            default: {
                UdpConnection udpConnection = this.getUdpConnection(ipv4, udp);
                if (udpConnection == null) {
                    udpConnection = new UdpConnection();
                    udpConnection.sourceMacAddress = frame.srcMac;
                    udpConnection.destinationMacAddress = frame.dstMac;
                    udpConnection.sourceIPAddress = ipv4.sourceIPAddress;
                    udpConnection.destinationIPAddress = ipv4.destinationIPAddress;
                    udpConnection.sourcePort = udp.sourcePort;
                    udpConnection.destinationPort = udp.destinationPort;
                    udpConnection.pendingConnection = true;
                    this.udpConnections.add(udpConnection);
                }
                byte[] data = new byte[udp.length - udp.sizeOf()];
                packet.readBytes(data);
                udpConnection.addPendingWriteData(data);
            }
        }
    }

    private void processMessageDNS(NetPacket packet, EtherFrame frame, IPv4 ipv4, UDP udp) throws EOFException {
        DNS dns = new DNS();
        dns.read(packet);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("processMessageDNS %s", dns));
        }
        if (!dns.isResponseFlag && dns.questionCount == 1) {
            DNS answerDns;
            block5: {
                DNS.DNSRecord question = dns.questions[0];
                String hostName = question.recordName;
                answerDns = new DNS(dns);
                try {
                    InetAddress inetAddress = InetAddress.getByName(hostName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("DNS response '%s'=%s", hostName, inetAddress));
                    }
                    DNS.DNSAnswerRecord answer = new DNS.DNSAnswerRecord();
                    answer.recordName = hostName;
                    answer.recordClass = question.recordClass;
                    answer.recordType = question.recordType;
                    answer.data = inetAddress.getAddress();
                    answer.dataLength = answer.data.length;
                    answerDns.responseCode = 0;
                    answerDns.answerRecordCount = 1;
                    answerDns.answerRecords = new DNS.DNSAnswerRecord[]{answer};
                }
                catch (UnknownHostException e) {
                    answerDns.responseCode = 3;
                    if (!log.isDebugEnabled()) break block5;
                    log.debug((Object)String.format("processMessageDNS unknown host '%s'(%s)", hostName, e.toString()));
                }
            }
            answerDns.isResponseFlag = true;
            EtherFrame answerFrame = new EtherFrame(frame);
            answerFrame.swapSourceAndDestination();
            IPv4 answerIPv4 = new IPv4(ipv4);
            answerIPv4.swapSourceAndDestination();
            --answerIPv4.timeToLive;
            UDP answerUdp = new UDP(udp);
            answerUdp.swapSourceAndDestination();
            answerUdp.length = answerUdp.sizeOf() + answerDns.sizeOf();
            answerUdp.computeChecksum();
            answerIPv4.totalLength = answerIPv4.sizeOf() + answerUdp.length;
            answerIPv4.computeChecksum();
            NetPacket answerPacket = new NetPacket(2000);
            answerFrame.write(answerPacket);
            answerIPv4.write(answerPacket);
            answerUdp.write(answerPacket);
            answerDns.write(answerPacket);
            this.sendPacket(answerPacket, answerFrame);
        }
    }

    private void processMessageDatagramICMP(NetPacket packet, EtherFrame frame, IPv4 ipv4) throws EOFException {
        ICMP icmp = new ICMP();
        icmp.read(packet);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("processMessageDatagramICMP %s", icmp));
        }
        switch (icmp.type) {
            case 8: {
                this.sendICMPEchoResponse(packet, frame, ipv4, icmp);
                break;
            }
            default: {
                log.error((Object)String.format("processMessageDatagramICMP unknown type=0x%X, code=0x%X", icmp.type, icmp.code));
            }
        }
    }

    private void sendICMPEchoResponse(NetPacket packet, EtherFrame frame, IPv4 ipv4, ICMP icmp) throws EOFException {
        boolean reachable = false;
        try {
            InetAddress inetAddress = InetAddress.getByAddress(ipv4.destinationIPAddress);
            reachable = inetAddress.isReachable(null, ipv4.timeToLive, 1000);
        }
        catch (UnknownHostException inetAddress) {
        }
        catch (IOException inetAddress) {
            // empty catch block
        }
        if (reachable) {
            EtherFrame answerFrame = new EtherFrame(frame);
            answerFrame.swapSourceAndDestination();
            IPv4 answerIPv4 = new IPv4(ipv4);
            answerIPv4.swapSourceAndDestination();
            --answerIPv4.timeToLive;
            ICMP answerIcmp = new ICMP(icmp);
            answerIcmp.type = 0;
            answerIcmp.computeChecksum();
            answerIPv4.totalLength = answerIPv4.sizeOf() + answerIcmp.sizeOf();
            answerIPv4.computeChecksum();
            NetPacket answerPacket = new NetPacket(2000);
            answerFrame.write(answerPacket);
            answerIPv4.write(answerPacket);
            answerIcmp.write(answerPacket);
            this.sendPacket(answerPacket, answerFrame);
        }
    }

    private TcpConnection getTcpConnection(IPv4 ipv4, TCP tcp) {
        for (TcpConnection tcpConnection : this.tcpConnections) {
            if (tcp.sourcePort != tcpConnection.sourcePort || tcp.destinationPort != tcpConnection.destinationPort || !Arrays.equals(ipv4.sourceIPAddress, tcpConnection.sourceIPAddress) || !Arrays.equals(ipv4.destinationIPAddress, tcpConnection.destinationIPAddress)) continue;
            return tcpConnection;
        }
        return null;
    }

    private UdpConnection getUdpConnection(IPv4 ipv4, UDP udp) {
        for (UdpConnection udpConnection : this.udpConnections) {
            if (udp.sourcePort != udpConnection.sourcePort || udp.destinationPort != udpConnection.destinationPort || !Arrays.equals(ipv4.sourceIPAddress, udpConnection.sourceIPAddress) || !Arrays.equals(ipv4.destinationIPAddress, udpConnection.destinationIPAddress)) continue;
            return udpConnection;
        }
        return null;
    }

    private void processMessageTCP(NetPacket packet, EtherFrame frame, IPv4 ipv4) throws EOFException {
        boolean isInternalMessage;
        TCP tcp = new TCP();
        tcp.read(packet);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("processMessageTCP %s", tcp));
        }
        TcpConnection tcpConnection = this.getTcpConnection(ipv4, tcp);
        boolean bl = isInternalMessage = this.isMyIpAddress(ipv4.destinationIPAddress) && tcp.destinationPort == this.apSocketPort;
        if (tcp.flagSYN) {
            if (tcpConnection != null) {
                block18: {
                    if (!tcpConnection.pendingConnection) {
                        log.error((Object)String.format("processMessageTCP SYN received but connection already exists: %s", tcpConnection));
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("processMessageTCP SYN received for a connection still pending (%s), retrying the connection", tcpConnection));
                    }
                    try {
                        tcpConnection.close();
                    }
                    catch (IOException e) {
                        if (!log.isDebugEnabled()) break block18;
                        log.debug((Object)"error while closing connection", (Throwable)e);
                    }
                }
                this.tcpConnections.remove(tcpConnection);
            }
            tcpConnection = new TcpConnection(frame, ipv4, tcp, this.random);
            if (isInternalMessage) {
                tcpConnection.proxyDestinationIPAddress = sceNetInet.internetAddressToBytes(HTTPServer.getInstance().getProxyAddress());
                tcpConnection.proxyDestinationPort = HTTPServer.getInstance().getProxyPort();
            }
            this.tcpConnections.add(tcpConnection);
        } else if (tcp.flagACK) {
            if (tcpConnection == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("processMessageTCP ACK received for unknown connection: %s", tcp));
                }
                return;
            }
            try {
                if (tcp.flagFIN) {
                    tcpConnection.sourceSequenceNumber += tcp.data.length;
                    ++tcpConnection.sourceSequenceNumber;
                    this.sendAcknowledgeTCP(tcpConnection, false);
                } else if (tcp.flagPSH || tcp.data.length > 0) {
                    tcpConnection.sourceSequenceNumber += tcp.data.length;
                    this.sendAcknowledgeTCP(tcpConnection, false);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("processMessageTCP sending data %s: %s", tcpConnection, Utilities.getMemoryDump(tcp.data)));
                    }
                    tcpConnection.addPendingWriteData(tcp.data);
                }
            }
            catch (IOException e) {
                log.error((Object)"processMessageTCP", (Throwable)e);
            }
        }
    }

    private void sendAcknowledgeTCP(TcpConnection tcpConnection, boolean flagSYN) throws EOFException {
        EtherFrame answerFrame = new EtherFrame();
        answerFrame.srcMac = tcpConnection.destinationMacAddress;
        answerFrame.dstMac = tcpConnection.sourceMacAddress;
        answerFrame.type = 2048;
        IPv4 answerIPv4 = new IPv4();
        answerIPv4.protocol = 6;
        answerIPv4.sourceIPAddress = tcpConnection.destinationIPAddress;
        answerIPv4.destinationIPAddress = tcpConnection.sourceIPAddress;
        TCP answerTcp = new TCP();
        answerTcp.sourcePort = tcpConnection.destinationPort;
        answerTcp.destinationPort = tcpConnection.sourcePort;
        answerTcp.sequenceNumber = tcpConnection.destinationSequenceNumber;
        answerTcp.acknowledgmentNumber = tcpConnection.sourceSequenceNumber;
        answerTcp.flagACK = true;
        answerTcp.flagSYN = flagSYN;
        answerTcp.computeChecksum(answerIPv4);
        answerIPv4.totalLength = answerIPv4.sizeOf() + answerTcp.sizeOf();
        answerIPv4.computeChecksum();
        NetPacket answerPacket = new NetPacket(2000);
        answerFrame.write(answerPacket);
        answerIPv4.write(answerPacket);
        answerTcp.write(answerPacket);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sendAcknowledgeTCP frame=%s", answerFrame));
            log.debug((Object)String.format("sendAcknowledgeTCP IPv4=%s", answerIPv4));
            log.debug((Object)String.format("sendAcknowledgeTCP TCP=%s", answerTcp));
        }
        this.sendPacket(answerPacket, answerFrame);
    }

    private void sendTcpData(TcpConnection tcpConnection, byte[] data) throws EOFException {
        EtherFrame answerFrame = new EtherFrame();
        answerFrame.srcMac = tcpConnection.destinationMacAddress;
        answerFrame.dstMac = tcpConnection.sourceMacAddress;
        answerFrame.type = 2048;
        IPv4 answerIPv4 = new IPv4();
        answerIPv4.protocol = 6;
        answerIPv4.sourceIPAddress = tcpConnection.destinationIPAddress;
        answerIPv4.destinationIPAddress = tcpConnection.sourceIPAddress;
        TCP answerTcp = new TCP();
        answerTcp.sourcePort = tcpConnection.destinationPort;
        answerTcp.destinationPort = tcpConnection.sourcePort;
        answerTcp.sequenceNumber = tcpConnection.destinationSequenceNumber;
        answerTcp.acknowledgmentNumber = tcpConnection.sourceSequenceNumber;
        answerTcp.flagACK = true;
        answerTcp.flagPSH = true;
        tcpConnection.destinationSequenceNumber += data.length;
        answerTcp.data = data;
        answerTcp.computeChecksum(answerIPv4);
        answerIPv4.totalLength = answerIPv4.sizeOf() + answerTcp.sizeOf();
        answerIPv4.computeChecksum();
        NetPacket answerPacket = new NetPacket(2000);
        answerFrame.write(answerPacket);
        answerIPv4.write(answerPacket);
        answerTcp.write(answerPacket);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sendTcpData frame=%s", answerFrame));
            log.debug((Object)String.format("sendTcpData IPv4=%s", answerIPv4));
            log.debug((Object)String.format("sendTcpData TCP=%s", answerTcp));
        }
        this.sendPacket(answerPacket, answerFrame);
    }

    private boolean receiveTcpMessages() {
        boolean received = false;
        LinkedList<TcpConnection> tcpConnectionsToBeDeleted = new LinkedList<TcpConnection>();
        for (TcpConnection tcpConnection : this.tcpConnections) {
            block9: {
                if (tcpConnection.pendingConnection) {
                    try {
                        tcpConnection.connect();
                        SocketChannel socketChannel = tcpConnection.socketChannel;
                        if (socketChannel != null && socketChannel.finishConnect()) {
                            ++tcpConnection.sourceSequenceNumber;
                            this.sendAcknowledgeTCP(tcpConnection, true);
                            ++tcpConnection.destinationSequenceNumber;
                            tcpConnection.pendingConnection = false;
                        }
                    }
                    catch (IOException e) {
                        tcpConnectionsToBeDeleted.add(tcpConnection);
                        if (!log.isDebugEnabled()) break block9;
                        log.debug((Object)String.format("Pending TCP connection %s failed: %s", tcpConnection, e.toString()));
                    }
                }
            }
            try {
                byte[] receivedData;
                if (tcpConnection.pendingConnection) continue;
                byte[] pendingWriteData = tcpConnection.pendingWriteData;
                if (pendingWriteData != null) {
                    tcpConnection.pendingWriteData = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("receiveTcpMessages sending pending write data: %s", Utilities.getMemoryDump(pendingWriteData)));
                    }
                    tcpConnection.write(pendingWriteData);
                }
                if ((receivedData = tcpConnection.read()) == null) continue;
                received = true;
                this.sendTcpData(tcpConnection, receivedData);
            }
            catch (IOException e) {
                log.error((Object)"receiveTcpMessages", (Throwable)e);
            }
        }
        this.tcpConnections.removeAll(tcpConnectionsToBeDeleted);
        return received;
    }

    private void sendUdpData(UdpConnection udpConnection, byte[] data) throws EOFException {
        EtherFrame answerFrame = new EtherFrame();
        answerFrame.srcMac = udpConnection.destinationMacAddress;
        answerFrame.dstMac = udpConnection.sourceMacAddress;
        answerFrame.type = 2048;
        IPv4 answerIPv4 = new IPv4();
        answerIPv4.protocol = 17;
        answerIPv4.sourceIPAddress = udpConnection.destinationIPAddress;
        answerIPv4.destinationIPAddress = udpConnection.sourceIPAddress;
        UDP answerUdp = new UDP();
        answerUdp.sourcePort = udpConnection.destinationPort;
        answerUdp.destinationPort = udpConnection.sourcePort;
        answerUdp.computeChecksum();
        answerIPv4.totalLength = answerIPv4.sizeOf() + answerUdp.sizeOf();
        if (data != null) {
            answerIPv4.totalLength += data.length;
        }
        answerIPv4.computeChecksum();
        NetPacket answerPacket = new NetPacket(2000);
        answerFrame.write(answerPacket);
        answerIPv4.write(answerPacket);
        answerUdp.write(answerPacket);
        answerPacket.writeBytes(data);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sendUdpData frame=%s", answerFrame));
            log.debug((Object)String.format("sendUdpData IPv4=%s", answerIPv4));
            log.debug((Object)String.format("sendUdpData UDP=%s", answerUdp));
            log.debug((Object)String.format("sendUdpData data=%s", Utilities.getMemoryDump(data)));
        }
        this.sendPacket(answerPacket, answerFrame);
    }

    private boolean receiveUdpMessages() {
        boolean received = false;
        LinkedList<UdpConnection> udpConnectionsToBeDeleted = new LinkedList<UdpConnection>();
        for (UdpConnection udpConnection : this.udpConnections) {
            block12: {
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("receiveUdpMessages polling %s", udpConnection));
                }
                if (udpConnection.pendingConnection) {
                    try {
                        udpConnection.connect();
                        if (udpConnection.isConnected()) {
                            udpConnection.pendingConnection = false;
                        }
                    }
                    catch (IOException e) {
                        udpConnectionsToBeDeleted.add(udpConnection);
                        if (!log.isDebugEnabled()) break block12;
                        log.debug((Object)String.format("Pending UDP connection %s failed: %s", udpConnection, e.toString()));
                    }
                }
            }
            try {
                if (!udpConnection.pendingConnection) {
                    byte[] receivedData;
                    byte[] pendingWriteData = udpConnection.pendingWriteData;
                    if (pendingWriteData != null) {
                        udpConnection.pendingWriteData = null;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("receiveUdpMessages sending pending write data: %s", Utilities.getMemoryDump(pendingWriteData)));
                        }
                        udpConnection.write(pendingWriteData);
                    }
                    if ((receivedData = udpConnection.read()) != null) {
                        received = true;
                        this.sendUdpData(udpConnection, receivedData);
                    }
                }
                udpConnection.closeIfNoLongerUsed();
            }
            catch (IOException e) {
                log.error((Object)"receiveUdpMessages", (Throwable)e);
            }
        }
        this.udpConnections.removeAll(udpConnectionsToBeDeleted);
        return received;
    }

    private void sendDHCPReply(EtherFrame frame, IPv4 ipv4, UDP udp, DHCP dhcp, int messageType) throws EOFException {
        EtherFrame answerFrame = new EtherFrame(frame);
        answerFrame.swapSourceAndDestination();
        answerFrame.srcMac = this.getMacAddress();
        IPv4 answerIPv4 = new IPv4(ipv4);
        answerIPv4.destinationIPAddress = ipv4.sourceIPAddress;
        answerIPv4.sourceIPAddress = this.getIpAddress();
        --answerIPv4.timeToLive;
        UDP answerUdp = new UDP(udp);
        answerUdp.swapSourceAndDestination();
        DHCP answerDhcp = new DHCP(dhcp);
        answerDhcp.opcode = 2;
        answerDhcp.yourIPAddress = this.getLocalIpAddress();
        answerDhcp.nextServerIPAddress = this.getIpAddress();
        answerDhcp.clearOptions();
        answerDhcp.addOption(new DHCP.DHCPOption(53, (byte)messageType));
        answerDhcp.addOption(new DHCP.DHCPOption(1, AccessPoint.getIpAddress(sceNetApctl.getSubnetMaskInt())));
        answerDhcp.addOption(new DHCP.DHCPOption(3, this.getIpAddress()));
        answerDhcp.addOption(new DHCP.DHCPOption(51, Integer.MAX_VALUE));
        answerDhcp.addOption(new DHCP.DHCPOption(54, this.getIpAddress()));
        answerDhcp.addOption(new DHCP.DHCPOption(6, this.getIpAddress()));
        answerDhcp.addOption(new DHCP.DHCPOption(28, DHCP.broadcastIPAddress));
        answerUdp.length = answerUdp.sizeOf() + answerDhcp.sizeOf();
        answerUdp.computeChecksum();
        answerIPv4.totalLength = answerIPv4.sizeOf() + answerUdp.length;
        answerIPv4.computeChecksum();
        NetPacket answerPacket = new NetPacket(2000);
        answerFrame.write(answerPacket);
        answerIPv4.write(answerPacket);
        answerUdp.write(answerPacket);
        answerDhcp.write(answerPacket);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sendDHCPReply frame=%s", answerFrame));
            log.debug((Object)String.format("sendDHCPReply IPv4=%s", answerIPv4));
            log.debug((Object)String.format("sendDHCPReply UDP=%s", answerUdp));
            log.debug((Object)String.format("sendDHCPReply messageType=%d, DHCP=%s", messageType, answerDhcp));
        }
        this.sendPacket(answerPacket, answerFrame);
    }

    private void processMessageDHCP(NetPacket packet, EtherFrame frame, IPv4 ipv4, UDP udp) throws EOFException {
        DHCP dhcp = new DHCP();
        dhcp.read(packet);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("processMessageDHCP %s", dhcp));
        }
        if (dhcp.isDiscovery(udp, ipv4)) {
            this.sendDHCPReply(frame, ipv4, udp, dhcp, 2);
        } else if (dhcp.isRequest(udp, ipv4, this.getLocalIpAddress())) {
            this.sendDHCPReply(frame, ipv4, udp, dhcp, 5);
        } else if (!dhcp.isRelease(udp, ipv4, this.getLocalIpAddress())) {
            log.error((Object)String.format("Unknown DHCP request %s", dhcp));
        }
    }

    private void sendSSDPReply(EtherFrame frame, IPv4 ipv4, UDP udp, Map<String, String> headers) throws EOFException {
        StringBuilder message = new StringBuilder("HTTP/1.1 200 OK\r\n");
        for (String name : headers.keySet()) {
            message.append(String.format("%s: %s\r\n", name, headers.get(name)));
        }
        message.append("\r\n");
        EtherFrame answerFrame = new EtherFrame(frame);
        answerFrame.swapSourceAndDestination();
        answerFrame.srcMac = this.getMacAddress();
        IPv4 answerIPv4 = new IPv4(ipv4);
        answerIPv4.destinationIPAddress = ipv4.sourceIPAddress;
        answerIPv4.sourceIPAddress = this.getIpAddress();
        --answerIPv4.timeToLive;
        UDP answerUdp = new UDP(udp);
        answerUdp.swapSourceAndDestination();
        answerUdp.length = answerUdp.sizeOf() + message.length();
        answerUdp.computeChecksum();
        answerIPv4.totalLength = answerIPv4.sizeOf() + answerUdp.length;
        answerIPv4.computeChecksum();
        NetPacket answerPacket = new NetPacket(2000);
        answerFrame.write(answerPacket);
        answerIPv4.write(answerPacket);
        answerUdp.write(answerPacket);
        answerPacket.writeString(message.toString());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sendSSDPReply frame=%s", answerFrame));
            log.debug((Object)String.format("sendSSDPReply IPv4=%s", answerIPv4));
            log.debug((Object)String.format("sendSSDPReply UDP=%s", answerUdp));
            log.debug((Object)String.format("sendSSDPReply message=%s", message));
        }
        this.sendPacket(answerPacket, answerFrame);
    }

    private void processMessageSSDP(NetPacket packet, EtherFrame frame, IPv4 ipv4, UDP udp) throws EOFException {
        SSDP ssdp = new SSDP();
        ssdp.read(packet);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("processMessageSSDP %s", ssdp));
        }
        String device = ssdp.getHeaderValue("ST");
        String location = String.format("http://%s:%d%sUPnP/%s", sceNetInet.internetAddressToString(this.getIpAddress()), this.getPort(), this.baseUri, device);
        HashMap<String, String> replyHeaders = new HashMap<String, String>();
        replyHeaders.put("ST", device);
        replyHeaders.put("Location", location);
        this.sendSSDPReply(frame, ipv4, udp, replyHeaders);
    }

    private boolean processRequestUPnP(HTTPServer server, OutputStream os, String path, HashMap<String, String> request) throws IOException {
        if ("urn:schemas-upnp-org:device:InternetGatewayDevice:1".equals(path)) {
            StringBuilder s = new StringBuilder();
            s.append("<root>");
            s.append("  <URLBase>");
            s.append(String.format("http://%s:%d/%s", sceNetInet.internetAddressToString(this.getIpAddress()), this.getPort(), this.baseUri));
            s.append("  </URLBase>");
            s.append("  <device>");
            s.append("    <deviceList>");
            s.append("      <device>");
            s.append("        <deviceList>");
            s.append("          <device>");
            s.append("            <serviceList>");
            s.append("              <service>");
            s.append("                <serviceType>urn:schemas-upnp-org:service:WANPPPConnection:1</serviceType>");
            s.append("                <controlURL>" + this.baseUri + "UPnP/urn:schemas-upnp-org:service:WANPPPConnection:1</controlURL>");
            s.append("              </service>");
            s.append("            </serviceList>");
            s.append("          </device>");
            s.append("        </deviceList>");
            s.append("      </device>");
            s.append("    </deviceList>");
            s.append("  </device>");
            s.append("</root>");
            server.sendResponse(os, s.toString());
        } else if ("urn:schemas-upnp-org:service:WANPPPConnection:1".equals(path)) {
            String action;
            String soapAction = request.get("soapaction");
            if (soapAction.startsWith("\"")) {
                soapAction = soapAction.substring(1, soapAction.length() - 1);
            }
            if ("GetExternalIPAddress".equals(action = soapAction.substring(soapAction.indexOf(35) + 1))) {
                String newExternalIPAddress = this.upnp.getIGD().getExternalIPAddress(this.upnp);
                if (newExternalIPAddress == null) {
                    newExternalIPAddress = "";
                }
                StringBuilder s = new StringBuilder();
                s.append("<s:Envelope>");
                s.append("  <s:Body>");
                s.append("    <m:GetExternalIPAddressResponse>");
                s.append("      <NewExternalIPAddress>" + newExternalIPAddress + "</NewExternalIPAddress>");
                s.append("    </m:GetExternalIPAddressResponse>");
                s.append("  </s:Body>");
                s.append("</s:Envelope>");
                server.sendResponse(os, s.toString());
            } else if ("AddPortMapping".equals(action)) {
                HashMap<String, String> upnpRequest = this.upnp.parseSimpleUPnPCommand(request.get("data"));
                String newRemoteHost = upnpRequest.get("NewRemoteHost");
                int newExternalPort = Integer.parseInt(upnpRequest.get("NewExternalPort"));
                String newProtocol = upnpRequest.get("NewProtocol");
                int newInternalPort = Integer.parseInt(upnpRequest.get("NewInternalPort"));
                String newInternalClient = upnpRequest.get("NewInternalClient");
                int newEnabled = Integer.parseInt(upnpRequest.get("NewEnabled"));
                String newPortMappingDescription = upnpRequest.get("NewPortMappingDescription");
                int newLeaseDuration = Integer.parseInt(upnpRequest.get("NewLeaseDuration"));
                if (newEnabled == 1) {
                    this.upnp.getIGD().addPortMapping(this.upnp, newRemoteHost, newExternalPort, newProtocol, newInternalPort, newInternalClient, newPortMappingDescription, newLeaseDuration);
                }
                StringBuilder s = new StringBuilder();
                s.append("<s:Envelope>");
                s.append("  <s:Body>");
                s.append("    <m:AddPortMappingResponse>");
                s.append("    </m:AddPortMappingResponse>");
                s.append("  </s:Body>");
                s.append("</s:Envelope>");
                server.sendResponse(os, s.toString());
            } else if ("DeletePortMapping".equals(action)) {
                HashMap<String, String> upnpRequest = this.upnp.parseSimpleUPnPCommand(request.get("data"));
                String newRemoteHost = upnpRequest.get("NewRemoteHost");
                int newExternalPort = Integer.parseInt(upnpRequest.get("NewExternalPort"));
                String newProtocol = upnpRequest.get("NewProtocol");
                this.upnp.getIGD().deletePortMapping(this.upnp, newRemoteHost, newExternalPort, newProtocol);
                StringBuilder s = new StringBuilder();
                s.append("<s:Envelope>");
                s.append("  <s:Body>");
                s.append("    <m:DeletePortMappingResponse>");
                s.append("    </m:DeletePortMappingResponse>");
                s.append("  </s:Body>");
                s.append("</s:Envelope>");
                server.sendResponse(os, s.toString());
            } else {
                log.error((Object)String.format("processRequest unimplemented SOAP action '%s' on %s", action, path));
            }
        } else {
            log.error((Object)String.format("processRequest unimplemented %s", path));
            return false;
        }
        return true;
    }

    @Override
    public boolean processRequest(HTTPServer server, OutputStream os, String path, HashMap<String, String> request) throws IOException {
        if (!path.startsWith(this.baseUri)) {
            log.error((Object)String.format("processRequest unimplemented %s", this.baseUri));
            return false;
        }
        String relativePath = path.substring(this.baseUri.length());
        if (relativePath.startsWith("UPnP/")) {
            return this.processRequestUPnP(server, os, relativePath.substring(5), request);
        }
        log.error((Object)String.format("processRequest unimplemented %s", relativePath));
        return false;
    }

    private class AccessPointThread
    extends Thread {
        private boolean exit = false;

        private AccessPointThread() {
        }

        @Override
        public void run() {
            RuntimeContext.setLog4jMDC();
            while (!this.exit) {
                boolean receivedAccessPointMessage = AccessPoint.this.receiveAccessPointMessage();
                boolean receivedTcpMessage = AccessPoint.this.receiveTcpMessages();
                boolean receivedUdpMessage = AccessPoint.this.receiveUdpMessages();
                if (this.exit || receivedAccessPointMessage || receivedTcpMessage || receivedUdpMessage) continue;
                Utilities.sleep(10, 0);
            }
        }

        public void exit() {
            this.exit = true;
        }
    }

    private static class UdpConnection {
        private static final long INACTIVITY_MILLIS_AUTO_CLOSE = 5000L;
        public pspNetMacAddress sourceMacAddress;
        public byte[] sourceIPAddress;
        public int sourcePort;
        public pspNetMacAddress destinationMacAddress;
        public byte[] destinationIPAddress;
        public int destinationPort;
        public DatagramChannel datagramChannel;
        public byte[] pendingWriteData;
        public boolean pendingConnection;
        private long lastUsed;

        private UdpConnection() {
        }

        private void openChannel() throws IOException {
            if (this.datagramChannel == null) {
                this.datagramChannel = DatagramChannel.open();
                this.datagramChannel.configureBlocking(false);
                this.datagramChannel.socket().setSoTimeout(0);
            }
        }

        public void connect() throws IOException {
            this.openChannel();
            if (!this.datagramChannel.isConnected()) {
                InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByAddress(this.destinationIPAddress), this.destinationPort);
                this.datagramChannel.connect(socketAddress);
                this.lastUsed = this.now();
            }
        }

        public boolean isConnected() {
            return this.datagramChannel != null && this.datagramChannel.isConnected();
        }

        public void close() throws IOException {
            if (this.datagramChannel != null) {
                this.datagramChannel.close();
                this.datagramChannel = null;
                this.lastUsed = 0L;
            }
        }

        private long now() {
            return Emulator.getClock().currentTimeMillis();
        }

        public void closeIfNoLongerUsed() throws IOException {
            if (!this.isConnected() || this.pendingWriteData != null) {
                return;
            }
            long inactivityMillis = this.now() - this.lastUsed;
            if (inactivityMillis > 5000L) {
                this.close();
            }
        }

        public void write(byte[] buffer) throws IOException {
            if (buffer != null) {
                this.write(buffer, 0, buffer.length);
            }
        }

        public void write(byte[] buffer, int offset, int length) throws IOException {
            this.datagramChannel.write(ByteBuffer.wrap(buffer, 0, length));
            this.lastUsed = this.now();
        }

        public byte[] read() throws IOException {
            if (this.datagramChannel == null) {
                return null;
            }
            byte[] buffer = new byte[2000];
            int length = this.datagramChannel.read(ByteBuffer.wrap(buffer));
            if (length <= 0) {
                return null;
            }
            byte[] readBuffer = new byte[length];
            System.arraycopy(buffer, 0, readBuffer, 0, length);
            this.lastUsed = this.now();
            return readBuffer;
        }

        public void addPendingWriteData(byte[] data) {
            if (data != null && data.length > 0) {
                this.pendingWriteData = Utilities.extendArray(this.pendingWriteData, data);
            }
        }

        public String toString() {
            return String.format("source=%s/%s:%d, destination=%s/%s:%d", this.sourceMacAddress, NetPacket.getIpAddressString(this.sourceIPAddress), this.sourcePort, this.destinationMacAddress, NetPacket.getIpAddressString(this.destinationIPAddress), this.destinationPort);
        }
    }

    private static class TcpConnection {
        public pspNetMacAddress sourceMacAddress;
        public byte[] sourceIPAddress;
        public int sourcePort;
        public int sourceSequenceNumber;
        public pspNetMacAddress destinationMacAddress;
        public byte[] destinationIPAddress;
        public byte[] proxyDestinationIPAddress;
        public int destinationPort;
        public int proxyDestinationPort;
        public int destinationSequenceNumber;
        public SocketChannel socketChannel;
        public byte[] pendingWriteData;
        public boolean pendingConnection;

        public TcpConnection(EtherFrame frame, IPv4 ipv4, TCP tcp, Random random) {
            this.sourceMacAddress = frame.srcMac;
            this.destinationMacAddress = frame.dstMac;
            this.sourceIPAddress = ipv4.sourceIPAddress;
            this.destinationIPAddress = ipv4.destinationIPAddress;
            this.proxyDestinationIPAddress = ipv4.destinationIPAddress;
            this.sourcePort = tcp.sourcePort;
            this.destinationPort = tcp.destinationPort;
            this.proxyDestinationPort = tcp.destinationPort;
            this.sourceSequenceNumber = tcp.sequenceNumber + tcp.data.length;
            this.destinationSequenceNumber = random.nextInt();
            this.pendingConnection = true;
        }

        private void openChannel() throws IOException {
            if (this.socketChannel == null) {
                this.socketChannel = SocketChannel.open();
                this.socketChannel.configureBlocking(false);
                this.socketChannel.socket().setSoTimeout(0);
            }
        }

        public void connect() throws IOException {
            this.openChannel();
            if (!this.socketChannel.isConnected() && !this.socketChannel.isConnectionPending()) {
                InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByAddress(this.proxyDestinationIPAddress), this.proxyDestinationPort);
                this.socketChannel.connect(socketAddress);
            }
        }

        public void close() throws IOException {
            if (this.socketChannel != null) {
                this.socketChannel.close();
                this.socketChannel = null;
            }
        }

        public void write(byte[] buffer) throws IOException {
            if (buffer != null) {
                this.write(buffer, 0, buffer.length);
            }
        }

        public void write(byte[] buffer, int offset, int length) throws IOException {
            if (this.socketChannel != null) {
                int n = this.socketChannel.write(ByteBuffer.wrap(buffer, 0, length));
                if (n != length) {
                    log.error((Object)String.format("TcpConnection.write could not write 0x%X bytes, only 0x%X bytes written", length, n));
                }
            } else {
                log.error((Object)String.format("TcpConnection.write socketChannel not created", new Object[0]));
            }
        }

        public byte[] read() throws IOException {
            if (this.socketChannel == null) {
                return null;
            }
            byte[] buffer = new byte[2000];
            int length = this.socketChannel.read(ByteBuffer.wrap(buffer));
            if (length <= 0) {
                return null;
            }
            byte[] readBuffer = new byte[length];
            System.arraycopy(buffer, 0, readBuffer, 0, length);
            return readBuffer;
        }

        public void addPendingWriteData(byte[] data) {
            if (data != null && data.length > 0) {
                this.pendingWriteData = Utilities.extendArray(this.pendingWriteData, data);
            }
        }

        public String toString() {
            return String.format("source=%s/%s:%d(sequenceNumber=0x%X), destination=%s/%s:%d(sequenceNumber=0x%X), proxyDestination=%s:%d", this.sourceMacAddress, NetPacket.getIpAddressString(this.sourceIPAddress), this.sourcePort, this.sourceSequenceNumber, this.destinationMacAddress, NetPacket.getIpAddressString(this.destinationIPAddress), this.destinationPort, this.destinationSequenceNumber, NetPacket.getIpAddressString(this.proxyDestinationIPAddress), this.proxyDestinationPort);
        }
    }
}

