/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.adhoc;

import jpcsp.HLE.modules.sceNet;
import jpcsp.HLE.modules.sceNetAdhoc;
import jpcsp.hardware.Wlan;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.util.Utilities;

public abstract class AdhocMessage {
    protected byte[] fromMacAddress = new byte[6];
    protected byte[] toMacAddress = new byte[6];
    protected byte[] data = new byte[0];
    protected int offset;
    public static final int MAX_HEADER_SIZE = 13;

    public AdhocMessage() {
        this.init(0, 0, sceNetAdhoc.ANY_MAC_ADDRESS);
    }

    public AdhocMessage(byte[] fromMacAddress, byte[] toMacAddress) {
        this.init(0, 0, toMacAddress);
    }

    public AdhocMessage(byte[] message, int length) {
        this.setMessage(message, length);
    }

    protected void addToBytes(byte[] bytes, byte value) {
        bytes[this.offset++] = value;
    }

    protected void addToBytes(byte[] bytes, byte[] src) {
        System.arraycopy(src, 0, bytes, this.offset, src.length);
        this.offset += src.length;
    }

    protected void addInt32ToBytes(byte[] bytes, int value) {
        this.addToBytes(bytes, (byte)value);
        this.addToBytes(bytes, (byte)(value >> 8));
        this.addToBytes(bytes, (byte)(value >> 16));
        this.addToBytes(bytes, (byte)(value >> 24));
    }

    protected byte copyByteFromBytes(byte[] bytes) {
        return bytes[this.offset++];
    }

    protected void copyFromBytes(byte[] bytes, byte[] dst) {
        System.arraycopy(bytes, this.offset, dst, 0, dst.length);
        this.offset += dst.length;
    }

    protected int copyInt32FromBytes(byte[] bytes) {
        return this.copyByteFromBytes(bytes) & 0xFF | (this.copyByteFromBytes(bytes) & 0xFF) << 8 | (this.copyByteFromBytes(bytes) & 0xFF) << 16 | (this.copyByteFromBytes(bytes) & 0xFF) << 24;
    }

    public AdhocMessage(int address, int length) {
        this.init(address, length, sceNetAdhoc.ANY_MAC_ADDRESS);
    }

    public AdhocMessage(int address, int length, byte[] toMacAddress) {
        this.init(address, length, toMacAddress);
    }

    private void init(int address, int length, byte[] toMacAddress) {
        this.init(address, length, Wlan.getMacAddress(), toMacAddress);
    }

    private void init(int address, int length, byte[] fromMacAddress, byte[] toMacAddress) {
        this.setFromMacAddress(fromMacAddress);
        this.setToMacAddress(toMacAddress);
        this.data = new byte[length];
        if (length > 0 && address != 0) {
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, length, 1);
            for (int i = 0; i < length; ++i) {
                this.data[i] = (byte)memoryReader.readNext();
            }
        }
    }

    public void setData(byte[] data) {
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    public void setDataInt32(int value) {
        this.data = new byte[4];
        for (int i = 0; i < 4; ++i) {
            this.data[i] = (byte)(value >> i * 8);
        }
    }

    public int getDataInt32() {
        int value = 0;
        for (int i = 0; i < 4 && i < this.data.length; ++i) {
            value |= (this.data[i] & 0xFF) << i * 8;
        }
        return value;
    }

    public abstract byte[] getMessage();

    public int getMessageLength() {
        return this.getDataLength();
    }

    public abstract void setMessage(byte[] var1, int var2);

    public void writeDataToMemory(int address) {
        Utilities.writeBytes(address, this.getDataLength(), this.data, 0);
    }

    public void writeDataToMemory(int address, int maxLength) {
        Utilities.writeBytes(address, Math.min(this.getDataLength(), maxLength), this.data, 0);
    }

    public void writeDataToMemory(int address, int offset, int maxLength) {
        Utilities.writeBytes(address, Math.min(this.getDataLength() - offset, maxLength), this.data, offset);
    }

    public byte[] getData() {
        return this.data;
    }

    public int getDataLength() {
        return this.data.length;
    }

    public byte[] getFromMacAddress() {
        return this.fromMacAddress;
    }

    public byte[] getToMacAddress() {
        return this.toMacAddress;
    }

    public void setFromMacAddress(byte[] fromMacAddress) {
        System.arraycopy(fromMacAddress, 0, this.fromMacAddress, 0, this.fromMacAddress.length);
    }

    public void setToMacAddress(byte[] toMacAddress) {
        System.arraycopy(toMacAddress, 0, this.toMacAddress, 0, this.toMacAddress.length);
    }

    public boolean isForMe() {
        return sceNetAdhoc.isAnyMacAddress(this.toMacAddress) || sceNetAdhoc.isSameMacAddress(this.toMacAddress, Wlan.getMacAddress());
    }

    public String toString() {
        return String.format("%s[fromMacAddress=%s, toMacAddress=%s, dataLength=%d]", this.getClass().getSimpleName(), sceNet.convertMacAddressToString(this.fromMacAddress), sceNet.convertMacAddressToString(this.toMacAddress), this.getDataLength());
    }
}

