/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.adhoc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.HLE.modules.sceNetAdhoc;
import jpcsp.Memory;
import jpcsp.hardware.Wlan;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.network.INetworkAdapter;
import jpcsp.network.adhoc.AdhocMatchingEventMessage;
import jpcsp.network.adhoc.AdhocMessage;
import jpcsp.network.adhoc.AdhocObject;
import jpcsp.util.Utilities;

public abstract class MatchingObject
extends AdhocObject {
    private int mode;
    private int maxPeers;
    private int helloDelay;
    private int pingDelay;
    private int initCount;
    private int msgDelay;
    private int callback;
    private boolean started;
    private long lastHelloMicros;
    private long lastPingMicros;
    private byte[] helloOptData;
    private SceKernelThreadInfo eventThread;
    private SceKernelThreadInfo inputThread;
    private byte[] pendingJoinRequest;
    private boolean inConnection;
    private boolean connected;
    private boolean pendingComplete;
    private LinkedList<pspNetMacAddress> members = new LinkedList();
    private LinkedList<CallbackEvent> pendingCallbackEvents = new LinkedList();

    public MatchingObject(INetworkAdapter networkAdapter) {
        super(networkAdapter);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMaxPeers() {
        return this.maxPeers;
    }

    public void setMaxPeers(int maxPeers) {
        this.maxPeers = maxPeers;
    }

    public int getHelloDelay() {
        return this.helloDelay;
    }

    public void setHelloDelay(int helloDelay) {
        this.helloDelay = helloDelay;
    }

    public int getPingDelay() {
        return this.pingDelay;
    }

    public void setPingDelay(int pingDelay) {
        this.pingDelay = pingDelay;
    }

    public int getInitCount() {
        return this.initCount;
    }

    public void setInitCount(int initCount) {
        this.initCount = initCount;
    }

    public int getMsgDelay() {
        return this.msgDelay;
    }

    public void setMsgDelay(int msgDelay) {
        this.msgDelay = msgDelay;
    }

    public int getCallback() {
        return this.callback;
    }

    public void setCallback(int callback) {
        this.callback = callback;
    }

    public List<pspNetMacAddress> getMembers() {
        return this.members;
    }

    public void create() {
    }

    public int start(int evthPri, int evthPartitionId, int evthStack, int inthPri, int inthPartitionId, int inthStack, int optLen, int optData) {
        try {
            this.setHelloOpt(optLen, optData);
            this.openSocket();
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            if (this.eventThread == null) {
                this.eventThread = threadMan.hleKernelCreateThread("SceNetAdhocMatchingEvent", 0x8000050, evthPri, evthStack, threadMan.getCurrentThread().attr, 0, 2);
                threadMan.hleKernelStartThread(this.eventThread, 0, TPointer.NULL, this.eventThread.gpReg_addr);
                this.eventThread.cpuContext.setRegister(16, this.getId());
            }
            if (this.inputThread == null) {
                this.inputThread = threadMan.hleKernelCreateThread("SceNetAdhocMatchingInput", 0x8000060, inthPri, inthStack, threadMan.getCurrentThread().attr, 0, 2);
                threadMan.hleKernelStartThread(this.inputThread, 0, TPointer.NULL, this.inputThread.gpReg_addr);
                this.inputThread.cpuContext.setRegister(16, this.getId());
            }
            this.addMember(Wlan.getMacAddress());
            this.started = true;
        }
        catch (SocketException e) {
            log.error((Object)"start", (Throwable)e);
        }
        catch (UnknownHostException e) {
            log.error((Object)"start", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"start", (Throwable)e);
        }
        return 0;
    }

    public int stop() {
        if (this.connected) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Sending disconnect to port %d", this.getPort()));
            }
            try {
                AdhocMatchingEventMessage adhocMatchingEventMessage = this.createMessage(10);
                this.send(adhocMatchingEventMessage);
            }
            catch (IOException e) {
                log.error((Object)"stop", (Throwable)e);
            }
        }
        this.closeSocket();
        this.removeMember(Wlan.getMacAddress());
        return 0;
    }

    private void sendHello() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Sending hello to port %d", this.getPort()));
        }
        AdhocMatchingEventMessage adhocMatchingEventMessage = this.createMessage(1);
        if (this.getHelloOptLen() > 0) {
            adhocMatchingEventMessage.setData(this.helloOptData);
        }
        this.send(adhocMatchingEventMessage);
        this.lastHelloMicros = Emulator.getClock().microTime();
    }

    private void sendPing() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Sending ping to port %d", this.getPort()));
        }
        AdhocMatchingEventMessage adhocMatchingEventMessage = this.createMessage(100);
        this.send(adhocMatchingEventMessage);
        this.lastPingMicros = Emulator.getClock().microTime();
    }

    @Override
    protected void closeSocket() {
        super.closeSocket();
        this.started = false;
        this.connected = false;
        this.inConnection = false;
        this.pendingComplete = false;
    }

    public int send(pspNetMacAddress macAddress, int dataLen, int data) {
        int result = 0;
        try {
            AdhocMatchingEventMessage adhocMatchingEventMessage = this.createMessage(11, data, dataLen, macAddress.macAddress);
            this.send(adhocMatchingEventMessage, macAddress, dataLen, data);
            result = dataLen;
        }
        catch (SocketException e) {
            log.error((Object)"send", (Throwable)e);
        }
        catch (UnknownHostException e) {
            log.error((Object)"send", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"send", (Throwable)e);
        }
        return result;
    }

    public int selectTarget(pspNetMacAddress macAddress, int optLen, int optData) {
        int result = 0;
        try {
            int event;
            if (this.pendingJoinRequest != null && sceNetAdhoc.isSameMacAddress(this.pendingJoinRequest, macAddress.macAddress)) {
                event = 6;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Sending accept to port %d", this.getPort()));
                }
                if (this.getMode() == 1) {
                    this.addMember(macAddress.macAddress);
                    this.connected = true;
                    this.inConnection = false;
                }
            } else {
                event = 2;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Sending join to port %d", this.getPort()));
                }
            }
            AdhocMatchingEventMessage adhocMatchingEventMessage = this.createMessage(event, optData, optLen, macAddress.macAddress);
            this.send(adhocMatchingEventMessage, macAddress, optLen, optData);
            this.inConnection = true;
        }
        catch (SocketException e) {
            log.error((Object)"selectTarget", (Throwable)e);
        }
        catch (UnknownHostException e) {
            log.error((Object)"selectTarget", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"selectTarget", (Throwable)e);
        }
        return result;
    }

    public int cancelTarget(pspNetMacAddress macAddress) {
        return this.cancelTarget(macAddress, 0, 0);
    }

    public int cancelTarget(pspNetMacAddress macAddress, int optLen, int optData) {
        int result = 0;
        try {
            int event;
            if (this.connected) {
                event = 3;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Sending leave to port %d", this.getPort()));
                }
            } else {
                event = 5;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Sending cancel to port %d", this.getPort()));
                }
            }
            AdhocMatchingEventMessage adhocMatchingEventMessage = this.createMessage(event, optData, optLen, macAddress.macAddress);
            this.send(adhocMatchingEventMessage, macAddress, optLen, optData);
        }
        catch (SocketException e) {
            log.error((Object)"cancelTarget", (Throwable)e);
        }
        catch (UnknownHostException e) {
            log.error((Object)"cancelTarget", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"cancelTarget", (Throwable)e);
        }
        this.removeMember(macAddress.macAddress);
        this.connected = false;
        this.inConnection = false;
        return result;
    }

    public int getHelloOptLen() {
        return this.helloOptData == null ? 0 : this.helloOptData.length;
    }

    public byte[] getHelloOptData() {
        return this.helloOptData;
    }

    public void setHelloOpt(int optLen, int optData) {
        if (optLen <= 0 || optData == 0) {
            this.helloOptData = null;
            return;
        }
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(optData, optLen, 1);
        this.helloOptData = new byte[optLen];
        for (int i = 0; i < optLen; ++i) {
            this.helloOptData[i] = (byte)memoryReader.readNext();
        }
    }

    public void notifyCallbackEvent(int event, int macAddr, int optLen, int optData) {
        if (this.getCallback() == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Notify callback 0x%08X, event=%d, macAddr=0x%08X, optLen=%d, optData=0x%08X", this.getCallback(), event, macAddr, optLen, optData));
        }
        Modules.ThreadManForUserModule.executeCallback(this.eventThread, this.getCallback(), null, true, this.getId(), event, macAddr, optLen, optData);
    }

    public boolean eventLoop() {
        if (this.socket == null || !this.started) {
            return false;
        }
        if (Emulator.getClock().microTime() - this.lastPingMicros >= (long)this.getPingDelay()) {
            try {
                this.sendPing();
            }
            catch (IOException e) {
                log.error((Object)"eventLoop ping", (Throwable)e);
            }
        }
        if (!this.inConnection && !this.connected && this.getMode() != 2 && Emulator.getClock().microTime() - this.lastHelloMicros >= (long)this.getHelloDelay()) {
            try {
                this.sendHello();
            }
            catch (IOException e) {
                log.error((Object)"eventLoop hello", (Throwable)e);
            }
        }
        return true;
    }

    private void addMember(byte[] macAddr) {
        for (pspNetMacAddress member : this.members) {
            if (!sceNetAdhoc.isSameMacAddress(macAddr, member.macAddress)) continue;
            return;
        }
        pspNetMacAddress member = new pspNetMacAddress();
        member.setMacAddress(macAddr);
        this.members.add(member);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Adding member %s", member));
        }
    }

    private void removeMember(byte[] macAddr) {
        for (pspNetMacAddress member : this.members) {
            if (!sceNetAdhoc.isSameMacAddress(macAddr, member.macAddress)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Removing member %s", member));
            }
            this.members.remove(member);
            break;
        }
    }

    public void addCallbackEvent(int event, int macAddr, int optLen, int optData) {
        CallbackEvent callbackEvent = new CallbackEvent(event, macAddr, optLen, optData);
        this.pendingCallbackEvents.add(callbackEvent);
    }

    public boolean inputLoop() {
        if (this.socket == null || !this.started) {
            return false;
        }
        while (!this.pendingCallbackEvents.isEmpty()) {
            CallbackEvent callbackEvent = this.pendingCallbackEvents.poll();
            pspNetMacAddress macAddress = callbackEvent.getMacAddress();
            macAddress.write(Memory.getInstance(), this.buffer.addr);
            this.notifyCallbackEvent(callbackEvent.getEvent(), macAddress.getBaseAddress(), callbackEvent.getOptLen(), callbackEvent.getOptData());
        }
        try {
            byte[] bytes = new byte[this.getBufSize() + 13];
            int length = this.socket.receive(bytes, bytes.length);
            if (length > 0) {
                int receivedPort = this.socket.getReceivedPort();
                InetAddress receivedAddress = this.socket.getReceivedAddress();
                AdhocMatchingEventMessage adhocMatchingEventMessage = this.createMessage(bytes, length);
                if (this.isForMe(adhocMatchingEventMessage, receivedPort, receivedAddress)) {
                    int event = adhocMatchingEventMessage.getEvent();
                    int macAddr = this.buffer.addr;
                    int optData = this.buffer.addr + 8;
                    int optLen = adhocMatchingEventMessage.getDataLength();
                    adhocMatchingEventMessage.writeDataToMemory(optData);
                    pspNetMacAddress macAddress = new pspNetMacAddress();
                    macAddress.setMacAddress(adhocMatchingEventMessage.getFromMacAddress());
                    macAddress.write(Memory.getInstance(), macAddr);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Received message length=%d, event=%d, fromMac=%s, port=%d: %s", adhocMatchingEventMessage.getDataLength(), event, macAddress, this.socket.getReceivedPort(), adhocMatchingEventMessage));
                        if (log.isTraceEnabled() && optLen > 0) {
                            log.trace((Object)String.format("Message data: %s", Utilities.getMemoryDump(optData, optLen)));
                        }
                    }
                    Modules.sceNetAdhocctlModule.hleNetAdhocctlPeerUpdateTimestamp(adhocMatchingEventMessage.getFromMacAddress());
                    if (event == 2) {
                        this.pendingJoinRequest = adhocMatchingEventMessage.getFromMacAddress();
                        this.inConnection = true;
                    }
                    adhocMatchingEventMessage.processOnReceive(macAddr, optData, optLen);
                    if (event == 6) {
                        this.addMember(adhocMatchingEventMessage.getFromMacAddress());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Sending complete to port %d", this.getPort()));
                        }
                        adhocMatchingEventMessage = this.createMessage(7, optData, optLen, macAddress.macAddress);
                        this.send(adhocMatchingEventMessage);
                        this.pendingComplete = true;
                        this.connected = true;
                        this.inConnection = false;
                    } else if (event == 7) {
                        this.addMember(adhocMatchingEventMessage.getFromMacAddress());
                        if (!this.pendingComplete) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("Sending complete to port %d", this.getPort()));
                            }
                            adhocMatchingEventMessage = this.createMessage(7, optData, optLen, macAddress.macAddress);
                            this.send(adhocMatchingEventMessage);
                        }
                        this.connected = true;
                        this.inConnection = false;
                    } else if (event == 11) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Sending data confirm to port %d", this.getPort()));
                        }
                        adhocMatchingEventMessage = this.createMessage(12, 0, 0, macAddress.macAddress);
                        this.send(adhocMatchingEventMessage);
                    } else if (event == 10 || event == 3) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Received disconnect/leave from %s", macAddress));
                        }
                        this.removeMember(adhocMatchingEventMessage.getFromMacAddress());
                        if (this.members.size() <= 1) {
                            this.connected = false;
                            this.inConnection = false;
                        }
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Received message not for me: %s", adhocMatchingEventMessage));
                }
            }
        }
        catch (SocketTimeoutException bytes) {
        }
        catch (IOException e) {
            log.error((Object)"inputLoop", (Throwable)e);
        }
        return true;
    }

    protected INetworkAdapter getNetworkAdapter() {
        return Modules.sceNetModule.getNetworkAdapter();
    }

    protected AdhocMatchingEventMessage createMessage(int event) {
        return this.getNetworkAdapter().createAdhocMatchingEventMessage(this, event);
    }

    protected AdhocMatchingEventMessage createMessage(int event, int data, int dataLength, byte[] macAddress) {
        return this.getNetworkAdapter().createAdhocMatchingEventMessage(this, event, data, dataLength, macAddress);
    }

    protected AdhocMatchingEventMessage createMessage(byte[] message, int length) {
        return this.getNetworkAdapter().createAdhocMatchingEventMessage(this, message, length);
    }

    protected boolean isForMe(AdhocMessage adhocMessage, int port, InetAddress address) {
        return adhocMessage.isForMe();
    }

    public String toString() {
        return String.format("MatchingObject[id=0x%X, mode=%d, maxPeers=%d, port=%d, callback=0x%08X]", this.getId(), this.mode, this.maxPeers, this.getPort(), this.callback);
    }

    protected void send(AdhocMatchingEventMessage adhocMatchingEventMessage, pspNetMacAddress macAddress, int dataLen, int data) throws IOException {
        super.send(adhocMatchingEventMessage);
        if (adhocMatchingEventMessage != null) {
            adhocMatchingEventMessage.processOnSend(macAddress.getBaseAddress(), data, dataLen);
        }
    }

    private static class CallbackEvent {
        private int event;
        private pspNetMacAddress macAddress;
        private int optLen;
        private int optData;

        public CallbackEvent(int event, int macAddr, int optLen, int optData) {
            this.event = event;
            this.macAddress = new pspNetMacAddress();
            this.macAddress.read(Memory.getInstance(), macAddr);
            this.optLen = optLen;
            this.optData = optData;
        }

        public int getEvent() {
            return this.event;
        }

        public pspNetMacAddress getMacAddress() {
            return this.macAddress;
        }

        public int getOptLen() {
            return this.optLen;
        }

        public int getOptData() {
            return this.optData;
        }
    }
}

