/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.jpcsp;

import jpcsp.HLE.modules.sceNet;
import jpcsp.network.adhoc.AdhocMessage;

public class JpcspAdhocPtpMessage
extends AdhocMessage {
    protected static final int HEADER_SIZE = 13;
    public static final int PTP_MESSAGE_TYPE_CONNECT = 1;
    public static final int PTP_MESSAGE_TYPE_CONNECT_CONFIRM = 2;
    public static final int PTP_MESSAGE_TYPE_DATA = 3;
    protected byte type;

    public JpcspAdhocPtpMessage(int type) {
        this.type = (byte)type;
    }

    public JpcspAdhocPtpMessage(int address, int length, int type) {
        super(address, length);
        this.type = (byte)type;
    }

    public JpcspAdhocPtpMessage(byte[] message, int length) {
        super(message, length);
    }

    @Override
    public byte[] getMessage() {
        byte[] message = new byte[this.getMessageLength()];
        this.offset = 0;
        this.addToBytes(message, this.fromMacAddress);
        this.addToBytes(message, this.toMacAddress);
        this.addToBytes(message, this.type);
        this.addToBytes(message, this.data);
        return message;
    }

    @Override
    public void setMessage(byte[] message, int length) {
        if (length >= 13) {
            this.offset = 0;
            this.copyFromBytes(message, this.fromMacAddress);
            this.copyFromBytes(message, this.toMacAddress);
            this.type = this.copyByteFromBytes(message);
            this.data = new byte[length - 13];
            this.copyFromBytes(message, this.data);
        }
    }

    @Override
    public int getMessageLength() {
        return super.getMessageLength() + 13;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return String.format("JpcspAdhocPtpMessage[fromMacAddress=%s, toMacAddress=%s, dataLength=%d, type=%d]", sceNet.convertMacAddressToString(this.fromMacAddress), sceNet.convertMacAddressToString(this.toMacAddress), this.getDataLength(), this.getType());
    }
}

