/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.jpcsp;

import java.util.List;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.sceNet;

public class JpcspAdhocctlMessage {
    protected String nickName;
    protected byte[] macAddress = new byte[6];
    protected String groupName;
    protected String ibss;
    protected int mode;
    protected int channel;
    protected boolean gameModeComplete;
    protected byte[][] gameModeMacs;

    public JpcspAdhocctlMessage(String nickName, byte[] macAddress, String groupName) {
        this.nickName = nickName;
        System.arraycopy(macAddress, 0, this.macAddress, 0, this.macAddress.length);
        this.groupName = groupName;
        this.ibss = Modules.sceNetAdhocctlModule.hleNetAdhocctlGetIBSS();
        this.mode = Modules.sceNetAdhocctlModule.hleNetAdhocctlGetMode();
        this.channel = Modules.sceNetAdhocctlModule.hleNetAdhocctlGetChannel();
        this.gameModeComplete = false;
        this.gameModeMacs = null;
    }

    public JpcspAdhocctlMessage(byte[] message, int length) {
        int offset = 0;
        this.nickName = this.copyFromMessage(message, offset, 128);
        this.copyFromMessage(message, offset += 128, this.macAddress);
        this.groupName = this.copyFromMessage(message, offset += this.macAddress.length, 8);
        this.ibss = this.copyFromMessage(message, offset += 8, 6);
        this.mode = this.copyInt32FromMessage(message, offset += 6);
        this.channel = this.copyInt32FromMessage(message, offset += 4);
        this.gameModeComplete = this.copyBoolFromMessage(message, offset += 4);
        int numberGameModeMacs = this.copyInt32FromMessage(message, ++offset);
        offset += 4;
        if (numberGameModeMacs > 0) {
            this.gameModeMacs = this.copyMacsFromMessage(message, offset, numberGameModeMacs);
            offset += 6 * numberGameModeMacs;
        }
    }

    public void setGameModeComplete(boolean gameModeComplete, List<pspNetMacAddress> requiredGameModeMacs) {
        this.gameModeComplete = gameModeComplete;
        int numberGameModeMacs = requiredGameModeMacs.size();
        this.gameModeMacs = new byte[numberGameModeMacs][6];
        int i = 0;
        for (pspNetMacAddress macAddress : requiredGameModeMacs) {
            this.gameModeMacs[i] = macAddress.macAddress;
            ++i;
        }
    }

    private String copyFromMessage(byte[] message, int offset, int length) {
        byte b;
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < length && (b = message[offset + i]) != 0; ++i) {
            s.append((char)b);
        }
        return s.toString();
    }

    private int copyInt32FromMessage(byte[] message, int offset) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n |= (message[offset + i] & 0xFF) << i * 8;
        }
        return n;
    }

    private boolean copyBoolFromMessage(byte[] message, int offset) {
        return message[offset] != 0;
    }

    private void copyFromMessage(byte[] message, int offset, byte[] bytes) {
        System.arraycopy(message, offset, bytes, 0, bytes.length);
    }

    private byte[][] copyMacsFromMessage(byte[] message, int offset, int numberMacs) {
        byte[][] macs = new byte[numberMacs][6];
        for (int i = 0; i < numberMacs; ++i) {
            this.copyFromMessage(message, offset, macs[i]);
            offset += macs[i].length;
        }
        return macs;
    }

    private void copyToMessage(byte[] message, int offset, String s) {
        if (s != null) {
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                message[offset + i] = (byte)s.charAt(i);
            }
        }
    }

    private void copyToMessage(byte[] message, int offset, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            message[offset + i] = bytes[i];
        }
    }

    private void copyInt32ToMessage(byte[] message, int offset, int value) {
        for (int i = 0; i < 4; ++i) {
            message[offset + i] = (byte)(value >> i * 8);
        }
    }

    private void copyBoolToMessage(byte[] message, int offset, boolean value) {
        message[offset] = (byte)(value ? 1 : 0);
    }

    private void copyMacsToMessage(byte[] message, int offset, byte[][] macs) {
        for (int i = 0; i < macs.length; ++i) {
            this.copyToMessage(message, offset, macs[i]);
            offset += macs[i].length;
        }
    }

    public byte[] getMessage() {
        byte[] message = new byte[JpcspAdhocctlMessage.getMessageLength()];
        int offset = 0;
        this.copyToMessage(message, offset, this.nickName);
        this.copyToMessage(message, offset += 128, this.macAddress);
        this.copyToMessage(message, offset += this.macAddress.length, this.groupName);
        this.copyToMessage(message, offset += 8, this.ibss);
        this.copyInt32ToMessage(message, offset += 6, this.mode);
        this.copyInt32ToMessage(message, offset += 4, this.channel);
        this.copyBoolToMessage(message, offset += 4, this.gameModeComplete);
        ++offset;
        if (this.gameModeMacs == null) {
            this.copyInt32ToMessage(message, offset, 0);
            offset += 4;
        } else {
            this.copyInt32ToMessage(message, offset, this.gameModeMacs.length);
            this.copyMacsToMessage(message, offset += 4, this.gameModeMacs);
            offset += this.gameModeMacs.length * 6;
        }
        return message;
    }

    public static int getMessageLength() {
        return 257;
    }

    public String toString() {
        StringBuilder macs = new StringBuilder();
        if (this.gameModeMacs != null) {
            macs.append(", gameModeMacs=[");
            for (int i = 0; i < this.gameModeMacs.length; ++i) {
                if (i > 0) {
                    macs.append(", ");
                }
                macs.append(sceNet.convertMacAddressToString(this.gameModeMacs[i]));
            }
            macs.append("]");
        }
        return String.format("JpcspAdhocctlMessage[nickName='%s', macAddress=%s, groupName='%s', IBSS='%s', mode=%d, channel=%d, gameModeComplete=%b%s]", this.nickName, sceNet.convertMacAddressToString(this.macAddress), this.groupName, this.ibss, this.mode, this.channel, this.gameModeComplete, macs.toString());
    }
}

