/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.proonline;

import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.sceUtility;
import jpcsp.hardware.Wlan;
import jpcsp.network.proonline.ProOnlineNetworkAdapter;
import jpcsp.network.proonline.ProOnlineServer;
import org.apache.log4j.Logger;

public class PacketFactory {
    protected static Logger log = ProOnlineNetworkAdapter.log;
    protected static final int OPCODE_PING = 0;
    protected static final int OPCODE_LOGIN = 1;
    protected static final int OPCODE_CONNECT = 2;
    protected static final int OPCODE_DISCONNECT = 3;
    protected static final int OPCODE_SCAN = 4;
    protected static final int OPCODE_SCAN_COMPLETE = 5;
    protected static final int OPCODE_CONNECT_BSSID = 6;
    protected static final int OPCODE_CHAT = 7;
    private static final int CHAT_MESSAGE_LENGTH = 64;

    public SceNetAdhocctlPacketBaseS2C createPacketS2C(ProOnlineNetworkAdapter proOnline, byte[] buffer, int length) {
        if (length > 0) {
            switch (buffer[0]) {
                case 0: {
                    return new SceNetAdhocctlPingPacketS2C(proOnline, buffer, length);
                }
                case 6: {
                    return new SceNetAdhocctlConnectBSSIDPacketS2C(proOnline, buffer, length);
                }
                case 2: {
                    return new SceNetAdhocctlConnectPacketS2C(proOnline, buffer, length);
                }
                case 4: {
                    return new SceNetAdhocctlScanPacketS2C(proOnline, buffer, length);
                }
                case 5: {
                    return new SceNetAdhocctlScanCompletePacketS2C(proOnline, buffer, length);
                }
                case 3: {
                    return new SceNetAdhocctlDisconnectPacketS2C(proOnline, buffer, length);
                }
                case 7: {
                    return new SceNetAdhocctlChatPacketS2C(proOnline, buffer, length);
                }
            }
            ProOnlineNetworkAdapter.log.error((Object)String.format("Received unknown S2C opcode %d", buffer[0]));
        }
        return null;
    }

    public SceNetAdhocctlPacketBaseC2S createPacketC2S(ProOnlineNetworkAdapter proOnline, ProOnlineServer proOnlineServer, byte[] buffer, int length) {
        if (length > 0) {
            switch (buffer[0]) {
                case 1: {
                    return new SceNetAdhocctlLoginPacketC2S(proOnline, proOnlineServer, buffer, length);
                }
                case 0: {
                    return new SceNetAdhocctlPingPacketC2S(proOnline, proOnlineServer, buffer, length);
                }
                case 2: {
                    return new SceNetAdhocctlConnectPacketC2S(proOnline, proOnlineServer, buffer, length);
                }
                case 3: {
                    return new SceNetAdhocctlDisconnectPacketC2S(proOnline, proOnlineServer, buffer, length);
                }
                case 4: {
                    return new SceNetAdhocctlScanPacketC2S(proOnline, proOnlineServer, buffer, length);
                }
                case 7: {
                    return new SceNetAdhocctlChatPacketC2S(proOnline, proOnlineServer, buffer, length);
                }
            }
            ProOnlineNetworkAdapter.log.error((Object)String.format("Received unknown C2S opcode %d", buffer[0]));
        }
        return null;
    }

    protected static class SceNetAdhocctlChatPacketS2C
    extends SceNetAdhocctlPacketBaseS2C {
        private String message;
        private String nickName;

        public SceNetAdhocctlChatPacketS2C(ProOnlineNetworkAdapter proOnline, byte[] bytes, int length) {
            super(proOnline);
            this.init(bytes, length);
        }

        public SceNetAdhocctlChatPacketS2C(String message, String nickName) {
            super(null);
            this.opcode = 7;
            this.message = message;
            this.nickName = nickName;
        }

        @Override
        protected void init(byte[] bytes, int length) {
            super.init(bytes, length);
            if (length >= this.getLength()) {
                this.message = this.copyStringFromBytes(bytes, 64);
                this.nickName = this.copyStringFromBytes(bytes, 128);
            }
        }

        @Override
        public void process() {
            this.proOnline.displayChatMessage(this.nickName, this.message);
        }

        @Override
        protected void getBytes(byte[] bytes) {
            super.getBytes(bytes);
            this.copyToBytes(bytes, this.message, 64);
            this.copyToBytes(bytes, this.nickName, 128);
        }

        @Override
        public int getLength() {
            return super.getLength() + 64 + 128;
        }

        @Override
        public String toString() {
            return String.format("ChatPacketS2C message='%s' from '%s'", this.message, this.nickName);
        }
    }

    protected static class SceNetAdhocctlDisconnectPacketS2C
    extends SceNetAdhocctlPacketBaseS2C {
        private int ip;

        public SceNetAdhocctlDisconnectPacketS2C(ProOnlineNetworkAdapter proOnline, byte[] bytes, int length) {
            super(proOnline);
            this.init(bytes, length);
        }

        public SceNetAdhocctlDisconnectPacketS2C(int ip) {
            super(null);
            this.opcode = 3;
            this.ip = ip;
        }

        @Override
        protected void init(byte[] bytes, int length) {
            super.init(bytes, length);
            if (length >= this.getLength()) {
                this.ip = this.copyInt32FromBytes(bytes);
            }
        }

        @Override
        protected void getBytes(byte[] bytes) {
            super.getBytes(bytes);
            this.copyInt32ToBytes(bytes, this.ip);
        }

        @Override
        public void process() {
            this.proOnline.deleteFriend(this.ip);
        }

        @Override
        public int getLength() {
            return super.getLength() + 4;
        }

        @Override
        public String toString() {
            return String.format("DisconnectPacketS2C ip=%s", ProOnlineNetworkAdapter.convertIpToString(this.ip));
        }
    }

    private static class SceNetAdhocctlScanCompletePacketS2C
    extends SceNetAdhocctlPacketBaseS2C {
        public SceNetAdhocctlScanCompletePacketS2C(ProOnlineNetworkAdapter proOnline, byte[] bytes, int length) {
            super(proOnline);
            this.init(bytes, length);
        }

        @Override
        public void process() {
            Modules.sceNetAdhocctlModule.hleNetAdhocctlScanComplete();
        }

        @Override
        public String toString() {
            return String.format("ScanCompletePacketS2C", new Object[0]);
        }
    }

    protected static class SceNetAdhocctlScanPacketS2C
    extends SceNetAdhocctlPacketBaseS2C {
        private String group;
        private pspNetMacAddress mac;

        public SceNetAdhocctlScanPacketS2C(ProOnlineNetworkAdapter proOnline, byte[] bytes, int length) {
            super(proOnline);
            this.init(bytes, length);
        }

        public SceNetAdhocctlScanPacketS2C(String group, pspNetMacAddress mac) {
            super(null);
            this.opcode = 4;
            this.group = group;
            this.mac = mac;
        }

        @Override
        protected void init(byte[] bytes, int length) {
            super.init(bytes, length);
            if (length >= this.getLength()) {
                this.group = this.copyStringFromBytes(bytes, 8);
                this.mac = this.copyMacFromBytes(bytes);
            }
        }

        @Override
        protected void getBytes(byte[] bytes) {
            super.getBytes(bytes);
            this.copyToBytes(bytes, this.group, 8);
            this.copyToBytes(bytes, this.mac);
        }

        @Override
        public int getLength() {
            return super.getLength() + 8 + 6;
        }

        @Override
        public void process() {
            Modules.sceNetAdhocctlModule.hleNetAdhocctlAddNetwork(this.group, this.mac, 0);
        }

        @Override
        public String toString() {
            return String.format("ScanPacketS2C[group='%s', mac=%s]", this.group, this.mac);
        }
    }

    protected static class SceNetAdhocctlConnectBSSIDPacketS2C
    extends SceNetAdhocctlPacketBaseS2C {
        private pspNetMacAddress mac;

        public SceNetAdhocctlConnectBSSIDPacketS2C(ProOnlineNetworkAdapter proOnline, byte[] bytes, int length) {
            super(proOnline);
            this.init(bytes, length);
        }

        public SceNetAdhocctlConnectBSSIDPacketS2C(pspNetMacAddress mac) {
            super(null);
            this.opcode = 6;
            this.mac = mac;
        }

        @Override
        protected void init(byte[] bytes, int length) {
            super.init(bytes, length);
            if (length >= this.getLength()) {
                this.mac = this.copyMacFromBytes(bytes);
            }
        }

        @Override
        public void process() {
            log.info((Object)String.format("Received MAC address %s", this.mac));
            this.proOnline.setConnectComplete(true);
        }

        @Override
        protected void getBytes(byte[] bytes) {
            super.getBytes(bytes);
            this.copyToBytes(bytes, this.mac);
        }

        @Override
        public int getLength() {
            return super.getLength() + 6;
        }

        @Override
        public String toString() {
            return String.format("ConnectBSSIDPacketS2C[mac=%s]", this.mac);
        }
    }

    protected static class SceNetAdhocctlConnectPacketS2C
    extends SceNetAdhocctlPacketBaseS2C {
        private String nickName;
        private pspNetMacAddress mac;
        private int ip;

        public SceNetAdhocctlConnectPacketS2C(ProOnlineNetworkAdapter proOnline, byte[] bytes, int length) {
            super(proOnline);
            this.init(bytes, length);
        }

        public SceNetAdhocctlConnectPacketS2C(String nickName, pspNetMacAddress mac, int ip) {
            super(null);
            this.opcode = 2;
            this.nickName = nickName;
            this.mac = mac;
            this.ip = ip;
        }

        @Override
        protected void init(byte[] bytes, int length) {
            super.init(bytes, length);
            if (length >= this.getLength()) {
                this.nickName = this.copyStringFromBytes(bytes, 128);
                this.mac = this.copyMacFromBytes(bytes);
                this.ip = this.copyInt32FromBytes(bytes);
            }
        }

        @Override
        protected void getBytes(byte[] bytes) {
            super.getBytes(bytes);
            this.copyToBytes(bytes, this.nickName, 128);
            this.copyToBytes(bytes, this.mac);
            this.copyInt32ToBytes(bytes, this.ip);
        }

        @Override
        public int getLength() {
            return super.getLength() + 128 + 6 + 4;
        }

        @Override
        public String toString() {
            return String.format("ConnectPacketS2C[nickName='%s', mac=%s, ip=%s]", this.nickName, this.mac, ProOnlineNetworkAdapter.convertIpToString(this.ip));
        }

        @Override
        public void process() {
            this.proOnline.addFriend(this.nickName, this.mac, this.ip);
        }
    }

    private static class SceNetAdhocctlPingPacketS2C
    extends SceNetAdhocctlPacketBaseS2C {
        public SceNetAdhocctlPingPacketS2C(ProOnlineNetworkAdapter proOnline, byte[] bytes, int length) {
            super(proOnline);
            this.init(bytes, length);
        }

        @Override
        public void process() {
        }

        @Override
        public String toString() {
            return String.format("PingPacketS2C", new Object[0]);
        }
    }

    protected static class SceNetAdhocctlChatPacketC2S
    extends SceNetAdhocctlPacketBaseC2S {
        private String message;

        public SceNetAdhocctlChatPacketC2S(ProOnlineNetworkAdapter proOnline, String message) {
            super(proOnline);
            this.opcode = 7;
            this.message = message;
        }

        public SceNetAdhocctlChatPacketC2S(ProOnlineNetworkAdapter proOnline, ProOnlineServer proOnlineServer, byte[] bytes, int length) {
            super(proOnline, proOnlineServer);
            this.init(bytes, length);
        }

        @Override
        protected void init(byte[] bytes, int length) {
            super.init(bytes, length);
            if (length >= this.getLength()) {
                this.message = this.copyStringFromBytes(bytes, 64);
            }
        }

        @Override
        protected void getBytes(byte[] bytes) {
            super.getBytes(bytes);
            this.copyToBytes(bytes, this.message, 64);
        }

        @Override
        public int getLength() {
            return super.getLength() + 64;
        }

        @Override
        public void process() {
            this.proOnlineServer.processChat(this.message);
        }
    }

    protected static class SceNetAdhocctlConnectPacketC2S
    extends SceNetAdhocctlPacketBaseC2S {
        private String group;

        public SceNetAdhocctlConnectPacketC2S(ProOnlineNetworkAdapter proOnline) {
            super(proOnline);
            this.opcode = 2;
            this.group = Modules.sceNetAdhocctlModule.hleNetAdhocctlGetGroupName();
        }

        public SceNetAdhocctlConnectPacketC2S(ProOnlineNetworkAdapter proOnline, ProOnlineServer proOnlineServer, byte[] bytes, int length) {
            super(proOnline, proOnlineServer);
            this.init(bytes, length);
        }

        @Override
        protected void init(byte[] bytes, int length) {
            super.init(bytes, length);
            if (length >= this.getLength()) {
                this.group = this.copyStringFromBytes(bytes, 8);
            }
        }

        @Override
        protected void getBytes(byte[] bytes) {
            super.getBytes(bytes);
            this.copyToBytes(bytes, this.group, 8);
        }

        @Override
        public int getLength() {
            return super.getLength() + 8;
        }

        @Override
        public void process() {
            this.proOnlineServer.processConnect(this.group);
        }
    }

    protected static class SceNetAdhocctlLoginPacketC2S
    extends SceNetAdhocctlPacketBaseC2S {
        private pspNetMacAddress mac = new pspNetMacAddress();
        private String nickName;
        private String game;

        public SceNetAdhocctlLoginPacketC2S(ProOnlineNetworkAdapter proOnline) {
            super(proOnline);
            this.opcode = 1;
            this.mac.setMacAddress(Wlan.getMacAddress());
            this.nickName = sceUtility.getSystemParamNickname();
            this.game = Modules.sceNetAdhocctlModule.hleNetAdhocctlGetAdhocID();
        }

        public SceNetAdhocctlLoginPacketC2S(ProOnlineNetworkAdapter proOnline, ProOnlineServer proOnlineServer, byte[] bytes, int length) {
            super(proOnline, proOnlineServer);
            this.init(bytes, length);
        }

        @Override
        protected void init(byte[] bytes, int length) {
            super.init(bytes, length);
            if (length >= this.getLength()) {
                this.mac = this.copyMacFromBytes(bytes);
                this.nickName = this.copyStringFromBytes(bytes, 128);
                this.game = this.copyStringFromBytes(bytes, 9);
            }
        }

        @Override
        protected void getBytes(byte[] bytes) {
            super.getBytes(bytes);
            this.copyToBytes(bytes, this.mac);
            this.copyToBytes(bytes, this.nickName, 128);
            this.copyToBytes(bytes, this.game, 9);
        }

        @Override
        public int getLength() {
            return super.getLength() + 6 + 128 + 9;
        }

        @Override
        public void process() {
            this.proOnlineServer.processLogin(this.mac, this.nickName, this.game);
        }
    }

    protected static class SceNetAdhocctlScanPacketC2S
    extends SceNetAdhocctlPacketBaseC2S {
        public SceNetAdhocctlScanPacketC2S(ProOnlineNetworkAdapter proOnline) {
            super(proOnline);
            this.opcode = 4;
        }

        public SceNetAdhocctlScanPacketC2S(ProOnlineNetworkAdapter proOnline, ProOnlineServer proOnlineServer, byte[] bytes, int length) {
            super(proOnline, proOnlineServer);
            this.init(bytes, length);
        }

        @Override
        public void process() {
            this.proOnlineServer.processScan();
        }
    }

    protected static class SceNetAdhocctlDisconnectPacketC2S
    extends SceNetAdhocctlPacketBaseC2S {
        public SceNetAdhocctlDisconnectPacketC2S(ProOnlineNetworkAdapter proOnline) {
            super(proOnline);
            this.opcode = 3;
        }

        public SceNetAdhocctlDisconnectPacketC2S(ProOnlineNetworkAdapter proOnline, ProOnlineServer proOnlineServer, byte[] bytes, int length) {
            super(proOnline, proOnlineServer);
            this.init(bytes, length);
        }

        @Override
        public void process() {
            this.proOnlineServer.processDisconnect();
        }
    }

    protected static class SceNetAdhocctlPingPacketC2S
    extends SceNetAdhocctlPacketBaseC2S {
        public SceNetAdhocctlPingPacketC2S(ProOnlineNetworkAdapter proOnline) {
            super(proOnline);
            this.opcode = 0;
        }

        public SceNetAdhocctlPingPacketC2S(ProOnlineNetworkAdapter proOnline, ProOnlineServer proOnlineServer, byte[] bytes, int length) {
            super(proOnline, proOnlineServer);
            this.init(bytes, length);
        }

        @Override
        public void process() {
        }
    }

    protected static abstract class SceNetAdhocctlPacketBaseS2C
    extends SceNetAdhocctlPacketBase {
        protected SceNetAdhocctlPacketBaseS2C(ProOnlineNetworkAdapter proOnline) {
            super(proOnline);
        }

        public abstract void process();
    }

    protected static abstract class SceNetAdhocctlPacketBaseC2S
    extends SceNetAdhocctlPacketBase {
        protected ProOnlineServer proOnlineServer;

        protected SceNetAdhocctlPacketBaseC2S(ProOnlineNetworkAdapter proOnline) {
            super(proOnline);
        }

        protected SceNetAdhocctlPacketBaseC2S(ProOnlineNetworkAdapter proOnline, ProOnlineServer proOnlineServer) {
            super(proOnline);
            this.proOnlineServer = proOnlineServer;
        }

        public abstract void process();
    }

    protected static abstract class SceNetAdhocctlPacketBase {
        protected final ProOnlineNetworkAdapter proOnline;
        protected int opcode;
        protected int offset;

        protected SceNetAdhocctlPacketBase(ProOnlineNetworkAdapter proOnline) {
            this.proOnline = proOnline;
        }

        public byte[] getBytes() {
            byte[] bytes = new byte[this.getLength()];
            this.getBytes(bytes);
            return bytes;
        }

        protected void getBytes(byte[] bytes) {
            this.offset = 0;
            bytes[this.offset] = (byte)this.opcode;
            ++this.offset;
        }

        protected void copyToBytes(byte[] bytes, String s, int length) {
            int i = 0;
            while (i < length) {
                bytes[this.offset] = (byte)(i < s.length() ? s.charAt(i) : (char)'\u0000');
                ++i;
                ++this.offset;
            }
        }

        protected String copyStringFromBytes(byte[] bytes, int length) {
            int stringLength = length;
            for (int i = 0; i < length; ++i) {
                if (bytes[this.offset + i] != 0) continue;
                stringLength = i;
                break;
            }
            String s = new String(bytes, this.offset, stringLength);
            this.offset += length;
            return s;
        }

        protected int copyInt8FromBytes(byte[] bytes) {
            return bytes[this.offset++] & 0xFF;
        }

        protected int copyInt32FromBytes(byte[] bytes) {
            return this.copyInt8FromBytes(bytes) | this.copyInt8FromBytes(bytes) << 8 | this.copyInt8FromBytes(bytes) << 16 | this.copyInt8FromBytes(bytes) << 24;
        }

        protected pspNetMacAddress copyMacFromBytes(byte[] bytes) {
            pspNetMacAddress mac = new pspNetMacAddress();
            mac.setMacAddress(bytes, this.offset);
            this.offset += 6;
            return mac;
        }

        protected void copyToBytes(byte[] bytes, pspNetMacAddress mac) {
            System.arraycopy(mac.macAddress, 0, bytes, this.offset, 6);
            this.offset += 6;
        }

        protected void copyInt8ToBytes(byte[] bytes, int value) {
            bytes[this.offset++] = (byte)(value & 0xFF);
        }

        protected void copyInt32ToBytes(byte[] bytes, int value) {
            this.copyInt8ToBytes(bytes, value);
            this.copyInt8ToBytes(bytes, value >> 8);
            this.copyInt8ToBytes(bytes, value >> 16);
            this.copyInt8ToBytes(bytes, value >> 24);
        }

        protected void init(byte[] bytes, int length) {
            this.offset = 0;
            if (length >= this.getLength()) {
                this.opcode = bytes[this.offset];
                ++this.offset;
            }
        }

        public int getLength() {
            return 1;
        }

        public String toString() {
            return String.format("%s", this.getClass().getSimpleName());
        }
    }
}

