/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.proonline;

import java.io.IOException;
import java.net.SocketAddress;
import jpcsp.network.adhoc.AdhocDatagramSocket;
import jpcsp.network.adhoc.AdhocMessage;
import jpcsp.network.proonline.MacIp;
import jpcsp.network.proonline.ProOnlineNetworkAdapter;

public class ProOnlineAdhocDatagramSocket
extends AdhocDatagramSocket {
    private ProOnlineNetworkAdapter proOnline;

    public ProOnlineAdhocDatagramSocket(ProOnlineNetworkAdapter proOnline) {
        this.proOnline = proOnline;
    }

    @Override
    public void send(SocketAddress socketAddress, AdhocMessage adhocMessage) throws IOException {
        if (this.proOnline.isBroadcast(socketAddress)) {
            int port = this.proOnline.getBroadcastPort(socketAddress);
            int numberMacIps = this.proOnline.getNumberMacIps();
            for (int i = 0; i < numberMacIps; ++i) {
                MacIp macIp = this.proOnline.getMacIp(i);
                if (macIp == null) continue;
                SocketAddress remoteSocketAddress = this.proOnline.getSocketAddress(macIp.mac, port);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Sending broadcasted message to %s: %s", macIp, adhocMessage));
                }
                super.send(remoteSocketAddress, adhocMessage);
            }
        } else {
            super.send(socketAddress, adhocMessage);
        }
    }
}

