/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.protocols;

import java.io.EOFException;
import jpcsp.network.protocols.InternetChecksum;
import jpcsp.network.protocols.NetPacket;
import jpcsp.util.Utilities;

public class IPv4 {
    public static final int IPv4_PROTOCOL_ICMP = 1;
    public static final int IPv4_PROTOCOL_TCP = 6;
    public static final int IPv4_PROTOCOL_UDP = 17;
    public int version;
    public int internetHeaderLength;
    public int differentiatedServicesCodePoint;
    public int explicitCongestionNotification;
    public int totalLength;
    public int identification;
    public int flags;
    public int fragmentOffset;
    public int timeToLive;
    public int protocol;
    public int headerChecksum;
    public byte[] sourceIPAddress;
    public byte[] destinationIPAddress;
    public byte[] options;

    public IPv4() {
        this.version = 4;
        this.internetHeaderLength = 5;
        this.timeToLive = 64;
    }

    public IPv4(IPv4 ipv4) {
        this.version = ipv4.version;
        this.internetHeaderLength = ipv4.internetHeaderLength;
        this.differentiatedServicesCodePoint = ipv4.differentiatedServicesCodePoint;
        this.explicitCongestionNotification = ipv4.explicitCongestionNotification;
        this.totalLength = ipv4.totalLength;
        this.identification = ipv4.identification;
        this.flags = ipv4.flags;
        this.fragmentOffset = ipv4.fragmentOffset;
        this.timeToLive = ipv4.timeToLive;
        this.protocol = ipv4.protocol;
        this.headerChecksum = ipv4.headerChecksum;
        this.sourceIPAddress = ipv4.sourceIPAddress;
        this.destinationIPAddress = ipv4.destinationIPAddress;
        this.options = ipv4.options;
    }

    private int getOptionsLength() {
        return Math.max((this.internetHeaderLength - 5) * 4, 0);
    }

    public void swapSourceAndDestination() {
        byte[] ip = this.sourceIPAddress;
        this.sourceIPAddress = this.destinationIPAddress;
        this.destinationIPAddress = ip;
    }

    public void computeChecksum() throws EOFException {
        this.headerChecksum = 0;
        NetPacket checksumPacket = this.write();
        this.headerChecksum = InternetChecksum.computeInternetChecksum(checksumPacket.getBuffer(), 0, checksumPacket.getOffset());
    }

    public void read(NetPacket packet) throws EOFException {
        this.version = packet.readBits(4);
        this.internetHeaderLength = packet.readBits(4);
        this.differentiatedServicesCodePoint = packet.readBits(6);
        this.explicitCongestionNotification = packet.readBits(2);
        this.totalLength = packet.read16();
        this.identification = packet.read16();
        this.flags = packet.readBits(3);
        this.fragmentOffset = packet.readBits(13);
        this.timeToLive = packet.read8();
        this.protocol = packet.read8();
        this.headerChecksum = packet.read16();
        this.sourceIPAddress = packet.readIpAddress();
        this.destinationIPAddress = packet.readIpAddress();
        this.options = packet.readBytes(this.getOptionsLength());
    }

    public NetPacket write(NetPacket packet) throws EOFException {
        packet.writeBits(this.version, 4);
        packet.writeBits(this.internetHeaderLength, 4);
        packet.writeBits(this.differentiatedServicesCodePoint, 6);
        packet.writeBits(this.explicitCongestionNotification, 2);
        packet.write16(this.totalLength);
        packet.write16(this.identification);
        packet.writeBits(this.flags, 3);
        packet.writeBits(this.fragmentOffset, 13);
        packet.write8(this.timeToLive);
        packet.write8(this.protocol);
        packet.write16(this.headerChecksum);
        packet.writeIpAddress(this.sourceIPAddress);
        packet.writeIpAddress(this.destinationIPAddress);
        packet.writeBytes(this.options, 0, this.getOptionsLength());
        return packet;
    }

    public NetPacket write() throws EOFException {
        return this.write(new NetPacket(this.sizeOf()));
    }

    public int sizeOf() {
        return this.internetHeaderLength * 4;
    }

    public String toString() {
        return String.format("version=0x%X, internetHeaderLength=0x%X, differentiatedServicesCodePoint=0x%X, explicitCongestionNotification=0x%X, totalLength=0x%X, identification=0x%X, flags=0x%X, fragmentOffset=0x%X, timeToLive=0x%X, protocol=0x%X, headerChecksum=0x%04X, sourceIP=%s, destinationIP=%s, options=%s", this.version, this.internetHeaderLength, this.differentiatedServicesCodePoint, this.explicitCongestionNotification, this.totalLength, this.identification, this.flags, this.fragmentOffset, this.timeToLive, this.protocol, this.headerChecksum, NetPacket.getIpAddressString(this.sourceIPAddress), NetPacket.getIpAddressString(this.destinationIPAddress), Utilities.getMemoryDump(this.options, 0, this.getOptionsLength()));
    }
}

