/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.settings;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import jpcsp.Controller;
import jpcsp.Emulator;
import jpcsp.GUI.RecentElement;
import jpcsp.State;
import jpcsp.settings.ISettingsListener;
import jpcsp.settings.SettingsListenerInfo;
import jpcsp.util.Utilities;

public class Settings {
    public static String SETTINGS_FILE_NAME = "Settings.properties";
    private static final String DEFAULT_SETTINGS_FILE_NAME = "/jpcsp/DefaultSettings.properties";
    private static Settings instance = null;
    private Properties defaultSettings;
    private SortedProperties loadedSettings;
    private Properties patchSettings;
    private HashMap<String, List<ISettingsListener>> listenersByKey;
    private List<SettingsListenerInfo> allListeners;
    private boolean useUmdIdForDiscDirectory;
    private Map<String, String> directoryMapping;
    private Font loadedFont;

    public static Settings getInstance() {
        if (instance == null) {
            instance = new Settings();
        }
        return instance;
    }

    /*
     * Exception decompiling
     */
    private Settings() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getTmpDirectory() {
        return this.readString("emu.tmppath") + File.separatorChar;
    }

    public String getDiscTmpDirectory() {
        return this.getTmpDirectory() + this.getDiscDirectory();
    }

    public String getDiscDirectory() {
        if (this.useUmdIdForDiscDirectory) {
            return String.format("%s-%s%c", State.discId, State.umdId, Character.valueOf(File.separatorChar));
        }
        return String.format("%s%c", State.discId, Character.valueOf(File.separatorChar));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadPatchSettings() {
        String key;
        Properties previousPatchSettings = new Properties(this.patchSettings);
        this.patchSettings.clear();
        String discId = State.discId;
        if (!discId.equals("[unknown, file]") && !discId.equals("[unknown, nothing loaded]")) {
            String patchFileName = String.format("patches/%s-%s.properties", discId, State.umdId);
            File patchFile = new File(patchFileName);
            if (!patchFile.exists()) {
                patchFileName = String.format("patches/%s.properties", discId);
                patchFile = new File(patchFileName);
                this.useUmdIdForDiscDirectory = false;
            } else {
                this.useUmdIdForDiscDirectory = true;
            }
            BufferedInputStream patchSettingsStream = null;
            try {
                patchSettingsStream = new BufferedInputStream(new FileInputStream(patchFile));
                this.patchSettings.load(patchSettingsStream);
                Emulator.log.info((Object)String.format("Overwriting default settings with patch file '%s'", patchFileName));
            }
            catch (FileNotFoundException e) {
                Emulator.log.debug((Object)String.format("Patch file not found: %s", e.toString()));
                Utilities.close(patchSettingsStream);
            }
            catch (IOException e2) {
                Emulator.log.error((Object)"Problem loading patch:", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        Utilities.close(patchSettingsStream);
                        throw throwable;
                    }
                }
                Utilities.close(patchSettingsStream);
            }
            Utilities.close(patchSettingsStream);
        }
        Enumeration<Object> e = this.patchSettings.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement().toString();
            previousPatchSettings.remove(key);
            String value = this.patchSettings.getProperty(key);
            if (value.equals(this.loadedSettings.getProperty(key))) continue;
            this.triggerSettingsListener(key, value);
        }
        e = previousPatchSettings.keys();
        while (e.hasMoreElements()) {
            String newValue;
            key = e.nextElement().toString();
            String oldValue = previousPatchSettings.getProperty(key);
            if (oldValue.equals(newValue = this.getProperty(key))) continue;
            this.triggerSettingsListener(key, newValue);
        }
    }

    /*
     * Loose catch block
     */
    private void writeSettings() {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(SETTINGS_FILE_NAME));
            this.loadedSettings.store(out, null);
        }
        catch (FileNotFoundException e) {
            Emulator.log.error((Object)"Settings file not found:", (Throwable)e);
            Utilities.close(out);
        }
        catch (IOException e2) {
            Emulator.log.error((Object)"Problem saving settings:", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    Utilities.close(out);
                    throw throwable;
                }
            }
            Utilities.close(out);
        }
        Utilities.close(out);
    }

    private String getProperty(String key) {
        String value = this.patchSettings.getProperty(key);
        if (value == null) {
            value = this.loadedSettings.getProperty(key);
        }
        return value;
    }

    private String getProperty(String key, String defaultValue) {
        String value = this.patchSettings.getProperty(key);
        if (value == null) {
            value = this.loadedSettings.getProperty(key, defaultValue);
        }
        return value;
    }

    private void setProperty(String key, String value) {
        String previousValue = this.getProperty(key);
        this.loadedSettings.setProperty(key, value);
        String newValue = this.getProperty(key);
        if (previousValue == null || !previousValue.equals(newValue)) {
            this.triggerSettingsListener(key, newValue);
        }
    }

    public boolean hasProperty(String key) {
        return this.loadedSettings.containsKey(key);
    }

    public void clearProperty(String key) {
        this.loadedSettings.remove(key);
    }

    public Point readWindowPos(String windowname) {
        String x = this.getProperty("gui.windows." + windowname + ".x");
        String y = this.getProperty("gui.windows." + windowname + ".y");
        if (x == null || y == null) {
            return null;
        }
        Point position = new Point();
        position.x = Integer.parseInt(x);
        position.y = Integer.parseInt(y);
        return position;
    }

    public Dimension readWindowSize(String windowname) {
        String w = this.getProperty("gui.windows." + windowname + ".w");
        String h = this.getProperty("gui.windows." + windowname + ".h");
        if (w == null || h == null) {
            return null;
        }
        Dimension dimension = new Dimension();
        dimension.width = Integer.parseInt(w);
        dimension.height = Integer.parseInt(h);
        return dimension;
    }

    public void writeWindowPos(String windowname, Point pos) {
        this.setProperty("gui.windows." + windowname + ".x", Integer.toString(pos.x));
        this.setProperty("gui.windows." + windowname + ".y", Integer.toString(pos.y));
        this.writeSettings();
    }

    public void writeWindowSize(String windowname, Dimension dimension) {
        this.setProperty("gui.windows." + windowname + ".w", Integer.toString(dimension.width));
        this.setProperty("gui.windows." + windowname + ".h", Integer.toString(dimension.height));
        this.writeSettings();
    }

    public static boolean parseBool(String value) {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        return Integer.parseInt(value) != 0;
    }

    public static int parseInt(String value) {
        return Utilities.parseInteger(value);
    }

    public static long parseLong(String value) {
        if ((value = value.trim()).startsWith("0x")) {
            return Long.parseLong(value.substring(2), 16);
        }
        return Long.parseLong(value);
    }

    public static float parseFloat(String value) {
        return Float.parseFloat(value);
    }

    public boolean readBool(String option) {
        String bool = this.getProperty(option);
        if (bool == null) {
            return false;
        }
        return Settings.parseBool(bool);
    }

    public int readInt(String option) {
        return this.readInt(option, 0);
    }

    public int readInt(String option, int defaultValue) {
        String value = this.getProperty(option);
        if (value == null) {
            return defaultValue;
        }
        return Settings.parseInt(value);
    }

    public long readLong(String option, long defaultValue) {
        String value = this.getProperty(option);
        if (value == null) {
            return defaultValue;
        }
        return Settings.parseLong(value);
    }

    public void writeBool(String option, boolean value) {
        String state = value ? "1" : "0";
        this.setProperty(option, state);
        this.writeSettings();
    }

    public void writeInt(String option, int value) {
        String state = Integer.toString(value);
        this.setProperty(option, state);
        this.writeSettings();
    }

    public void writeIntHex(String option, int value) {
        String state = String.format("0x%X", value);
        this.setProperty(option, state);
        this.writeSettings();
    }

    public void writeLong(String option, long value) {
        String state = Long.toString(value);
        this.setProperty(option, state);
        this.writeSettings();
    }

    public void writeLongHex(String option, long value) {
        String state = String.format("0x%X", value);
        this.setProperty(option, state);
        this.writeSettings();
    }

    public String readString(String option) {
        return this.readString(option, "");
    }

    public String readString(String option, String defaultValue) {
        return this.getProperty(option, defaultValue);
    }

    public boolean isOptionFromPatch(String option) {
        return this.patchSettings.containsKey(option);
    }

    public void writeString(String option, String value) {
        this.setProperty(option, value);
        this.writeSettings();
    }

    public void writeFloat(String option, float value) {
        String state = Float.toString(value);
        this.setProperty(option, state);
        this.writeSettings();
    }

    public float readFloat(String option, float defaultValue) {
        String value = this.getProperty(option);
        if (value == null) {
            return defaultValue;
        }
        return Settings.parseFloat(value);
    }

    private static int[] parseInts(String s) {
        String[] values = s.split(",");
        if (values == null) {
            return null;
        }
        int[] ints = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            ints[i] = Settings.parseInt(values[i]);
        }
        return ints;
    }

    public int[] readInts(String option, int[] defaultValue) {
        String value = this.getProperty(option);
        if (value == null) {
            return defaultValue;
        }
        return Settings.parseInts(value);
    }

    private static String formatInts(int[] values) {
        StringBuilder s = new StringBuilder();
        if (values != null) {
            for (int value : values) {
                if (s.length() > 0) {
                    s.append(", ");
                }
                s.append(String.format("0x%X", value));
            }
        }
        return s.toString();
    }

    public void writeInts(String option, int[] values) {
        this.writeString(option, Settings.formatInts(values));
    }

    public byte[] readBytes(String option, byte[] defaultValue) {
        String value = this.getProperty(option);
        if (value == null) {
            return defaultValue;
        }
        int[] ints = Settings.parseInts(value);
        if (ints == null) {
            return null;
        }
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            bytes[i] = (byte)ints[i];
        }
        return bytes;
    }

    public void writeBytes(String option, byte[] values) {
        int[] ints = null;
        if (values != null) {
            ints = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                ints[i] = values[i] & 0xFF;
            }
        }
        this.writeString(option, Settings.formatInts(ints));
    }

    public HashMap<Integer, Controller.keyCode> loadKeys() {
        HashMap<Integer, Controller.keyCode> m = new HashMap<Integer, Controller.keyCode>(22);
        m.put(this.readKey("up"), Controller.keyCode.UP);
        m.put(this.readKey("down"), Controller.keyCode.DOWN);
        m.put(this.readKey("left"), Controller.keyCode.LEFT);
        m.put(this.readKey("right"), Controller.keyCode.RIGHT);
        m.put(this.readKey("analogUp"), Controller.keyCode.LANUP);
        m.put(this.readKey("analogDown"), Controller.keyCode.LANDOWN);
        m.put(this.readKey("analogLeft"), Controller.keyCode.LANLEFT);
        m.put(this.readKey("analogRight"), Controller.keyCode.LANRIGHT);
        if (Controller.getInstance().hasRightAnalogController()) {
            m.put(this.readKey("rightAnalogUp"), Controller.keyCode.RANUP);
            m.put(this.readKey("rightAnalogDown"), Controller.keyCode.RANDOWN);
            m.put(this.readKey("rightAnalogLeft"), Controller.keyCode.RANLEFT);
            m.put(this.readKey("rightAnalogRight"), Controller.keyCode.RANRIGHT);
        }
        m.put(this.readKey("start"), Controller.keyCode.START);
        m.put(this.readKey("select"), Controller.keyCode.SELECT);
        m.put(this.readKey("triangle"), Controller.keyCode.TRIANGLE);
        m.put(this.readKey("square"), Controller.keyCode.SQUARE);
        m.put(this.readKey("circle"), Controller.keyCode.CIRCLE);
        m.put(this.readKey("cross"), Controller.keyCode.CROSS);
        m.put(this.readKey("lTrigger"), Controller.keyCode.L1);
        m.put(this.readKey("rTrigger"), Controller.keyCode.R1);
        m.put(this.readKey("home"), Controller.keyCode.HOME);
        m.put(this.readKey("hold"), Controller.keyCode.HOLD);
        m.put(this.readKey("volPlus"), Controller.keyCode.VOLPLUS);
        m.put(this.readKey("volMin"), Controller.keyCode.VOLMIN);
        m.put(this.readKey("screen"), Controller.keyCode.SCREEN);
        m.put(this.readKey("music"), Controller.keyCode.MUSIC);
        return m;
    }

    public Map<Controller.keyCode, String> loadController() {
        EnumMap<Controller.keyCode, String> m = new EnumMap<Controller.keyCode, String>(Controller.keyCode.class);
        m.put(Controller.keyCode.UP, this.readController("up"));
        m.put(Controller.keyCode.DOWN, this.readController("down"));
        m.put(Controller.keyCode.LEFT, this.readController("left"));
        m.put(Controller.keyCode.RIGHT, this.readController("right"));
        m.put(Controller.keyCode.LANUP, this.readController("analogUp"));
        m.put(Controller.keyCode.LANDOWN, this.readController("analogDown"));
        m.put(Controller.keyCode.LANLEFT, this.readController("analogLeft"));
        m.put(Controller.keyCode.LANRIGHT, this.readController("analogRight"));
        if (Controller.getInstance().hasRightAnalogController()) {
            m.put(Controller.keyCode.RANUP, this.readController("rightAnalogUp"));
            m.put(Controller.keyCode.RANDOWN, this.readController("rightAnalogDown"));
            m.put(Controller.keyCode.RANLEFT, this.readController("rightAnalogLeft"));
            m.put(Controller.keyCode.RANRIGHT, this.readController("rightAnalogRight"));
        }
        m.put(Controller.keyCode.START, this.readController("start"));
        m.put(Controller.keyCode.SELECT, this.readController("select"));
        m.put(Controller.keyCode.TRIANGLE, this.readController("triangle"));
        m.put(Controller.keyCode.SQUARE, this.readController("square"));
        m.put(Controller.keyCode.CIRCLE, this.readController("circle"));
        m.put(Controller.keyCode.CROSS, this.readController("cross"));
        m.put(Controller.keyCode.L1, this.readController("lTrigger"));
        m.put(Controller.keyCode.R1, this.readController("rTrigger"));
        m.put(Controller.keyCode.HOME, this.readController("home"));
        m.put(Controller.keyCode.HOLD, this.readController("hold"));
        m.put(Controller.keyCode.VOLPLUS, this.readController("volPlus"));
        m.put(Controller.keyCode.VOLMIN, this.readController("volMin"));
        m.put(Controller.keyCode.SCREEN, this.readController("screen"));
        m.put(Controller.keyCode.MUSIC, this.readController("music"));
        for (Controller.keyCode key : Controller.keyCode.values()) {
            if (m.get((Object)key) != null) continue;
            m.remove((Object)key);
        }
        return m;
    }

    public void writeKeys(Map<Integer, Controller.keyCode> keys) {
        for (Map.Entry<Integer, Controller.keyCode> entry : keys.entrySet()) {
            Controller.keyCode key = entry.getValue();
            int value = entry.getKey();
            switch (key) {
                case DOWN: {
                    this.writeKey("down", value);
                    break;
                }
                case UP: {
                    this.writeKey("up", value);
                    break;
                }
                case LEFT: {
                    this.writeKey("left", value);
                    break;
                }
                case RIGHT: {
                    this.writeKey("right", value);
                    break;
                }
                case LANDOWN: {
                    this.writeKey("analogDown", value);
                    break;
                }
                case LANUP: {
                    this.writeKey("analogUp", value);
                    break;
                }
                case LANLEFT: {
                    this.writeKey("analogLeft", value);
                    break;
                }
                case LANRIGHT: {
                    this.writeKey("analogRight", value);
                    break;
                }
                case RANDOWN: {
                    this.writeKey("rightAnalogDown", value);
                    break;
                }
                case RANUP: {
                    this.writeKey("rightAnalogUp", value);
                    break;
                }
                case RANLEFT: {
                    this.writeKey("rightAnalogLeft", value);
                    break;
                }
                case RANRIGHT: {
                    this.writeKey("rightAnalogRight", value);
                    break;
                }
                case TRIANGLE: {
                    this.writeKey("triangle", value);
                    break;
                }
                case SQUARE: {
                    this.writeKey("square", value);
                    break;
                }
                case CIRCLE: {
                    this.writeKey("circle", value);
                    break;
                }
                case CROSS: {
                    this.writeKey("cross", value);
                    break;
                }
                case L1: {
                    this.writeKey("lTrigger", value);
                    break;
                }
                case R1: {
                    this.writeKey("rTrigger", value);
                    break;
                }
                case START: {
                    this.writeKey("start", value);
                    break;
                }
                case SELECT: {
                    this.writeKey("select", value);
                    break;
                }
                case HOME: {
                    this.writeKey("home", value);
                    break;
                }
                case HOLD: {
                    this.writeKey("hold", value);
                    break;
                }
                case VOLMIN: {
                    this.writeKey("volMin", value);
                    break;
                }
                case VOLPLUS: {
                    this.writeKey("volPlus", value);
                    break;
                }
                case SCREEN: {
                    this.writeKey("screen", value);
                    break;
                }
                case MUSIC: {
                    this.writeKey("music", value);
                    break;
                }
            }
        }
        this.writeSettings();
    }

    public void writeController(Map<Controller.keyCode, String> keys) {
        for (Map.Entry<Controller.keyCode, String> entry : keys.entrySet()) {
            Controller.keyCode key = entry.getKey();
            String value = entry.getValue();
            switch (key) {
                case DOWN: {
                    this.writeController("down", value);
                    break;
                }
                case UP: {
                    this.writeController("up", value);
                    break;
                }
                case LEFT: {
                    this.writeController("left", value);
                    break;
                }
                case RIGHT: {
                    this.writeController("right", value);
                    break;
                }
                case LANDOWN: {
                    this.writeController("analogDown", value);
                    break;
                }
                case LANUP: {
                    this.writeController("analogUp", value);
                    break;
                }
                case LANLEFT: {
                    this.writeController("analogLeft", value);
                    break;
                }
                case LANRIGHT: {
                    this.writeController("analogRight", value);
                    break;
                }
                case RANDOWN: {
                    this.writeController("rightAnalogDown", value);
                    break;
                }
                case RANUP: {
                    this.writeController("rightAnalogUp", value);
                    break;
                }
                case RANLEFT: {
                    this.writeController("rightAnalogLeft", value);
                    break;
                }
                case RANRIGHT: {
                    this.writeController("rightAnalogRight", value);
                    break;
                }
                case TRIANGLE: {
                    this.writeController("triangle", value);
                    break;
                }
                case SQUARE: {
                    this.writeController("square", value);
                    break;
                }
                case CIRCLE: {
                    this.writeController("circle", value);
                    break;
                }
                case CROSS: {
                    this.writeController("cross", value);
                    break;
                }
                case L1: {
                    this.writeController("lTrigger", value);
                    break;
                }
                case R1: {
                    this.writeController("rTrigger", value);
                    break;
                }
                case START: {
                    this.writeController("start", value);
                    break;
                }
                case SELECT: {
                    this.writeController("select", value);
                    break;
                }
                case HOME: {
                    this.writeController("home", value);
                    break;
                }
                case HOLD: {
                    this.writeController("hold", value);
                    break;
                }
                case VOLMIN: {
                    this.writeController("volMin", value);
                    break;
                }
                case VOLPLUS: {
                    this.writeController("volPlus", value);
                    break;
                }
                case SCREEN: {
                    this.writeController("screen", value);
                    break;
                }
                case MUSIC: {
                    this.writeController("music", value);
                    break;
                }
            }
        }
        this.writeSettings();
    }

    private int readKey(String keyName) {
        String str = this.getProperty("keys." + keyName);
        if (str == null) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    private void writeKey(String keyName, int key) {
        this.setProperty("keys." + keyName, Integer.toString(key));
    }

    private String readController(String name) {
        return this.getProperty("controller." + name);
    }

    private void writeController(String name, String value) {
        this.setProperty("controller." + name, value);
    }

    public void readRecent(String cat, List<RecentElement> recent) {
        String r;
        int i = 0;
        while ((r = this.getProperty("gui.recent." + cat + "." + i)) != null) {
            String title = this.getProperty("gui.recent." + cat + "." + i + ".title");
            recent.add(new RecentElement(r, title));
            ++i;
        }
    }

    public void writeRecent(String cat, List<RecentElement> recent) {
        Enumeration<Object> keys = this.loadedSettings.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith("gui.recent." + cat)) continue;
            this.loadedSettings.remove(key);
        }
        int index = 0;
        for (RecentElement elem : recent) {
            this.setProperty("gui.recent." + cat + "." + index, elem.path);
            if (elem.title != null) {
                this.setProperty("gui.recent." + cat + "." + index + ".title", elem.title);
            }
            ++index;
        }
        this.writeSettings();
    }

    public Font getFont() {
        if (this.loadedFont != null) {
            return this.loadedFont;
        }
        Font font = new Font("SansSerif", 0, 1);
        int fontsize = 11;
        try {
            Font base = font;
            String fontname = this.readString("gui.font.name");
            String fontfilename = this.readString("gui.font.file");
            String fontsizestr = this.readString("gui.font.size");
            if (fontfilename.length() != 0) {
                File fontfile = new File(fontfilename);
                if (fontfile.exists()) {
                    base = Font.createFont(0, fontfile);
                } else {
                    System.err.println("gui.font.file '" + fontfilename + "' doesn't exist.");
                }
            } else if (fontname.length() != 0) {
                base = new Font(fontname, 0, 1);
            }
            if (fontsizestr.length() > 0) {
                fontsize = Integer.parseInt(fontsizestr);
            } else {
                System.err.println("gui.font.size setting is missing.");
            }
            font = base.deriveFont(0, fontsize);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(base);
        }
        catch (NumberFormatException e) {
            System.err.println("gui.font.size setting is invalid.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        this.loadedFont = font;
        return font;
    }

    public void registerSettingsListener(String name, String option, ISettingsListener listener) {
        this.removeSettingsListener(name, option);
        SettingsListenerInfo info = new SettingsListenerInfo(name, option, listener);
        this.allListeners.add(info);
        List<ISettingsListener> listenersForKey = this.listenersByKey.get(option);
        if (listenersForKey == null) {
            listenersForKey = new LinkedList<ISettingsListener>();
            this.listenersByKey.put(option, listenersForKey);
        }
        listenersForKey.add(listener);
        String value = this.getProperty(option);
        if (value != null) {
            listener.settingsValueChanged(option, value);
        }
    }

    public void removeSettingsListener(String name, String option) {
        ListIterator<SettingsListenerInfo> lit = this.allListeners.listIterator();
        while (lit.hasNext()) {
            SettingsListenerInfo info = lit.next();
            if (!info.equals(name, option)) continue;
            lit.remove();
            String key = info.getKey();
            List<ISettingsListener> listenersForKey = this.listenersByKey.get(key);
            listenersForKey.remove(info.getListener());
            if (!listenersForKey.isEmpty()) continue;
            this.listenersByKey.remove(key);
        }
    }

    public void removeSettingsListener(String name) {
        this.removeSettingsListener(name, null);
    }

    private void triggerSettingsListener(String key, String value) {
        List<ISettingsListener> listenersForKey = this.listenersByKey.get(key);
        if (listenersForKey != null) {
            for (ISettingsListener listener : listenersForKey) {
                listener.settingsValueChanged(key, value);
            }
        }
    }

    public void setDirectoryMapping(String directoryName, String mappedDirectoryName) {
        this.directoryMapping.put(directoryName, mappedDirectoryName);
    }

    public String getDirectoryMapping(String directoryName) {
        return this.directoryMapping.get(directoryName);
    }

    private static class SortedProperties
    extends Properties {
        private static final long serialVersionUID = -8127868945637348944L;

        public SortedProperties(Properties defaultSettings) {
            super(defaultSettings);
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            Enumeration<Object> keysEnum = super.keys();
            ArrayList<Object> keyList = Collections.list(keysEnum);
            Collections.sort(keyList);
            return Collections.enumeration(keyList);
        }
    }
}

