/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.sound.ISampleSource;
import jpcsp.sound.SoundVoice;

public class SampleSourcePCM
implements ISampleSource {
    private SoundVoice voice;
    private int addr;
    private int size;
    private IMemoryReader memoryReader;
    private int sampleIndex;
    private int samples;
    private boolean looping;

    public SampleSourcePCM(SoundVoice voice, int addr, int samples, int loopMode) {
        this.voice = voice;
        this.addr = addr;
        this.samples = samples;
        this.size = samples << 1;
        this.sampleIndex = samples;
        this.looping = loopMode >= 0;
    }

    @Override
    public int getNextSample() {
        if (this.sampleIndex >= this.samples) {
            if (!this.voice.isOn()) {
                this.looping = false;
                return 0;
            }
            this.resetToStart();
        }
        ++this.sampleIndex;
        return this.memoryReader.readNext();
    }

    @Override
    public void resetToStart() {
        this.memoryReader = MemoryReader.getMemoryReader(this.addr, this.size, 2);
        this.sampleIndex = 0;
    }

    @Override
    public boolean isEnded() {
        if (this.looping) {
            return false;
        }
        return this.sampleIndex >= this.samples;
    }
}

