/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import jpcsp.Emulator;
import jpcsp.state.InvalidStateException;

public class StateInputStream
extends ObjectInputStream {
    public StateInputStream(InputStream in) throws IOException {
        super(in);
    }

    public int readVersion(int maxVersion) throws IOException {
        int version = this.readInt();
        if (version > maxVersion) {
            throw new InvalidStateException(String.format("Unsupported State version %d(maxVersion=%d)", version, maxVersion));
        }
        return version;
    }

    public void readInts(int[] a) throws IOException {
        this.readInts(a, 0, a.length);
    }

    public int[] readIntsWithLength() throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        int[] a = new int[length];
        this.readInts(a);
        return a;
    }

    public void readInts(int[] a, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            a[i + offset] = this.readInt();
        }
    }

    public void readFloats(float[] a) throws IOException {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.readFloat();
        }
    }

    public void readBooleans(boolean[] a) throws IOException {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.readBoolean();
        }
    }

    public void readBytes(byte[] a) throws IOException {
        this.readBytes(a, 0, a.length);
    }

    public void readBytes(byte[] a, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            a[i + offset] = this.readByte();
        }
    }

    public byte[] readBytesWithLength() throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        byte[] a = new byte[length];
        this.readBytes(a);
        return a;
    }

    public String readString() throws IOException {
        try {
            Object a = this.readObject();
            if (a == null) {
                return null;
            }
            return a.toString();
        }
        catch (ClassNotFoundException e) {
            Emulator.log.error((Object)"readString", (Throwable)e);
            return null;
        }
    }
}

