/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.state;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class StateOutputStream
extends ObjectOutputStream {
    public static final int NULL_ARRAY_LENGTH = -1;

    public StateOutputStream(OutputStream out) throws IOException {
        super(out);
    }

    public void writeVersion(int version) throws IOException {
        this.writeInt(version);
    }

    public void writeInts(int[] a) throws IOException {
        this.writeInts(a, 0, a.length);
    }

    public void writeIntsWithLength(int[] a) throws IOException {
        if (a == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(a.length);
            this.writeInts(a, 0, a.length);
        }
    }

    public void writeInts(int[] a, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.writeInt(a[i + offset]);
        }
    }

    public void writeFloats(float[] a) throws IOException {
        for (int i = 0; i < a.length; ++i) {
            this.writeFloat(a[i]);
        }
    }

    public void writeBooleans(boolean[] a) throws IOException {
        for (int i = 0; i < a.length; ++i) {
            this.writeBoolean(a[i]);
        }
    }

    public void writeBytes(byte[] a) throws IOException {
        this.writeBytes(a, 0, a.length);
    }

    public void writeBytesWithLength(byte[] a) throws IOException {
        if (a == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(a.length);
            this.writeBytes(a);
        }
    }

    public void writeBytes(byte[] a, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.writeByte(a[i + offset]);
        }
    }

    public void writeString(String s) throws IOException {
        this.writeObject(s);
    }
}

