/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class FileUtil {
    public static String getExtension(File file) {
        String base = file.getName();
        int index = base.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        return base.substring(index + 1).toLowerCase();
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        int count;
        byte[] temp = new byte[65536];
        while ((count = is.read(temp)) >= 0) {
            os.write(temp, 0, count);
        }
    }

    public static byte[] readInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        FileUtil.copyStream(is, os);
        return os.toByteArray();
    }

    public static byte[] readURL(URL url) throws IOException {
        try (InputStream inputStream = url.openStream();){
            byte[] byArray = FileUtil.readInputStream(inputStream);
            return byArray;
        }
    }

    public static String getURLBaseName(URL url) {
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        int i = path.lastIndexOf(47);
        if (i < 0) {
            return path;
        }
        return path.substring(i + 1);
    }

    public static void writeBytes(File file, byte[] data) throws FileNotFoundException {
        try (FileOutputStream os = new FileOutputStream(file);){
            os.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void readAll(InputStream is, byte[] buffer, int offset, int len) throws IOException {
        int aoffset = offset;
        int remaining = len;
        while (remaining > 0) {
            int read = is.read(buffer, aoffset, remaining);
            if (read <= 0) continue;
            remaining -= read;
            aoffset += read;
        }
    }

    public static File findFolderNameInAncestors(File base, String name) {
        for (File current = base; current != null; current = current.getParentFile()) {
            File file = new File(current, name);
            if (!file.exists()) continue;
            return file.getAbsoluteFile();
        }
        return null;
    }
}

